var ajaxCaller = {
	shouldDebug: true,
	getXML: function(url,xml,callbackFunction) {
		this._callServer(url, xml,"GET",false, callbackFunction);
	},
	postXML: function(url, xml, callbackFunction) {
		this._callServer(url, xml,"POST",false, callbackFunction);
	},
	_callServer:function(url,xml,requestMethod,expectingXML,callbackFunction){
		var xReq=this._createXMLHttpRequest();
		if (xReq){
		    xReq.open(requestMethod, url, true);
			xReq.onreadystatechange = function() {
				ajaxCaller._onResponseStateChange(xReq,expectingXML,callbackFunction);
			}
			xReq.setRequestHeader("Content-Type","text/xml");
			xReq.send(xml);
		}
	},
	 _onResponseStateChange: function(xReq,expectingXML,callbackFunction) {
		if (xReq.readyState < 4) { //Still waiting
		  return;
		}
		if (xReq.readyState == 4) { //Transmit to actual callback
			var content=expectingXML ? xReq.responseXML : xReq.responseText;
			callbackFunction(content);
		}
	},
	_createXMLHttpRequest:function(){
		if (window.XMLHttpRequest){
			return new XMLHttpRequest();
		}else if (window.ActiveXObject) {
			return new ActiveXObject('Microsoft.XMLHTTP');
		} else {
			this._error("Could not create XMLHttpRequest on this browser");
			return null;
		}
	},
	 _error: function(message) {
      if (this.shouldDebug) {
        alert("AjaxJS ERROR:\n\n" + message);
      }
	}
};
