/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class UserConfigManager {
    private static String USER_CONFIG_PATH = "tddj/user-config.xml";

    private String getPath() {
        String basePath = this.getClass().getResource("/").getPath();
        basePath = basePath.replace("WEB-INF/classes/", "");
        return basePath + USER_CONFIG_PATH;
    }

    private Document getDocument() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath()));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    private void writeDocument(Document document) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(this.getPath()), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String setColor(String userName, String colorCode) {
        Document document = this.getDocument();
        Element root = document.getRootElement();
        boolean flag = false;
        Element user = null;
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String str = element.attribute("name").getValue();
            if (str == null || !str.equals(userName)) continue;
            flag = true;
            user = element;
            break;
        }
        if (flag) {
            user.addAttribute("color", colorCode);
        } else {
            user = root.addElement("user").addAttribute("name", userName).addAttribute("color", colorCode);
        }
        this.writeDocument(document);
        return userName;
    }

    public String getColor(String userName) {
        String resultColor = "";
        Document document = this.getDocument();
        Element root = document.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String str = element.attribute("name").getValue();
            if (str == null || !str.equals(userName)) continue;
            resultColor = element.attribute("color").getValue();
            break;
        }
        return resultColor;
    }

    public static void main(String[] args) {
        UserConfigManager usrManager = new UserConfigManager();
        usrManager.setColor("1", Math.random() + "");
    }
}

