/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.util;

import java.text.SimpleDateFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelCheckUtil {
    public static String getStringCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case 4: {
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
                    result = TIME_FORMATTER.format(cell.getDateCellValue());
                    break;
                }
                cell.setCellType(1);
                String cellValue = cell.toString();
                result = "" + cellValue;
                break;
            }
            case 1: {
                if (cell.getRichStringCellValue() == null) {
                    result = null;
                    break;
                }
                result = cell.getRichStringCellValue().getString();
                break;
            }
            case 3: {
                result = null;
                break;
            }
            case 2: {
                try {
                    result = String.valueOf(cell.getNumericCellValue());
                }
                catch (Exception e) {
                    result = cell.getRichStringCellValue().getString();
                }
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }
}

