/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.util;

import com.jsegov.tddj.vo.FTP;
import com.jsegov.tddj.vo.XZQ;
import com.jsegov.tddj.vo.ZGZH;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class Common {
    static Log log = LogFactory.getLog((String)"Common");
    private static String ZGZHPATH = "tddj/zgzh.xml";

    public Document getTddjXml() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    public String getUserName() {
        SAXReader sr = new SAXReader();
        Document document = null;
        String name = "";
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
            org.dom4j.Element root = document.getRootElement();
            Node node1 = root.selectSingleNode("//Config/user");
            DefaultElement element = (DefaultElement)node1;
            name = element.attribute("name").getText();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return name;
    }

    public String getUserPassword() {
        SAXReader sr = new SAXReader();
        Document document = null;
        String password = "";
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
            org.dom4j.Element root = document.getRootElement();
            Node node1 = root.selectSingleNode("//Config/user");
            DefaultElement element = (DefaultElement)node1;
            password = element.attribute("password").getText();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return password;
    }

    public XZQ getXZQ() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node1 = root.selectSingleNode("//Config/xzq/xzqName");
        String xzqName = node1.getText();
        Node node2 = root.selectSingleNode("//Config/xzq/xzqShortName");
        String xzqShorName = node2.getText();
        Node node3 = root.selectSingleNode("//Config/xzq/gytdsyz");
        String gyFormat = node3.getText();
        Node node4 = root.selectSingleNode("//Config/xzq/jttdsyz");
        String jyFormat = node4.getText();
        Node node5 = root.selectSingleNode("//Config/xzq/jttdsuz");
        String juFormat = node5.getText();
        Node node7 = root.selectSingleNode("//Config/xzq/txqlzms");
        String txFormat = node7.getText();
        Node node8 = root.selectSingleNode("//Config/xzq/bh");
        String bh = node8.getText();
        XZQ xzq = new XZQ();
        xzq.setXzqName(xzqName);
        xzq.setXzqShortName(xzqShorName);
        xzq.setGytdsyzFormat(gyFormat);
        xzq.setJttdsyzFormat(jyFormat);
        xzq.setJttdsuzFormat(juFormat);
        xzq.setTxqlzmsFormat(txFormat);
        xzq.setBh(bh);
        return xzq;
    }

    public Boolean isFilterByDjh() {
        Boolean resultVal = false;
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node = root.selectSingleNode("//Config/filter/djh");
        String nodeVal = node.getText();
        if (nodeVal != null && nodeVal.equals("1")) {
            resultVal = true;
        }
        return resultVal;
    }

    public Boolean isFilterByDwdm() {
        Boolean resultVal = false;
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node = root.selectSingleNode("//Config/filter/dwdm");
        String nodeVal = node.getText();
        if (nodeVal != null && nodeVal.equals("1")) {
            resultVal = true;
        }
        return resultVal;
    }

    public void setCURRENTYEAR(String curYear) {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node1 = root.selectSingleNode("//Config/currentYear/value");
        node1.setText(curYear);
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("GBK");
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(this.getPath() + "conf/tddj/tddj.xml")), format);
            output.write(document);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCURRENTYEAR() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node1 = root.selectSingleNode("//Config/currentYear/value");
        String curYear = node1.getText();
        return curYear;
    }

    public List<String> getAllNodeid() {
        ArrayList<String> listAllNodeid = new ArrayList<String>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/node.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        List nodes = root.selectNodes("node");
        for (int i = 0; i < nodes.size(); ++i) {
            listAllNodeid.add(((Node)nodes.get(i)).getText());
        }
        return listAllNodeid;
    }

    public List<String> getAllSqlx() {
        ArrayList<String> listAllSqlx = new ArrayList<String>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/sqlx.xml"));
        }
        catch (DocumentException e) {
            log.error((Object)("Common.getAllSqlx:" + (Object)((Object)e)));
        }
        org.dom4j.Element root = document.getRootElement();
        List djlxNodes = root.selectNodes("djlx");
        for (int i = 0; i < djlxNodes.size(); ++i) {
            org.dom4j.Element djlxElement = (org.dom4j.Element)djlxNodes.get(i);
            List qsxzNodes = djlxElement.selectNodes("qsxz");
            for (int j = 0; j < qsxzNodes.size(); ++j) {
                org.dom4j.Element qsxzElement = (org.dom4j.Element)qsxzNodes.get(j);
                List sqlxNodes = qsxzElement.selectNodes("sqlx");
                for (int k = 0; k < sqlxNodes.size(); ++k) {
                    org.dom4j.Element sqlxElement = (org.dom4j.Element)sqlxNodes.get(k);
                    if (sqlxElement.getText() == null || sqlxElement.getText().equals("") || listAllSqlx.contains(sqlxElement.getText())) continue;
                    listAllSqlx.add(sqlxElement.getText());
                }
            }
        }
        return listAllSqlx;
    }

    private String getPath() {
        return this.getClass().getResource("/").getPath();
    }

    public FTP getFTP() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        Node node1 = root.selectSingleNode("//Config/ftp/ip");
        String ip = node1.getText();
        Node node2 = root.selectSingleNode("//Config/ftp/port");
        String port = node2.getText();
        FTP ftp = new FTP();
        ftp.setIp(ip);
        ftp.setPort(port);
        return ftp;
    }

    public String getPrecision(String type) {
        String precision = "";
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/tddj.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        if (type.equals("syq")) {
            Node node = root.selectSingleNode("//Config/precision/area/syq");
            precision = node.getText();
        } else if (type.equals("suq")) {
            Node node = root.selectSingleNode("//Config/precision/area/suq");
            precision = node.getText();
        } else if (type.equals("je")) {
            Node node = root.selectSingleNode("//Config/precision/money");
            precision = node.getText();
        } else if (type.equals("default")) {
            Node node = root.selectSingleNode("//Config/precision/area/default");
            precision = node.getText();
        }
        return precision;
    }

    public String getFileNameByCode(String fileCode) {
        String fileName = "";
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath() + "conf/tddj/FileRename.xml"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        org.dom4j.Element root = document.getRootElement();
        List list = root.selectNodes("//FileList/File[@FileCode=\\'" + fileCode + "\\']");
        for (org.dom4j.Element elm : list) {
            fileName = elm.attributeValue("FileName");
        }
        return fileName;
    }

    public String getArchiveProjectId(String xml) {
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        SAXBuilder sb = new SAXBuilder();
        String archiveProjectId = null;
        try {
            org.jdom.Document doc = sb.build(source);
            Element root = doc.getRootElement();
            Element result = root.getChild("archive");
            if (result.getAttributeValue("result") != null && result.getAttributeValue("result").equals("succeed")) {
                Element archive = root.getChild("archive");
                List field = archive.getChildren("field");
                Element fieldId = (Element)field.get(field.size() - 1);
                archiveProjectId = fieldId.getText();
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return archiveProjectId;
    }

    public List<ZGZH> getZGZHList() {
        Document document = this.getDocument();
        org.dom4j.Element root = document.getRootElement();
        ArrayList<ZGZH> result = new ArrayList<ZGZH>();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            org.dom4j.Element element = (org.dom4j.Element)it.next();
            ZGZH zgzh = new ZGZH();
            zgzh.setUserName(element.attribute("name").getValue());
            zgzh.setZgzh(element.getTextTrim());
            result.add(zgzh);
        }
        return result;
    }

    private Document getDocument() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(this.getPath2() + ZGZHPATH));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    private String getPath2() {
        String basePath = this.getClass().getResource("/").getPath();
        basePath = basePath.replace("WEB-INF/classes/", "");
        return basePath;
    }

    public void deleteZGZH(ZGZH zgzh) {
        Document document = this.getDocument();
        org.dom4j.Element root = document.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            org.dom4j.Element element = (org.dom4j.Element)it.next();
            String str = element.attribute("name").getValue();
            if (str == null || !str.equals(zgzh.getUserName())) continue;
            root.remove(element);
            this.writeDocument(document);
        }
    }

    public void deleteZGZH(String userName) {
        ZGZH zgzh = new ZGZH();
        zgzh.setUserName(userName);
        this.deleteZGZH(zgzh);
    }

    public void editZGZH(ZGZH zgzh) {
        Document document = this.getDocument();
        org.dom4j.Element root = document.getRootElement();
        boolean flag = false;
        org.dom4j.Element user = null;
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            org.dom4j.Element element = (org.dom4j.Element)it.next();
            String str = element.attribute("name").getValue();
            if (str == null || !str.equals(zgzh.getUserName())) continue;
            flag = true;
            user = element;
            break;
        }
        if (flag) {
            user.setText(zgzh.getZgzh());
        } else {
            user = root.addElement("user").addAttribute("name", zgzh.getUserName()).addText(zgzh.getZgzh());
        }
        this.writeDocument(document);
    }

    private void writeDocument(Document document) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(this.getPath2() + ZGZHPATH), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

