/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.services;

import com.jsegov.tddj.check.CreateTaskCheck;
import com.jsegov.tddj.services.interf.INewProjectCheckService;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.NewProjectCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerCheckService {
    @Autowired
    INewProjectCheckService newProjectCheckService;

    public String serverCheck(String djlx, String sqlx, String djh, String tdzh, String qlr, String tdzl, String qsxz) {
        String resultMsg = "";
        CheckReturnMsg msg = new CheckReturnMsg();
        String checkModel = "";
        String alertMsg = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("djlx", djlx);
        params.put("tdzl", tdzl);
        params.put("djh", djh);
        params.put("tdzh", tdzh);
        params.put("qlr", qlr);
        params.put("qsxz", qsxz);
        params.put("sqlx", sqlx);
        params.put("checkCode", 0);
        List newProjectCheckList = this.newProjectCheckService.getNewProjectCheckByDjlx(djlx);
        ArrayList<String> returnMsgList = new ArrayList<String>();
        for (NewProjectCheck newProjectCheck : newProjectCheckList) {
            CheckReturnMsg checkMsg;
            Integer checkCode = Integer.parseInt(newProjectCheck.getCheckCode());
            checkModel = newProjectCheck.getCheckModel();
            alertMsg = newProjectCheck.getAlertMsg();
            if (StringUtils.isNotBlank((String)alertMsg)) {
                alertMsg = alertMsg.replaceAll("#DJH#", djh);
                alertMsg = alertMsg.replaceAll("#TDZH#", tdzh);
                alertMsg = alertMsg.replaceAll("#QLR#", qlr);
                alertMsg = alertMsg.replaceAll("#TDZL#", tdzl);
            }
            params.remove("checkCode");
            params.put("checkCode", checkCode);
            CreateTaskCheck checkFn = this.newProjectCheckService.getCheckFn(checkCode);
            if (checkFn == null || (checkMsg = checkFn.run(params)) == null || !StringUtils.isNotBlank((String)checkMsg.getReturnMessage()) || !StringUtils.isNotBlank((String)alertMsg)) continue;
            msg.setReturnMessage(checkMsg.getReturnMessage());
            returnMsgList.add(alertMsg);
            msg.setReturnMessageList(returnMsgList);
            if (StringUtils.isNotEmpty((String)checkModel)) {
                if (StringUtils.equals((String)checkModel.toUpperCase(), (String)"CONFIRM")) {
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    continue;
                }
                if (!StringUtils.equals((String)checkModel.toUpperCase(), (String)"ALERT")) continue;
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                break;
            }
            if (checkMsg.getCheckModel().toString().toUpperCase().equals("CONFIRM")) {
                msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                continue;
            }
            if (!checkMsg.getCheckModel().toString().toUpperCase().equals("ALERT")) continue;
            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
            break;
        }
        if (msg != null && msg.getCheckModel() != null && StringUtils.equals((String)(msg.getCheckModel() + ""), (String)"ALERT") && msg.getReturnMessageList() != null && msg.getReturnMessageList().size() > 0) {
            resultMsg = msg.getReturnMessageList().get(0) + "";
        }
        return resultMsg;
    }

    public INewProjectCheckService getNewProjectCheckService() {
        return this.newProjectCheckService;
    }

    public void setNewProjectCheckService(INewProjectCheckService newProjectCheckService) {
        this.newProjectCheckService = newProjectCheckService;
    }
}

