/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.services;

import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GhkService
implements IGHKService {
    @Autowired
    GHKDAO ghkDAO;
    @Autowired
    IBHService bhService;

    public void deleteGHK(String projectId) {
        this.ghkDAO.deleteGHK(projectId);
    }

    public List getGHK(GHK ghk) {
        return this.ghkDAO.getGHK(ghk);
    }

    public GHK getGHK(String projectId) {
        return this.ghkDAO.getGHK(projectId);
    }

    public void insertGHK(GHK ghk) {
        this.ghkDAO.insertGHK(ghk);
    }

    public void insertGHK(SPB spb) {
        this.ghkDAO.insertGHK(this.getGHKBySPB(spb));
    }

    public void updateGHK(GHK ghk) {
        this.ghkDAO.updateGHK(ghk);
    }

    public void logoutGHK(String tdzh) {
        GHK ghk = new GHK();
        ghk.setTdzh(tdzh);
        List ghkList = this.ghkDAO.getGHK(ghk);
        if (ghkList.size() > 0) {
            ghk = (GHK)ghkList.get(0);
        }
        ghk.setIslogout(Integer.valueOf(1));
        this.ghkDAO.updateGHK(ghk);
    }

    public void updateGHK(SPB spb) {
        String ghkh = "";
        String qlr = spb.getRf1_dwmc();
        String dwxz = spb.getRf1_dwxz();
        String txdz = spb.getRf1_txdz();
        String sfzmtype = spb.getRf1_sfzmtype();
        String sfzmnum = spb.getRf1_sfzmnum();
        if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
            GHK ghk = new GHK();
            ghk.setSfzmnum(sfzmnum);
            ghk.setSfzmtype(sfzmtype);
            List ghkList = this.ghkDAO.getGHK(ghk);
            if (ghkList.size() > 0) {
                ghk = (GHK)ghkList.get(0);
                ghkh = ghk.getGhkh();
            } else {
                ghkh = this.bhService.getGHKBH();
            }
        } else {
            ghkh = this.bhService.getGHKBH();
        }
        GHK ghkResult = this.getGHK(spb.getProjectId());
        ghkResult.setGhkh(ghkh);
        ghkResult.setQlr(qlr);
        ghkResult.setSfzmnum(sfzmnum);
        ghkResult.setDwxz(dwxz);
        ghkResult.setTxdz(txdz);
        ghkResult.setSfzmtype(sfzmtype);
        ghkResult.setProjectId(spb.getProjectId());
        ghkResult.setDjh(spb.getDjh());
        ghkResult.setTh(spb.getTh());
        ghkResult.setZl(spb.getZl());
        ghkResult.setQsxz(spb.getQsxz());
        ghkResult.setYt(spb.getYt());
        if (spb.getQsxz() != null && spb.getQsxz().indexOf("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743") > -1) {
            if (spb.getZdmj() != null && !spb.getZdmj().equals("")) {
                ghkResult.setMj(Double.valueOf(spb.getZdmj()));
            }
        } else if (spb.getSyqmj() != null && spb.getSyqmj() != 0.0) {
            ghkResult.setMj(spb.getSyqmj());
        } else if (spb.getZdmj() != null && !spb.getZdmj().equals("")) {
            ghkResult.setMj(Double.valueOf(spb.getZdmj()));
        }
        ghkResult.setJbr(spb.getScr());
        ghkResult.setIslogout(Integer.valueOf(0));
        ghkResult.setDwdm(spb.getDwdm());
        ghkResult.setTdzh(spb.getTdzh());
        ghkResult.setSyqlx(spb.getSyqlx());
        String rq = spb.getPzrq() != null ? CommonUtil.formateDate((Date)spb.getPzrq()) : (spb.getShrq() != null ? CommonUtil.formateDate((Date)spb.getShrq()) : CommonUtil.getCurrStrDate());
        ghkResult.setRq(rq);
        this.ghkDAO.updateGHK(ghkResult);
    }

    public GHK getGHKBySPB(SPB spb) {
        String ghkh;
        String qlr = spb.getRf1_dwmc();
        String dwxz = spb.getRf1_dwxz();
        String txdz = spb.getRf1_txdz();
        String sfzmtype = spb.getRf1_sfzmtype();
        String sfzmnum = spb.getRf1_sfzmnum();
        if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
            GHK ghk = new GHK();
            ghk.setSfzmnum(sfzmnum);
            ghk.setSfzmtype(sfzmtype);
            List ghkList = this.ghkDAO.getGHK(ghk);
            if (ghkList.size() > 0) {
                GHK ghkResult = (GHK)ghkList.get(0);
                ghkh = ghkResult.getGhkh();
            } else {
                ghkh = this.bhService.getGHKBH();
            }
        } else {
            ghkh = this.bhService.getGHKBH();
        }
        GHK newGHK = new GHK();
        newGHK.setQlr(qlr);
        newGHK.setSfzmnum(sfzmnum);
        newGHK.setDwxz(dwxz);
        newGHK.setTxdz(txdz);
        newGHK.setSfzmtype(sfzmtype);
        newGHK.setProjectId(spb.getProjectId());
        newGHK.setDjh(spb.getDjh());
        newGHK.setTh(spb.getTh());
        newGHK.setZl(spb.getZl());
        newGHK.setQsxz(spb.getQsxz());
        newGHK.setYt(spb.getYt());
        if (spb.getQsxz() != null && spb.getQsxz().indexOf("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743") > -1) {
            if (spb.getZdmj() != null && !spb.getZdmj().equals("")) {
                newGHK.setMj(Double.valueOf(spb.getZdmj()));
            }
        } else if (spb.getSyqmj() != null && spb.getSyqmj() != 0.0) {
            newGHK.setMj(spb.getSyqmj());
        } else if (spb.getZdmj() != null && !spb.getZdmj().equals("")) {
            newGHK.setMj(Double.valueOf(spb.getZdmj()));
        }
        newGHK.setJbr(spb.getJbr());
        newGHK.setGhkh(ghkh);
        newGHK.setIslogout(Integer.valueOf(0));
        newGHK.setDwdm(spb.getDwdm());
        newGHK.setTdzh(spb.getTdzh());
        newGHK.setSyqlx(spb.getSyqlx());
        String rq = spb.getPzrq() != null ? CommonUtil.formateDate((Date)spb.getPzrq()) : (spb.getShrq() != null ? CommonUtil.formateDate((Date)spb.getShrq()) : CommonUtil.getCurrStrDate());
        newGHK.setRq(rq);
        return newGHK;
    }

    public void insertGHK(SQB sqb) {
        String ghkh;
        String qlr = sqb.getRf1_dwmc();
        String dwxz = sqb.getRf1_dwxz();
        String txdz = sqb.getRf1_txdz();
        String sfzmtype = sqb.getRf1_sfzmtype();
        String sfzmnum = sqb.getRf1_sfzmnum();
        if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
            GHK ghk = new GHK();
            ghk.setSfzmnum(sfzmnum);
            ghk.setSfzmtype(sfzmtype);
            List ghkList = this.ghkDAO.getGHK(ghk);
            if (ghkList.size() > 0) {
                GHK ghkResult = (GHK)ghkList.get(0);
                ghkh = ghkResult.getGhkh();
            } else {
                ghkh = this.bhService.getGHKBH();
            }
        } else {
            ghkh = this.bhService.getGHKBH();
        }
        GHK newGHK = new GHK();
        newGHK.setQlr(qlr);
        newGHK.setSfzmnum(sfzmnum);
        newGHK.setDwxz(dwxz);
        newGHK.setTxdz(txdz);
        newGHK.setSfzmtype(sfzmtype);
        newGHK.setProjectId(sqb.getProjectId());
        newGHK.setDjh(sqb.getDjh());
        newGHK.setTh(sqb.getTh());
        newGHK.setZl(sqb.getZl());
        newGHK.setQsxz(sqb.getQsxz());
        newGHK.setYt(sqb.getYt());
        newGHK.setMj(sqb.getSyqmj());
        newGHK.setGhkh(ghkh);
        newGHK.setIslogout(Integer.valueOf(0));
        newGHK.setDwdm(sqb.getDwdm());
        newGHK.setTdzh(sqb.getSqsbh());
        newGHK.setSyqlx(sqb.getSyqlx());
        newGHK.setRq(CommonUtil.getCurrStrDate());
        this.ghkDAO.insertGHK(newGHK);
    }

    public void updateGHK(SQB sqb) {
        String qlr = sqb.getRf1_dwmc();
        String dwxz = sqb.getRf1_dwxz();
        String txdz = sqb.getRf1_txdz();
        String sfzmtype = sqb.getRf1_sfzmtype();
        String sfzmnum = sqb.getRf1_sfzmnum();
        String ghkh = "";
        if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
            GHK ghk = new GHK();
            ghk.setSfzmnum(sfzmnum);
            ghk.setSfzmtype(sfzmtype);
            List ghkList = this.ghkDAO.getGHK(ghk);
            if (ghkList.size() > 0) {
                ghk = (GHK)ghkList.get(0);
                ghkh = ghk.getGhkh();
            } else {
                ghkh = this.bhService.getGHKBH();
            }
        } else {
            ghkh = this.bhService.getGHKBH();
        }
        GHK ghkResult = this.getGHK(sqb.getProjectId());
        ghkResult.setGhkh(ghkh);
        ghkResult.setQlr(qlr);
        ghkResult.setSfzmnum(sfzmnum);
        ghkResult.setDwxz(dwxz);
        ghkResult.setTxdz(txdz);
        ghkResult.setSfzmtype(sfzmtype);
        ghkResult.setProjectId(sqb.getProjectId());
        ghkResult.setDjh(sqb.getDjh());
        ghkResult.setTh(sqb.getTh());
        ghkResult.setZl(sqb.getZl());
        ghkResult.setQsxz(sqb.getQsxz());
        ghkResult.setYt(sqb.getYt());
        ghkResult.setMj(sqb.getSyqmj());
        ghkResult.setIslogout(Integer.valueOf(0));
        ghkResult.setDwdm(sqb.getDwdm());
        ghkResult.setTdzh(sqb.getSqsbh());
        ghkResult.setSyqlx(sqb.getSyqlx());
        ghkResult.setRq(CommonUtil.getCurrStrDate());
        this.ghkDAO.updateGHK(ghkResult);
    }

    public GHK getGHKByTdzh(String tdzh) {
        GHK ghk = new GHK();
        ghk.setTdzh(tdzh);
        List ghkList = this.ghkDAO.getGHK(ghk);
        if (ghkList.size() > 0) {
            return (GHK)ghkList.get(0);
        }
        return null;
    }
}

