/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.services;

import com.jsegov.tddj.dao.DJKDAO;
import com.jsegov.tddj.dao.DJKXBDAO;
import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.SPB;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DjkXbService
implements IDJKXBService {
    @Autowired
    DJKXBDAO djkxbDAO;
    @Autowired
    DJKDAO djkDAO;
    @Autowired
    GHKDAO ghkDAO;

    public void deleteDJKXB(String projectId) {
        this.djkxbDAO.deleteDJKXB(projectId);
    }

    public DJKXB getDJKXB(String projectId) {
        return this.djkxbDAO.getDJKXB(projectId);
    }

    public void insertDJKXB(DJKXB djkxb) {
        this.djkxbDAO.insertDJKXB(djkxb);
    }

    public void updateDJKXB(DJKXB djkxb) {
        this.djkxbDAO.updateDJKXB(djkxb);
    }

    public void insertDJKXB(SPB spb) {
        if (spb.getSqlx().indexOf("\u521d\u59cb\u767b\u8bb0") > 0 || !spb.getXbnr().equals("")) {
            this.djkxbDAO.insertDJKXB(this.getDjkxbBySPB(spb));
        }
    }

    public List getDJKXBList(Integer djkId) {
        return this.djkxbDAO.getDJKXBList(djkId);
    }

    public void updateDJKXB(SPB spb) {
        if (spb.getSqlx().indexOf("\u521d\u59cb\u767b\u8bb0") > 0 || !spb.getXbnr().equals("")) {
            this.djkxbDAO.updateDJKXB(this.getDjkxbBySPB(spb));
        }
    }

    public DJKXB getDjkxbBySPB(SPB spb) {
        String djh = spb.getDjh();
        String projectId = spb.getProjectId();
        DJK djk = this.djkDAO.getDJKByDjh(djh);
        Integer djkId = 0;
        if (djk != null) {
            djkId = djk.getDjkId();
        }
        String djkbh = "";
        if (djk != null) {
            djkbh = djk.getDjkbh();
        }
        GHK ghk = this.ghkDAO.getGHK(projectId);
        String ghkh = "";
        if (ghk != null) {
            ghkh = ghk.getGhkh();
        }
        String rq = "";
        rq = spb.getPzrq() != null ? CommonUtil.formateDate((Date)spb.getPzrq()) : (spb.getShrq() != null ? CommonUtil.formateDate((Date)spb.getShrq()) : CommonUtil.getCurrStrDate());
        DJKXB djkxb = new DJKXB();
        djkxb.setDjkId(djkId);
        djkxb.setDjkbh(djkbh);
        djkxb.setGhkh(ghkh);
        djkxb.setProjectId(projectId);
        djkxb.setDjh(djh);
        djkxb.setRq(rq);
        djkxb.setDjjs(spb.getXbnr());
        if ("\u6c5f\u90fd\u5e02".equals(spb.getRmzf())) {
            djkxb.setDjkjbr(spb.getJbr());
            djkxb.setDjkshr(spb.getScr());
        } else {
            djkxb.setDjkjbr(spb.getJbr());
            djkxb.setDjkshr(spb.getShr());
        }
        djkxb.setDjrq(rq);
        djkxb.setDwdm(spb.getDwdm());
        djkxb.setTdzh(spb.getTdzh());
        djkxb.setIslogout(Integer.valueOf(0));
        djkxb.setIsprinted(Integer.valueOf(0));
        djkxb.setBsm(spb.getBsm());
        djkxb.setSqlx(spb.getSqlx());
        return djkxb;
    }

    public List getDJKXBList(String djh) {
        return this.djkxbDAO.getDJKXBList(djh);
    }

    public List getDJKXBList(String djh, String tdzh) {
        return this.djkxbDAO.getDJKXBList(djh, tdzh);
    }
}

