/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.services;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.BHDAO;
import com.jsegov.tddj.services.ProjectService;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IDWXXService;
import com.jsegov.tddj.services.interf.ITDZHBHService;
import com.jsegov.tddj.util.Common;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DWXX;
import com.jsegov.tddj.vo.DelTdzh;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.TDZHBH;
import com.jsegov.tddj.vo.XZQ;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BhService
implements IBHService {
    @Autowired
    BHDAO bhDAO;

    public String getZSGSBH() {
        String currYear = CommonUtil.getCurrYear();
        String zsgsBHID = this.bhDAO.getZSGSBHID();
        StringBuffer sb = new StringBuffer();
        sb.append(currYear);
        sb.append("-");
        sb.append(zsgsBHID);
        return sb.toString();
    }

    private String getXZQShortName() {
        Common common = new Common();
        XZQ xzq = common.getXZQ();
        String xzqShortName = xzq.getXzqShortName();
        return xzqShortName;
    }

    private XZQ getXZQByXML() {
        Common common = new Common();
        XZQ xzq = common.getXZQ();
        return xzq;
    }

    private String getTDZHShortName(String projectId) {
        ProjectService projectService = (ProjectService)Container.getBean((String)"projectService");
        Project project = projectService.getProject(projectId);
        String dwdm = project.getDwdm();
        IDWXXService dwxxService = (IDWXXService)Container.getBean((String)"dwxxService");
        DWXX dwxx = dwxxService.getDwxx(dwdm);
        String shortName = "";
        if (dwxx != null) {
            shortName = dwxx.getShortname();
        }
        return shortName;
    }

    private String getTDZBH(String projectId, String zsType) {
        ProjectService projectService = (ProjectService)Container.getBean((String)"projectService");
        Project project = projectService.getProject(projectId);
        String dwdm = project.getDwdm();
        ITDZHBHService tdzbhService = (ITDZHBHService)Container.getBean((String)"tdzhBhService");
        TDZHBH tdzhbh = tdzbhService.getTDZHBH(dwdm, zsType);
        String zsno = "";
        if (tdzhbh != null) {
            Integer maxval = tdzhbh.getMaxval();
            if (maxval == null) {
                Integer minval = tdzhbh.getMinval();
                maxval = minval + 1;
                tdzhbh.setMaxval(maxval);
                tdzbhService.updateTDZHBH(tdzhbh);
            } else {
                maxval = maxval + 1;
                tdzhbh.setMaxval(maxval);
                tdzbhService.updateTDZHBH(tdzhbh);
            }
            zsno = maxval + "";
        } else {
            zsno = "1";
            tdzhbh = new TDZHBH();
            tdzhbh.setDwdm(dwdm);
            tdzhbh.setZstype(zsType);
            tdzhbh.setMinval(Integer.valueOf(1));
            tdzhbh.setMaxval(Integer.valueOf(1));
            tdzbhService.insertTDZHBH(tdzhbh);
        }
        return zsno;
    }

    public String getDJKBH() {
        String currYear = CommonUtil.getCurrYear();
        String djkBHID = this.bhDAO.getDJKBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("(");
        sb.append(currYear);
        sb.append(")");
        sb.append(djkBHID);
        return sb.toString();
    }

    public String getGYTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String gytdsyzBHID = this.getTdzhFromDelTdzh("gytdsyz", null);
        if (!StringUtils.isBlank((String)gytdsyzBHID)) {
            return gytdsyzBHID;
        }
        gytdsyzBHID = this.bhDAO.getGYTDSYZBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u56fd\u7528(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(gytdsyzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getGYTDSYZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = this.getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = this.getTDZHShortName(projectId);
        String gytdsyzBHID = this.getTDZBH(projectId, "gytdsyz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (gytdsyzBHID.length() < bh.length()) {
                gytdsyzBHID = "0" + gytdsyzBHID;
            }
        }
        String tdzh = xzq.getGytdsyzFormat();
        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", gytdsyzBHID);
        return tdzh;
    }

    public String getJTTDSUZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsuzBHID = this.getTdzhFromDelTdzh("jttdsuz", null);
        if (!StringUtils.isBlank((String)jttdsuzBHID)) {
            return jttdsuzBHID;
        }
        jttdsuzBHID = this.bhDAO.getJTTDSUZBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u96c6\u6709(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(jttdsuzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getJTTDSUZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = this.getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = this.getTDZHShortName(projectId);
        String jttdsuzBHID = this.getTDZBH(projectId, "jttdsuz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (jttdsuzBHID.length() < bh.length()) {
                jttdsuzBHID = "0" + jttdsuzBHID;
            }
        }
        String tdzh = xzq.getJttdsuzFormat();
        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", jttdsuzBHID);
        return tdzh;
    }

    public String getJTTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsyzBHID = this.getTdzhFromDelTdzh("jttdsyz", null);
        if (!StringUtils.isBlank((String)jttdsyzBHID)) {
            return jttdsyzBHID;
        }
        jttdsyzBHID = this.bhDAO.getJTTDSYZBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u96c6\u7528(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(jttdsyzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getJTTDSYZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = this.getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = this.getTDZHShortName(projectId);
        String jttdsyzBHID = this.getTDZBH(projectId, "jttdsyz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (jttdsyzBHID.length() < bh.length()) {
                jttdsyzBHID = "0" + jttdsyzBHID;
            }
        }
        String tdzh = xzq.getJttdsyzFormat();
        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", jttdsyzBHID);
        return tdzh;
    }

    public String getSJDBH() {
        String currYear = CommonUtil.getCurrYear();
        String sjdBHID = this.bhDAO.getSJDBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u6536\u4ef6(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(sjdBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getTXQLZMSBH() {
        String currYear = CommonUtil.getCurrYear();
        String txqlzmsBHID = this.getTdzhFromDelTdzh("txqlzms", null);
        if (!StringUtils.isBlank((String)txqlzmsBHID)) {
            return txqlzmsBHID;
        }
        txqlzmsBHID = this.bhDAO.getTXQLZMSBHID();
        String xzqShortName = this.getXZQShortName();
        StringBuffer sb = new StringBuffer();
        sb.append(xzqShortName);
        sb.append("\u4ed6\u9879(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(txqlzmsBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getTXQLZMSBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = this.getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = this.getTDZHShortName(projectId);
        String txqlzmsBHID = this.getTDZBH(projectId, "txqlzms");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (txqlzmsBHID.length() < bh.length()) {
                txqlzmsBHID = "0" + txqlzmsBHID;
            }
        }
        String tdzh = xzq.getTxqlzmsFormat();
        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", txqlzmsBHID);
        return tdzh;
    }

    public Integer getBSM() {
        return this.bhDAO.getBSM();
    }

    public Integer getReSetBH() {
        return this.bhDAO.getReSetBH();
    }

    public String getGHKBH() {
        String currYear = CommonUtil.getCurrYear();
        String ghkBHID = this.bhDAO.getGHKBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(ghkBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getFGZBH() {
        String currYear = CommonUtil.getCurrYear();
        String fgzBHID = this.bhDAO.getFGZBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u5206\u5272(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(fgzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getZXBH() {
        String currYear = CommonUtil.getCurrYear();
        String zxBHID = this.bhDAO.getZXBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u6ce8\u9500(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(zxBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getSPBBH() {
        String currYear = CommonUtil.getCurrYear();
        String spbBHID = this.bhDAO.getSPBBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u5ba1\u6279(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(spbBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getSQBBH() {
        String currYear = CommonUtil.getCurrYear();
        String sqbBHID = this.bhDAO.getSQBBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u7533\u8bf7(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(sqbBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getSPBHBySqlx(String projectId, String sqlx, String qsxz) {
        String spbh = "";
        if (qsxz.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u56fd\u6709\u519c\u7528\u5730\u4f7f\u7528\u6743")) {
            spbh = sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0") ? this.getTXQLZMSBH() : (sqlx.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0") ? this.getZXBH() : this.getGYTDSYZBH());
        } else if (qsxz.equals("\u96c6\u4f53\u571f\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u96c6\u4f53\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u96c6\u4f53\u519c\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u5b85\u57fa\u5730\u4f7f\u7528\u6743")) {
            spbh = sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0") ? this.getTXQLZMSBH() : (sqlx.equals("\u96c6\u4f53\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0") ? this.getZXBH() : this.getJTTDSYZBH());
        } else if (qsxz.equals("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743")) {
            spbh = sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0") ? this.getTXQLZMSBH() : (sqlx.equals("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743\u6ce8\u9500\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0") ? this.getZXBH() : this.getJTTDSUZBH());
        }
        if (spbh == null || spbh.equals("")) {
            spbh = sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0") ? this.getTXQLZMSBH() : (sqlx.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0") ? this.getZXBH() : this.getGYTDSYZBH());
        }
        return spbh;
    }

    public String getTdzhFromDelTdzh(String zsType, String dwdm) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)zsType)) {
            List listDelTdzhs;
            map.put("zstype", zsType);
            if (StringUtils.isNotBlank((String)dwdm)) {
                map.put("dwdm", dwdm);
            }
            if ((listDelTdzhs = this.selectDelTdzh(map)) != null && listDelTdzhs.size() > 0) {
                String tdzh = ((DelTdzh)listDelTdzhs.get(0)).getTdzh();
                this.deleteDelTdzh(((DelTdzh)listDelTdzhs.get(0)).getProjectId());
                return tdzh;
            }
        } else {
            return null;
        }
        return null;
    }

    public Void createSq_GYTDSYZID() {
        return this.bhDAO.createSq_GYTDSYZID();
    }

    public Void dropSq_GYTDSYZID() {
        return this.bhDAO.dropSq_GYTDSYZID();
    }

    public Void createSq_DJKBHID() {
        return this.bhDAO.createSq_DJKBHID();
    }

    public Void createSq_FGZBHID() {
        return this.bhDAO.createSq_FGZBHID();
    }

    public Void createSq_GHKBHID() {
        return this.bhDAO.createSq_GHKBHID();
    }

    public Void createSq_JTTDSUZBHID() {
        return this.bhDAO.createSq_JTTDSUZBHID();
    }

    public Void createSq_JTTDSYZBHID() {
        return this.bhDAO.createSq_JTTDSYZBHID();
    }

    public Void createSq_SJDBHID() {
        return this.bhDAO.createSq_SJDBHID();
    }

    public Void createSq_SPBBHID() {
        return this.bhDAO.createSq_SPBBHID();
    }

    public Void createSq_SQBBHID() {
        return this.bhDAO.createSq_SQBBHID();
    }

    public Void createSq_TXQLZMSBHID() {
        return this.bhDAO.createSq_TXQLZMSBHID();
    }

    public Void createSq_ZXBHID() {
        return this.bhDAO.createSq_ZXBHID();
    }

    public Void dropSq_DJKBHID() {
        return this.bhDAO.dropSq_DJKBHID();
    }

    public Void dropSq_FGZBHID() {
        return this.bhDAO.dropSq_FGZBHID();
    }

    public Void dropSq_GHKBHID() {
        return this.bhDAO.dropSq_GHKBHID();
    }

    public Void dropSq_JTTDSUZBHID() {
        return this.bhDAO.dropSq_JTTDSUZBHID();
    }

    public Void dropSq_JTTDSYZBHID() {
        return this.bhDAO.dropSq_JTTDSYZBHID();
    }

    public Void dropSq_SJDBHID() {
        return this.bhDAO.dropSq_SJDBHID();
    }

    public Void dropSq_SPBBHID() {
        return this.bhDAO.dropSq_SPBBHID();
    }

    public Void dropSq_SQBBHID() {
        return this.bhDAO.dropSq_SQBBHID();
    }

    public Void dropSq_TXQLZMSBHID() {
        return this.bhDAO.dropSq_TXQLZMSBHID();
    }

    public Void dropSq_ZXBHID() {
        return this.bhDAO.dropSq_ZXBHID();
    }

    public Void createSq_ZSXL() {
        return this.bhDAO.createSq_ZSXL();
    }

    public Void dropSq_ZSXL() {
        return this.bhDAO.dropSq_ZSXL();
    }

    public Void createReSetBH(Integer startVal) {
        return this.bhDAO.createReSetBH(startVal);
    }

    public Void dropReSetBH() {
        return this.bhDAO.dropReSetBH();
    }

    public Integer getReSetBHCurrVal() {
        return this.bhDAO.getReSetBHCurrVal();
    }

    public List<DelTdzh> selectDelTdzh(HashMap<String, Object> map) {
        return this.bhDAO.selectDelTdzh(map);
    }

    public void deleteDelTdzh(String projectId) {
        this.bhDAO.deleteDelTdzh(projectId);
    }

    public void insertDelTdzh(DelTdzh delTdzh) {
        this.bhDAO.insertDelTdzh(delTdzh);
    }

    public String getMaxTdzhBySqlx(String projectId, String sqlx, String qsxz) {
        String spbh = "";
        if (qsxz.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u56fd\u6709\u519c\u7528\u5730\u4f7f\u7528\u6743")) {
            if (sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0")) {
                spbh = this.getMaxTXQLZMSBH();
            } else if (!sqlx.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") && !sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0")) {
                spbh = this.getMaxGYTDSYZBH();
            }
        } else if (qsxz.equals("\u96c6\u4f53\u571f\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u96c6\u4f53\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u96c6\u4f53\u519c\u7528\u5730\u4f7f\u7528\u6743") || qsxz.equals("\u5b85\u57fa\u5730\u4f7f\u7528\u6743")) {
            if (sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0")) {
                spbh = this.getMaxTXQLZMSBH();
            } else if (!sqlx.equals("\u96c6\u4f53\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") && !sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0")) {
                spbh = this.getMaxJTTDSYZBH();
            }
        } else if (qsxz.equals("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743")) {
            if (sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0")) {
                spbh = this.getMaxTXQLZMSBH();
            } else if (!sqlx.equals("\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743\u6ce8\u9500\u767b\u8bb0") && !sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0")) {
                spbh = this.getMaxJTTDSUZBH();
            }
        }
        if (spbh == null || spbh.equals("")) {
            if (sqlx.equals("\u571f\u5730\u62b5\u62bc\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u5730\u5f79\u6743\u53d8\u66f4\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u62b5\u62bc\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u79df\u8d41\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u4f7f\u7528\u6743\u5730\u5f79\u6743\u521d\u59cb\u767b\u8bb0") || sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u9057\u5931\u8865\u53d1\u767b\u8bb0") || sqlx.equals("\u571f\u5730\u79df\u8d41\u6743\u53d8\u66f4\u767b\u8bb0")) {
                spbh = this.getMaxTXQLZMSBH();
            } else if (!sqlx.equals("\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743\u6ce8\u9500\u767b\u8bb0") && !sqlx.equals("\u4ed6\u9879\u6743\u5229\u8bc1\u660e\u4e66\u6ce8\u9500\u767b\u8bb0")) {
                spbh = this.getMaxGYTDSYZBH();
            }
        }
        return spbh;
    }

    public String getMaxTXQLZMSBH() {
        String currYear = CommonUtil.getCurrYear();
        String txqlzmsBHID = this.getTdzhFromDelTdzh("txqlzms", null);
        if (StringUtils.isBlank((String)txqlzmsBHID)) {
            txqlzmsBHID = this.bhDAO.getMaxTXQLZMSBHID();
            if (StringUtils.isBlank((String)txqlzmsBHID)) {
                txqlzmsBHID = "1";
            }
        } else {
            return txqlzmsBHID;
        }
        String xzqShortName = this.getXZQShortName();
        StringBuffer sb = new StringBuffer();
        sb.append(xzqShortName);
        sb.append("\u4ed6\u9879(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(txqlzmsBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getMaxGYTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String gytdsyzBHID = this.getTdzhFromDelTdzh("gytdsyz", null);
        if (StringUtils.isBlank((String)gytdsyzBHID)) {
            gytdsyzBHID = this.bhDAO.getMaxGYTDSYZBHID();
            if (StringUtils.isBlank((String)gytdsyzBHID)) {
                gytdsyzBHID = "1";
            }
        } else {
            return gytdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u56fd\u7528(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(gytdsyzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getMaxJTTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsyzBHID = this.getTdzhFromDelTdzh("jttdsyz", null);
        if (StringUtils.isBlank((String)jttdsyzBHID)) {
            jttdsyzBHID = this.bhDAO.getMaxJTTDSYZBHID();
            if (StringUtils.isBlank((String)jttdsyzBHID)) {
                jttdsyzBHID = "1";
            }
        } else {
            return jttdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u96c6\u7528(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(jttdsyzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }

    public String getMaxJTTDSUZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsuzBHID = this.getTdzhFromDelTdzh("jttdsuz", null);
        if (StringUtils.isBlank((String)jttdsuzBHID)) {
            jttdsuzBHID = this.bhDAO.getMaxJTTDSUZBHID();
            if (StringUtils.isBlank((String)jttdsuzBHID)) {
                jttdsuzBHID = "1";
            }
        } else {
            return jttdsuzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = this.getXZQShortName();
        sb.append(xzqShortName);
        sb.append("\u96c6\u6709(");
        sb.append(currYear);
        sb.append(")\u7b2c");
        sb.append(jttdsuzBHID);
        sb.append("\u53f7");
        return sb.toString();
    }
}

