/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.platform;

import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.vo.Project;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service(value="platUtil")
public class PlatUtil
implements IPlatUtil {
    public String createWorkFlowInstance(Project project, String userId) {
        String taskId = "";
        try {
            PfTaskVo taskVo;
            PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();
            Date createTime = new Date();
            wfVO.setTimeLimit(this.getCNQX(project.getWdid()) + "");
            wfVO.setCreateTime(createTime);
            wfVO.setWorkflowIntanceId(project.getProjectId());
            wfVO.setWorkflowDefinitionId(project.getWdid());
            wfVO.setProId(project.getProjectId());
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                wfVO.setRemark(project.getDjh() + " || " + project.getTdzl());
            } else {
                wfVO.setRemark(project.getTdzl());
            }
            wfVO.setWorkflowIntanceName(project.getQlr());
            wfVO.setCreateUser(userId);
            WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService)Container.getBean((String)"WorkFlowCoreService");
            WorkFlowInfo workFlowInfo = workFlowCoreService.createWorkFlowInstance(wfVO, userId);
            Iterator i$ = workFlowInfo.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId) && userId != taskVo.getUserVo().getUserId()) continue;
                taskId = taskVo.getTaskId();
                break;
            }
            if ((taskId == null || taskId.equals("")) && (i$ = workFlowInfo.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                taskId = taskVo.getTaskId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u521b\u5efa\u5de5\u4f5c\u6d41\u5b9e\u4f8b\u5931\u8d25");
        }
        return taskId;
    }

    public void editWorkFlowInstance(String projectId, String remark, String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        if (wfInstanceVo != null) {
            wfInstanceVo.setRemark(remark);
            sysWorkFlowInstanceService.updateWorkFlowInstanceRemark(wfInstanceVo);
            if (!projectName.equals("")) {
                wfInstanceVo.setWorkflowIntanceName(projectName);
                sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
            }
        }
    }

    public void editWorkFlowInstanceName(String projectId, String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        wfInstanceVo.setWorkflowIntanceName(projectName);
        sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
    }

    public String getActivityDesc(String projectId, String activityId) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)sysWorkFlowInstanceService.getWorkflowInstanceXml(projectId));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        org.dom4j.Node node1 = root.selectSingleNode("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity[@Id='" + activityId + "']/Description");
        String activityDesc = node1.getText();
        if (activityDesc != null) {
            return activityDesc;
        }
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        PfActivityVo pfActivityVo = sysTaskService.getActivity(activityId);
        if (pfActivityVo != null) {
            activityDesc = pfActivityVo.getActivityName();
        }
        return activityDesc;
    }

    public int getCNQX(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        int cnqx = 0;
        if (StringUtils.isNotBlank((String)wfDefineVo.getTimeLimit())) {
            cnqx = Integer.parseInt(wfDefineVo.getTimeLimit());
        }
        return cnqx;
    }

    public String getPfActivityIdByTaskId(String taskId) {
        PfTaskVo pfTask;
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        String activitId = "";
        if (taskId != null && !taskId.equals("") && (pfTask = sysTaskService.getTask(taskId)) != null) {
            activitId = pfTask.getActivityId();
        }
        return activitId;
    }

    public String getPfActivityNameByTaskId(String taskId) {
        String activitId;
        PfActivityVo pfActivityVo;
        PfTaskVo pfTask;
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        String activityName = "";
        if (taskId != null && !taskId.equals("") && (pfTask = sysTaskService.getTask(taskId)) != null && (pfActivityVo = sysTaskService.getActivity(activitId = pfTask.getActivityId())) != null) {
            activityName = pfActivityVo.getActivityName();
        }
        return activityName;
    }

    public int getTimeLimit(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        int limit = 0;
        if (StringUtils.isNotBlank((String)wfDefineVo.getTimeLimit())) {
            limit = Integer.parseInt(wfDefineVo.getTimeLimit());
        }
        return limit;
    }

    public String getWfRemarkByProjectId(String projectId) {
        PfWorkFlowInstanceVo wfInstanceVo;
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine((wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId)).getWorkflowDefinitionId());
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    public String getWfRemarkByWdid(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    public String getOrganByUser(String userId) {
        try {
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List organList = userService.getOrganListByUser(userId);
            String dwmc = "";
            if (organList != null && organList.size() > 0) {
                dwmc = ((PfOrganVo)organList.get(0)).getOrganName();
            }
            return dwmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getAllOrgan() {
        try {
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List organList = userService.getOrganList();
            ArrayList<String> list = new ArrayList<String>();
            if (organList != null) {
                PfOrganVo organVo = null;
                for (int i = 0; i < organList.size(); ++i) {
                    organVo = (PfOrganVo)organList.get(i);
                    list.add(organVo.getOrganName());
                }
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getAllUser() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List listUser = userService.getAllUsers();
            for (PfUserVo pfUserVo : listUser) {
                list.add(pfUserVo.getUserName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateGlobalVal(String projectId, String GobalValName, Object value) {
        try {
            SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
            sysWorkFlowInstanceService.updateGobalVal(projectId, GobalValName, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getFileId(String projectId, String desc) {
        ArrayList<String> listID = new ArrayList<String>();
        try {
            if (projectId != null && desc != null && !projectId.equals("")) {
                List list = this.getProjectNode(projectId);
                for (Node node : list) {
                    if (node.getDescription() == null || !node.getDescription().equals(desc) && (!node.getDescription().startsWith(desc) || node.getDescription().length() - 1 != desc.length())) continue;
                    listID.add(node.getId().toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listID;
    }

    public List<String> getFileId(String projectId) {
        ArrayList<String> listID = new ArrayList<String>();
        try {
            if (projectId != null && !projectId.equals("")) {
                List list = this.getProjectNode(projectId);
                for (Node node : list) {
                    listID.add(node.getId().toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listID;
    }

    private List<Node> getProjectNode(String projectId) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        Node tempNode = this.createFileFolder(space.getId(), projectId);
        List list = nodeService.getAllChildNodes(tempNode.getId());
        return list;
    }

    private void deleteFiLeNode(String nodeName) {
        Space space;
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Node tempNode = nodeService.getChildNode((space = nodeService.getWorkSpace("WORK_FLOW_STUFF")).getId(), nodeName);
        if (tempNode != null && tempNode.getId() != null) {
            nodeService.remove(tempNode.getId());
        }
        List list = nodeService.getAllChildNodes(tempNode.getId());
    }

    private Node createFileFolder(Integer parentId, String folderNodeName) {
        Node tempNode = null;
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        try {
            tempNode = nodeService.getNode(parentId, folderNodeName, true);
        }
        catch (NodeNotFoundException e) {
            e.printStackTrace();
        }
        return tempNode;
    }

    public void saveNodeDesc(Integer fileId, String desc) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                node.setName(desc + node.getName().substring(node.getName().indexOf("."), node.getName().length()));
                node.setDescription(desc);
                nodeService.save(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFile(Integer fileId) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            nodeService.remove(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<PfWorkFlowDefineVo> getWorkFlowDefine() {
        SysWorkFlowDefineService SysWorkFlowDefineService2 = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        return SysWorkFlowDefineService2.getWorkFlowDefineList();
    }

    public List<PfBusinessVo> getBusinessVo() {
        SysWorkFlowDefineService SysWorkFlowDefineService2 = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        return SysWorkFlowDefineService2.getBusinessList();
    }

    public List<String> getSystemResrouceFunAuthorList(String userId, String rid) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SysAuthorService authorService = (SysAuthorService)Container.getBean((String)"SysAuthorServiceImpl");
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List listRoleVo = userService.getRoleListByUser(userId);
            String roles = "";
            for (PfRoleVo pfRoleVo : listRoleVo) {
                if (!roles.equals("")) {
                    roles = roles + "," + "'" + pfRoleVo.getRoleId() + "'";
                    continue;
                }
                roles = "'" + pfRoleVo.getRoleId() + "'";
            }
            List lstfPartitions = authorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    list.add(partitionInfoVo.getElementName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getOrganManger(String userId) {
        String userName = "";
        try {
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List organList = userService.getOrganListByUser(userId);
            List list = userService.getUserListByOragn(((PfOrganVo)organList.get(0)).getOrganId());
            PfUserVo userVo = null;
            for (int i = 0; i < list.size(); ++i) {
                userVo = (PfUserVo)list.get(i);
                if (userVo == null || userVo.getUserPost() == null || !userVo.getUserPost().equals("\u79d1\u957f")) continue;
                userName = userVo.getUserName();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userName;
    }

    public PfWorkFlowDefineVo getPfWorkFlowDefineVo(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        return wfDefineVo;
    }

    public PfOrganVo getOrganByUserId(String userId) {
        try {
            SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
            List organList = userService.getOrganListByUser(userId);
            PfOrganVo pfOrganVo = null;
            if (organList != null && organList.size() > 0) {
                pfOrganVo = (PfOrganVo)organList.get(0);
            }
            return pfOrganVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getUserNameInOrganByUserId(String userId) {
        try {
            ArrayList<String> userNameInOrgan = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)userId)) {
                PfOrganVo organVo = this.getOrganByUserId(userId);
                SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
                if (organVo != null && StringUtils.isNotEmpty((String)organVo.getOrganName())) {
                    List lstUser = userService.getUsersByOrganName(organVo.getOrganName());
                    for (PfUserVo pfUserVo : lstUser) {
                        if (pfUserVo == null || !StringUtils.isNotEmpty((String)pfUserVo.getUserName())) continue;
                        userNameInOrgan.add(pfUserVo.getUserName());
                    }
                }
            }
            return userNameInOrgan;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<PfRoleVo> getRoleListByUser(String userId) {
        SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
        return userService.getRoleListByUser(userId);
    }

    public PfUserVo getUserVo(String userId) {
        SysUserService userService = (SysUserService)Container.getBean((String)"SysUserServiceImpl");
        return userService.getUserVo(userId);
    }

    public void saveNodeDescByProjectId(Integer fileId, String desc, String projectId) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                List nodeList = this.getFileId(projectId, desc);
                if (nodeList.size() > 0) {
                    desc = desc + nodeList.size();
                }
                node.setName(desc + node.getName().substring(node.getName().indexOf("."), node.getName().length()));
                node.setDescription(desc);
                nodeService.save(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

