/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.fileUpload;

import com.jsegov.tddj.fileUpload.ZipFileInvalidException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    Log logger = LogFactory.getLog(ZipUtil.class);

    public static void zip(String sourceDir, String zipFile) {
        try {
            FileOutputStream os = new FileOutputStream(zipFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            ZipOutputStream zos = new ZipOutputStream((OutputStream)bos);
            File file = new File(sourceDir);
            String basePath = null;
            basePath = file.isDirectory() ? file.getPath() : file.getParent();
            ZipUtil.zipFile((File)file, (String)basePath, (ZipOutputStream)zos);
            zos.closeEntry();
            zos.close();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void zipFile(File source, String basePath, ZipOutputStream zos) {
        File[] files = new File[]{};
        files = source.isDirectory() ? source.listFiles() : new File[]{source};
        byte[] buf = new byte[1024];
        int length = 0;
        try {
            for (File file : files) {
                String pathName;
                if (file.isDirectory()) {
                    pathName = file.getPath().substring(basePath.length() + 1) + "/";
                    zos.putNextEntry(new ZipEntry(pathName));
                    ZipUtil.zipFile((File)file, (String)basePath, (ZipOutputStream)zos);
                    continue;
                }
                pathName = file.getPath().substring(basePath.length() + 1);
                FileInputStream is = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(is);
                zos.putNextEntry(new ZipEntry(pathName));
                while ((length = bis.read(buf)) > 0) {
                    zos.write(buf, 0, length);
                }
                bis.close();
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unZip(String zipfile, String destDir) throws Exception {
        destDir = destDir.endsWith("\\") ? destDir : destDir + "\\";
        byte[] b2 = new byte[1024];
        ZipFile zipFile = new ZipFile(new File(zipfile));
        Enumeration enumeration = zipFile.getEntries();
        ZipEntry zipEntry = null;
        while (enumeration.hasMoreElements()) {
            int length;
            zipEntry = (ZipEntry)enumeration.nextElement();
            File loadFile = new File(destDir + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                loadFile.mkdirs();
                continue;
            }
            if (!loadFile.getParentFile().exists()) {
                loadFile.getParentFile().mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(loadFile);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            while ((length = inputStream.read(b2)) > 0) {
                ((OutputStream)outputStream).write(b2, 0, length);
            }
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
    }

    public static boolean checkZipFileValid(String filePath) throws ZipFileInvalidException {
        if (filePath == null || filePath.trim().length() == 0) {
            throw new ZipFileInvalidException("\u6587\u4ef6\u540d\u4e3a\u7a7a\u6216\u8005\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728", 1);
        }
        try {
            ZipFile zipFile = new ZipFile(new File(filePath));
        }
        catch (IOException e) {
            throw new ZipFileInvalidException("zip\u6587\u4ef6\u683c\u5f0f\u65e0\u6548", 2);
        }
        return true;
    }

    public static void main(String[] args) {
        String unzipfile = "D:\\Downloads\\book\\\u5929\u4e0b\u8859\u95e8.TXT";
        String saveTo = "D:\\Downloads\\book\\\u5929\u4e0b\u8859\u95e8";
    }
}

