/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.fileUpload;

import com.jsegov.tddj.fileUpload.UploadActivity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Hashtable;

public class UploadActivityManager {
    public static final int LOG_TYPE_INFO = 0;
    public static final int LOG_TYPE_WARN = 1;
    public static final int LOG_TYPE_ERROR = 2;
    private Hashtable<String, UploadActivity> uploadStatusMap = new Hashtable();
    private static UploadActivityManager hInstance = null;

    private UploadActivityManager() {
    }

    public static UploadActivityManager getInstance() {
        if (hInstance == null) {
            hInstance = new UploadActivityManager();
        }
        return hInstance;
    }

    public UploadActivity queryUploadActivity(String uploadId) throws Exception {
        UploadActivity tempUploadActivity = (UploadActivity)this.uploadStatusMap.get(uploadId);
        if (tempUploadActivity == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5230uploadId=" + uploadId + "\u7684\u4e0a\u8f7d\u6d3b\u52a8");
        }
        return tempUploadActivity;
    }

    public void registerUploadActivity(String uploadId, int status, int progress) {
        if (uploadId == null) {
            return;
        }
        if (progress > 100) {
            progress = 100;
        }
        if (progress < 0) {
            progress = 0;
        }
        UploadActivity tempUploadActivity = new UploadActivity();
        tempUploadActivity.setUploadId(uploadId);
        tempUploadActivity.setStatus(status);
        tempUploadActivity.setProgress(progress);
        tempUploadActivity.setRegisterTime(Calendar.getInstance().getTimeInMillis());
        this.uploadStatusMap.put(uploadId, tempUploadActivity);
    }

    public void updateUploadActivity(String uploadId, int status, int progress, String message) {
        if (uploadId == null) {
            return;
        }
        UploadActivity tempUploadActivity = (UploadActivity)this.uploadStatusMap.get(uploadId);
        tempUploadActivity.setUploadId(uploadId);
        tempUploadActivity.setStatus(status);
        tempUploadActivity.setProgress(progress);
        tempUploadActivity.setMessage(message);
    }

    public void unRegisterUploadActivity(String uploadId) {
        this.uploadStatusMap.remove(uploadId);
    }

    public void writeLog(String uploadId, int logType, String logInfo) throws Exception {
        if (uploadId == null || uploadId.trim().length() == 0 || logInfo == null || logInfo.trim().length() == 0) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4e0a\u8f7d\u6d3b\u52a8\uff0cuploadId\u4e3a\u7a7a\uff01");
        }
        UploadActivity tempUploadActivity = this.queryUploadActivity(uploadId);
        StringBuffer tempLogBuf = tempUploadActivity.getLogBuf();
        switch (logType) {
            case 0: {
                tempLogBuf.append("\r\n[INFO] ");
                tempLogBuf.append(logInfo.toString());
                break;
            }
            case 1: {
                tempLogBuf.append("\r\n[WARN] ");
                tempLogBuf.append(logInfo.toString());
                break;
            }
            case 2: {
                tempLogBuf.append("\r\n[ERROR] ");
                tempLogBuf.append(logInfo.toString());
                break;
            }
            default: {
                tempLogBuf.append("\r\n[INFO] ");
                tempLogBuf.append(logInfo.toString());
            }
        }
    }

    public String getLog(String uploadId) throws Exception {
        UploadActivity tempUploadActivity = this.queryUploadActivity(uploadId);
        StringBuffer tempLogBuf = tempUploadActivity.getLogBuf();
        if (tempLogBuf == null) {
            return "";
        }
        return tempLogBuf.toString();
    }

    public String logToFile(String uploadId) throws Exception {
        UploadActivity tempUploadActivity = this.queryUploadActivity(uploadId);
        String logUrl = "";
        String log = this.getLog(uploadId);
        if (log == null || log.trim().length() == 0) {
            return logUrl;
        }
        String curClassDir = this.getClass().getResource("").getPath();
        String destDir = curClassDir.substring(0, curClassDir.indexOf("WEB-INF"));
        File logDirFile = new File(destDir = destDir + "\\temp\\log\\");
        if (!logDirFile.exists()) {
            logDirFile.mkdir();
        }
        destDir = destDir + uploadId + ".log";
        File file = new File(destDir);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destDir), "GBK"));
            out.write(log);
            ((Writer)out).close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        tempUploadActivity.setLogFilePath(destDir);
        return destDir;
    }

    public void clearDataResult() {
        this.uploadStatusMap.clear();
    }
}

