/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.fileUpload;

import com.jsegov.tddj.fileUpload.DataParseResult;
import com.jsegov.tddj.fileUpload.ZipUtil;
import java.io.File;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataParse {
    public static final String CHANGE_INFO_FILE_SUFFIX = "\u53d8\u66f4\u4e00\u89c8\u8868";
    public static final String PROJ_INFO_FILE_SUFFIX = "\u4fe1\u606f\u8868";
    public static final String METADATA_FILE_SUFFIX = "\u589e\u91cf\u5143\u6570\u636e";
    public static final String PNT_COORD_FILE_SUFFIX = "\u5750\u6807";
    public static final String BWD_FILE_SUFFIX = "\u6279\u6b21\u4fe1\u606f";
    public static final int CHANGE_INFO_FILE_BEGIN_ROW_NO = 4;
    public static final int PROJ_INFO_FILE_BEGIN_ROW_NO = 1;
    private String importZipFile = null;
    private boolean zipFileValid = true;
    private StringBuffer checkLogBuf = new StringBuffer();
    private String destDir;
    Log log = LogFactory.getLog(this.getClass());

    public DataParse(String importZipFile) throws Exception {
        this.importZipFile = importZipFile;
    }

    public DataParseResult parseProjZipData(String regionCode) throws Exception {
        File[] projDirList;
        DataParseResult dataParseResult = new DataParseResult();
        dataParseResult.setRegionCode(regionCode);
        String curClassDir = this.getClass().getResource("").getPath();
        this.destDir = curClassDir.substring(0, curClassDir.indexOf("WEB-INF"));
        if (this.importZipFile == null || this.importZipFile.trim().length() == 0) {
            return dataParseResult;
        }
        this.destDir = this.destDir + "\\temp\\" + String.valueOf(Calendar.getInstance().getTimeInMillis());
        File destDirFile = new File(this.destDir);
        if (destDirFile.exists()) {
            destDirFile.delete();
        }
        destDirFile.mkdir();
        try {
            ZipUtil.unZip((String)this.importZipFile, (String)this.destDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5zip\u6587\u4ef6\u662f\u5426\u6b63\u786e!");
        }
        File file = new File(this.destDir);
        if (file.isDirectory() && (projDirList = file.listFiles()) != null && projDirList.length > 0) {
            for (int i = 0; i < projDirList.length; ++i) {
                File tempProjDirFile = projDirList[i];
                if (!tempProjDirFile.isFile()) continue;
                String tempFileName = tempProjDirFile.getName();
                if (tempFileName == null) {
                    tempFileName = "";
                }
                tempFileName = tempFileName.trim();
                String fileFullPath = tempProjDirFile.getAbsolutePath();
            }
        }
        return dataParseResult;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }
}

