/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.action;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.IqlygUtil;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.workflow.WfActivity;
import com.jsegov.tddj.workflow.WfInstance;
import com.jsegov.tddj.workflow.WorkFlowEvent;
import com.opensymphony.xwork2.ActionSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

public class WfEventHandleAction
extends ActionSupport {
    public static final String EVENT_TYPE_WORKFLOW_BEGIN = "WorkFlow_Begin";
    public static final String EVENT_TYPE_WORKFLOW_BEFORETURN = "WorkFlow_BeforeTurn";
    public static final String EVENT_TYPE_WORKFLOW_TURN = "WorkFlow_Turn";
    public static final String EVENT_TYPE_WORKFLOW_BACK = "WorkFlow_Back";
    public static final String EVENT_TYPE_WORKFLOW_STOP = "WorkFlow_Stop";
    public static final String EVENT_TYPE_WORKFLOW_DEL = "WorkFlow_Del";
    public static final String EVENT_TYPE_WORKFLOW_END = "WorkFlow_End";
    private String proid;
    private String eventHandleClass;
    private String eventName;
    private String activityid;
    private String userid;
    private String taskid;
    private String msg;

    public String execute() throws Exception {
        if (this.eventHandleClass == null || this.eventHandleClass.trim().length() == 0 || this.eventName == null || this.eventName.trim().length() == 0) {
            return "none";
        }
        try {
            Class<?> eventHandle = Class.forName(this.eventHandleClass);
            Object instance = eventHandle.newInstance();
            if (instance instanceof WorkFlowEvent) {
                WorkFlowEvent workflowEvent = (WorkFlowEvent)instance;
                this.invokeMethod(workflowEvent);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.msg != null && !this.msg.equals("")) {
            HttpServletResponse response = ServletActionContext.getResponse();
            response.setContentType("text/xml;charset=GBK");
            PrintWriter out = response.getWriter();
            out.println(this.msg);
            out.flush();
            out.close();
        }
        return "none";
    }

    private void invokeMethod(WorkFlowEvent workflowEvent) {
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(this.proid);
        PfActivityVo pfActivityVo = sysTaskService.getActivity(this.activityid);
        WfInstance wfInstance = this.transformtoWfInstance(pfWorkFlowInstanceVo);
        WfActivity wfActivity = this.transformtoWfActivity(pfActivityVo);
        IqlygUtil qlygUtil = (IqlygUtil)Container.getBean((String)"qlygUtil");
        if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BEGIN)) {
            workflowEvent.doCreateAfter(pfWorkFlowInstanceVo);
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BEFORETURN)) {
            SPB spb_sheet;
            this.msg = workflowEvent.doTurnBefore(wfInstance, wfActivity);
            String projectId = wfInstance.getPRO_ID();
            IPlatUtil platUtil = (IPlatUtil)Container.getBean((String)"platUtil");
            String projecttype = platUtil.getWfRemarkByProjectId(projectId);
            String remark = platUtil.getActivityDesc(projectId, wfActivity.getWfacdefineid());
            ISPBService spbService = (ISPBService)Container.getBean((String)"spbService");
            SPB spb = spbService.getSPB(projectId);
            if (spb != null && (spb_sheet = CommonUtil.checkSheetinfo((String)projecttype, (String)remark, (SPB)spb, (String)this.userid)) != null && spb_sheet.getProjectId() != null) {
                spbService.updateSPB(spb_sheet);
            }
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_TURN)) {
            this.msg = workflowEvent.doTurnAfter(wfInstance, wfActivity);
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BACK)) {
            workflowEvent.doTurnBackAfter(pfWorkFlowInstanceVo, pfActivityVo);
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_STOP)) {
            workflowEvent.doStopAfter(pfWorkFlowInstanceVo);
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_DEL)) {
            workflowEvent.doDelAfter(pfWorkFlowInstanceVo);
        } else if (this.eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_END)) {
            workflowEvent.doTurnOverAfter(wfInstance, wfActivity);
        }
    }

    private WfInstance transformtoWfInstance(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) {
        WfInstance wfInstance = new WfInstance();
        wfInstance.setHANDLES_DAY(pfWorkFlowInstanceVo.getHandlesDay());
        wfInstance.setPRIORITY(pfWorkFlowInstanceVo.getPriority());
        wfInstance.setPRO_ID(pfWorkFlowInstanceVo.getProId());
        wfInstance.setRegionCode(pfWorkFlowInstanceVo.getRegionCode());
        wfInstance.setREMARK(pfWorkFlowInstanceVo.getRemark());
        if (StringUtils.isNotBlank((String)pfWorkFlowInstanceVo.getTimeLimit())) {
            wfInstance.setTIME_LIMIT(Integer.parseInt(pfWorkFlowInstanceVo.getTimeLimit()));
        }
        wfInstance.setWORKFLOW_DEFINITION_ID(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
        wfInstance.setWORKFLOW_INSTANCE_ID(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        wfInstance.setWORKFLOW_INSTANCE_NAME(pfWorkFlowInstanceVo.getWorkflowIntanceName());
        wfInstance.setWORKFLOW_STATE(pfWorkFlowInstanceVo.getWorkflowState());
        return wfInstance;
    }

    private WfActivity transformtoWfActivity(PfActivityVo pfActivityVo) {
        WfActivity wfActivity = new WfActivity();
        if (pfActivityVo == null) {
            return null;
        }
        wfActivity.setAcName(pfActivityVo.getActivityName());
        if (pfActivityVo.getBeginTime() != null) {
            wfActivity.setBeginTime(CommonUtil.formateDate((Date)pfActivityVo.getBeginTime()));
        }
        if (pfActivityVo.getFinishTime() != null) {
            wfActivity.setFinishTime(CommonUtil.formateDate((Date)pfActivityVo.getFinishTime()));
        }
        wfActivity.setHeight(pfActivityVo.getHeight());
        wfActivity.setLeft(pfActivityVo.getLeft());
        wfActivity.setRemark(pfActivityVo.getRemark());
        wfActivity.setTop(pfActivityVo.getTop());
        wfActivity.setWfacdefineid(pfActivityVo.getActivityDefinitionId());
        wfActivity.setWfacid(pfActivityVo.getActivityId());
        wfActivity.setWfinstanceid(pfActivityVo.getWorkflowInstanceId());
        ArrayList organList = new ArrayList();
        if (pfActivityVo.getOrganId() != null && pfActivityVo.getOrganId().trim().length() > 0) {
            wfActivity.setWforganlist(organList);
        }
        wfActivity.setWidth(pfActivityVo.getWidth());
        return wfActivity;
    }

    public String getProid() {
        return this.proid;
    }

    public String getEventHandleClass() {
        return this.eventHandleClass;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public void setEventHandleClass(String eventHandleClass) {
        this.eventHandleClass = eventHandleClass;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getActivityid() {
        return this.activityid;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setActivityid(String activityid) {
        this.activityid = activityid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }
}

