/*
 * Decompiled with CFR 0.152.
 */
package com.jsegov.tddj.action;

import com.jsegov.tddj.platform.TddjUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class PrintManageAction
extends ActionSupport {
    private static final long serialVersionUID = -7016497225026476106L;
    protected String userPrintManage;
    private String path = this.getClass().getResource("/").getPath() + "conf/tddj/printManage.xml";

    public String getUserPrintManage() {
        String userName = TddjUtil.getCurrentUserName();
        this.userPrintManage = this.readUser(userName);
        return this.userPrintManage;
    }

    public void setUserPrintManage(String userPrintManage) {
        this.userPrintManage = userPrintManage;
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request.getParameter("userValue") != null) {
            String userValue = request.getParameter("userValue");
            String userName = TddjUtil.getCurrentUserName();
            this.editUser(userName, userValue);
        }
        return "success";
    }

    public Document readXml() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(this.path);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    public void saveXml(Document document) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("GBK");
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(this.path)), format);
            output.write(document);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void editUser(String userName, String userValue) {
        Document document = this.readXml();
        boolean isExistUser = false;
        List nameList = document.selectNodes("/Config/user/name");
        List valueList = document.selectNodes("/Config/user/value");
        for (int i = 0; i < nameList.size(); ++i) {
            Element nameElement = (Element)nameList.get(i);
            if (!nameElement.getText().equals(userName)) continue;
            isExistUser = true;
            ((Element)valueList.get(i)).setText(userValue);
            break;
        }
        if (!isExistUser) {
            Element root = document.getRootElement();
            Element user = root.addElement("user");
            Element addUserName = user.addElement("name");
            addUserName.setText(userName);
            Element addUserValue = user.addElement("value");
            addUserValue.setText(userValue);
        }
        this.saveXml(document);
    }

    public String readUser(String userName) {
        String userPrint = "";
        Document document = this.readXml();
        List nameList = document.selectNodes("/Config/user/name");
        List valueList = document.selectNodes("/Config/user/value");
        for (int i = 0; i < nameList.size(); ++i) {
            Element nameElement = (Element)nameList.get(i);
            if (!nameElement.getText().equals(userName)) continue;
            userPrint = ((Element)valueList.get(i)).getText();
            break;
        }
        if (userPrint.equals("")) {
            userPrint = "1";
            Element root = document.getRootElement();
            Element user = root.addElement("user");
            Element addUserName = user.addElement("name");
            addUserName.setText(userName);
            Element addUserValue = user.addElement("value");
            addUserValue.setText(userPrint);
            this.saveXml(document);
        }
        return userPrint;
    }

    public void formatXMLFile(String filename) {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(new File(filename));
            XMLWriter writer = null;
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("GBK");
            writer = new XMLWriter((Writer)new FileWriter(new File(filename)), format);
            writer.write(document);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

