package com.jsegov.tddj.workflow;

import cn.gtmap.exchange.cxf.services.CheckTransformService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.IYGDJService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.YGDJ;
import org.apache.commons.lang.StringUtils;


//预告登记       没有地方用

public class WF_YGDJ implements WorkFlowEvent {

	/**
	 * 项目转发后 --------节点传送拷贝数据

	 */
	public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}
	public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		//获取当前活动ID
		// TODO Auto-generated method stub
        String msg="";
		String projectId = instanceObj.getPRO_ID();
		IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
		if (remark.equals("申请")){
			// 申请节点传送
            ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
			SQB sqb = sqbService.getSQB(projectId);
			ISPBService spbService = (ISPBService)Container.getBean("spbService");
			SPB spb=spbService.getSPB(projectId);
			if(spb==null){
				spb=new SPB();
				spb= spbService.readSQB(spb,sqb);
				spbService.insertSPB(spb);
			}else{
				spb= spbService.readSQB(spb,sqb);
				spbService.updateSPB(spb);
			}
		}else if (remark.equals("审核")) {
			// 审核节点传送			
			ISPBService spbService = (ISPBService)Container.getBean("spbService");
			SPB spb=spbService.getSPB(projectId);
			IYGDJService ygdjService = (IYGDJService)Container.getBean("ygdjService");
			YGDJ ygdj = ygdjService.getYGDJ(projectId);
			if (ygdj == null){
				ygdjService.insertYGDJ(getYGDJ(spb));
			}else{
				ygdjService.updateYGDJ(getYGDJ(spb));
			}
			
			IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
			if (djkxbService.getDJKXB(projectId) == null){
				djkxbService.insertDJKXB(spb);
			}else{
				djkxbService.updateDJKXB(spb);
			}
		}else if(remark.equals("批准")) {

		}	
		return msg;
	}
	
	public YGDJ getYGDJ(SPB spb){
		YGDJ ygdj = new YGDJ();
		ygdj.setDjh(spb.getDjh());
		ygdj.setProjectId(spb.getProjectId());
		ygdj.setQlr(spb.getRf2_dwmc());
		ygdj.setSyqmj(spb.getSyqmj().toString());
		ygdj.setTdzh(spb.getZtdzh());
		ygdj.setYgsqr(spb.getRf1_dwmc());
		ygdj.setZl(spb.getZl());
		ygdj.setShr(spb.getShr());
		ygdj.setShr_sign(spb.getShr_sign());
		ygdj.setShrq(CommonUtil.formateDate(spb.getPzrq()));
		ygdj.setIslogout(0);
		ygdj.setYgyy(spb.getXbnr());
		return ygdj;
	}
	
	/**
	 * 新增流程，写在ACTION中，这边不用
	 */
	public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		
		return false;
	}

	/**
	 * 项目删除-------需要删除哪些业务表在这写

	 */
	public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getProId();
		//删除项目表

		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		projectService.deleteProject(projectId);
		//删除收件单

		ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
		sjdService.deleteSJD(projectId);
		//删除收件单材料

		sjdService.deleteSJDCL(projectId);
		//删除申请表

		ISQBService sqbService= (ISQBService)Container.getBean("sqbService");
		sqbService.deleteSQB(projectId);
		//删除审批表

		ISPBService spbService= (ISPBService)Container.getBean("spbService");
		spbService.deleteSPB(projectId);
		//删除登记卡续表

		IDJKXBService djkxbService= (IDJKXBService)Container.getBean("djkXbService");
		djkxbService.deleteDJKXB(projectId);
		//删除预告登记
		IYGDJService ygdjService = (IYGDJService)Container.getBean("ygdjService");
		ygdjService.deleteYGDJ(projectId);
		return false;
	}

	/**
	 * 项目取回
	 * @param instanceObj 工作流实例对象

	 * @param wfac  取回前节点

	 * @return
	 */
	public boolean doGetBackAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		return false;
	}

	
	/**
	 * 项目终止后

	 * @param instanceObj
	 * @return
	 */
	public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		return false;
	}


	/**
	 * 项目退回

	 */
	public boolean doTurnBackAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		System.out.println("退回");
		return false;
	}

	
	public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * 工作流转发前
	 */
	public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
		String projectId = instanceObj.getPRO_ID();
		IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
		String projecttype = platUtil.getWfRemarkByProjectId(projectId);
		String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());	
		ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
        String msg=limitFieldService.checkLimitField(projecttype, remark, projectId);
        if(StringUtils.isBlank(msg) ){
            CheckTransformService checkTransformService= (CheckTransformService)Container.getBean("checkTransformService");
            msg=checkTransformService.checkTransformField(projecttype, remark, projectId);
        }
        return   msg;
    }
	
	public String doTurnBefore(PfWorkFlowInstanceVo instanceVo, PfActivityVo activityVo) {

		return null;
	}

	/**
	 * 项目办结后

	 */
	public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getPRO_ID();
		//System.out.println("办结projectId=----"+projectId);
		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		projectService.finishProject(projectId, CommonUtil.getCurrTime());
		return false;
	}

	/**
	 * 项目挂起前

	 */
	public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
		// TODO Auto-generated method stub
		return false;
	}
	
}
