package com.jsegov.tddj.workflow;


import cn.gtmap.exchange.cxf.services.CheckTransformService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IJFService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.JF;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.List;


//解封
public class WF_JF implements WorkFlowEvent {

    /**
     * 项目转发后 --------节点传送拷贝数据
     *
     * @param
     * @param
     * @param
     * @return
     */
    public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        // TODO Auto-generated method stub
        return false;
    }

    public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        //获取当前活动ID
        String msg = "";
        //String activityID = wfac.getWfacdefineid();
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        //System.out.print("adid===="+activityID+"===projectId==="+projectId);

        if (remark.equals("申请")) {

        }
        //System.out.println("办结"+projectId);
        // 1 续表
        IJFService jfService = (IJFService) Container.getBean("jfService");
        JF jf = jfService.getJF(projectId);
        String cfprojectid = jf.getCfProjectId();

        ICFService cfService = (ICFService) Container.getBean("cfService");
        CF cf = cfService.getCFByProjectId(cfprojectid);
        //如果解封的是续封，把原查封也解封了
        if(cf.getIsjf()!=null&&cf.getIsjf()==3) {
             CF ycf= cfService.getCFByProjectId(cf.getYcfprojectId());
            //更新查封记录ISJF=1
            ycf.setIsjf(1);
            cfService.updateCF(ycf);
        }
        //如果解封的查封存在续封，把续封也解封了
        CF cfParam=new CF();
        cfParam.setYcfprojectId(cf.getProjectId());
        cfParam.setIsjf(3);
        List<CF> xfList=cfService.getCF(cfParam);
        if(xfList.size()>0){
             for(CF cf1 : xfList) {
                 cf1.setIsjf(1);
                 cfService.updateCF(cf1);
             }
        }
        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        SJD sjd = sjdService.getSJD(projectId);

        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        Project project = projectService.getProject(projectId);

        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djk = djkService.getDJKByDjh(cf.getDjh());
        String djkbh = "";
        Integer djkid = 0;
        if (djk != null) {
            djkbh = djk.getDjkbh();
            djkid = djk.getDjkId();
        }
        DJKXB djkxb = new DJKXB();
        djkxb.setDjkId(djkid);
        djkxb.setProjectId(projectId);
        djkxb.setDjh(cf.getDjh());
        djkxb.setRq(CommonUtil.getCurrStrDate());
        //djkxb.setDjjs("证号："+cf.getTdzh()+"，地号："+cf.getDjh()+",因"+jf.getJfyy()+"被解封。");
        djkxb.setDjjs(jf.getXbnr());
        djkxb.setDjkjbr(project.getCreater());
        //djkxb.setDjkshr(djkshr);
        djkxb.setDjrq(CommonUtil.getCurrStrDate());
        djkxb.setDwdm(project.getDwdm());
        djkxb.setTdzh(cf.getTdzh());
        djkxb.setIslogout(0);
        djkxb.setIsprinted(0);
        djkxb.setDjkbh(djkbh);
        djkxb.setBsm(sjd.getBsm());
        //djkxb.setGhkh(ghkh);
        djkxb.setSqlx(sjd.getSqlx());//cf.getCflx()
        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        if (djkxbService.getDJKXB(projectId) == null) {
            djkxbService.insertDJKXB(djkxb);
        } else {
            djkxbService.updateDJKXB(djkxb);
        }
        //更新查封记录ISJF=1
        cf.setIsjf(1);
        cfService.updateCF(cf);
        //给预查封djkxb 回填 djkid
        if (cf.getCflx().equals("预查封")) {
            djkxb = djkxbService.getDJKXB(cfprojectid);
            if (djkxb != null && (djkxb.getDjkId() == null || djkxb.getDjkId().equals(""))) {
                djkxb.setDjkId(djkid);
                djkxb.setDjkbh(djkbh);
                djkxbService.updateDJKXB(djkxb);
            }
        }
        // 3 项目结束
        //IProjectService projectService = (IProjectService)Container.getBean("projectService");
        projectService.finishProject(projectId, CommonUtil.getCurrTime());
        //如果要解除所有的轮候查封
        List<CF> cfList=null;
        if(jf!=null&&jf.getIsjfAllLHCF()==1)  {
            if(cf.getCflx().equals("按宗查封"))  {
                String djh=cf.getDjh();
                cfList=  cfService.getCFByDjh(djh);
            }  else{
                String tdzh=cf.getTdzh();
                cfList = cfService.getCFByTdzh(tdzh);
            }
            for(CF lhcf : cfList){
                if(lhcf.getIsjf()==2){
                    lhcf.setIsjf(1);
                    cfService.updateCF(lhcf);
                }
            }
        }else{
            //设置下一轮候查封为查封
            cfService.updateNextLhxf(cf, projectId);
        }
        return msg;
    }


    /**
     * 新增流程，写在ACTION中，这边不用
     *
     * @param
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub

        return false;
    }

    /**
     * 项目删除-------需要删除哪些业务表在这写
     *
     * @param
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub
        String projectId = instanceObj.getProId();
        //删除项目表

        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        projectService.deleteProject(projectId);
        //删除收件单

        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        sjdService.deleteSJD(projectId);
        //删除收件单材料

        sjdService.deleteSJDCL(projectId);
        //删除登记卡续表

        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        djkxbService.deleteDJKXB(projectId);
        //还原轮候查封
        IJFService jfService = (IJFService) Container.getBean("jfService");
/*      //4.0平台由于不存在办结项目删除情况 所以下面代码不需要 因为办结前删除情况下 解封的证书状态还未被修改 不需要还原（如果平台提供办结删除项目恢复注释即可）
        JF jf = jfService.getJF(projectId);
        ICFService cfService = (ICFService) Container.getBean("cfService");
        CF cf = cfService.getCFByProjectId(jf.getCfProjectId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> cfList = null;
        map.put("isjf", 0);
        if (cf.getCflx().equals("按证查封")) {
            map.put("tdzh", cf.getTdzh());
            cfList = cfService.expCf(map);
        } else {
            map.put("djh", cf.getDjh());
            cfList = cfService.expCf(map);
        }
        if (cfList != null && cfList.size() > 0) {
            ((CF) cfList.get(0)).setIsjf(2);
            cfService.updateCF((CF) cfList.get(0));
        }
        //还原查封(如果是办结前删除 查封的证书状态还未更新 上面将会将其还原成2状态 下面会覆盖更新所以这种情况下也没有问题)
        cf.setIsjf(0);
        cfService.updateCF(cf);*/
        //解封
        jfService.deleteJF(projectId);
        return false;
    }

    /**
     * 项目取回
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        取回前节点
     * @return
     */
    public boolean doGetBackAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        return false;
    }


    /**
     * 项目终止后
     *
     * @param instanceObj
     * @return
     */
    public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub
        return false;
    }


    /**
     * 项目退回
     *
     * @param
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnBackAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        //System.out.println("退回");
        return false;
    }


    public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        // TODO Auto-generated method stub
        return false;
    }


    /**
     * 工作流转发前
     *
     * @param
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String projecttype = platUtil.getWfRemarkByProjectId(projectId);
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        ILimitFieldService limitFieldService = (ILimitFieldService) Container.getBean("limitFieldService");
        String msg=limitFieldService.checkLimitField(projecttype, remark, projectId);
        if(StringUtils.isBlank(msg) ){
            CheckTransformService checkTransformService= (CheckTransformService)Container.getBean("checkTransformService");
            msg=checkTransformService.checkTransformField(projecttype, remark, projectId);
        }
        return   msg;
    }


    public String doTurnBefore(PfWorkFlowInstanceVo instanceVo, PfActivityVo activityVo) {
        return null;
    }

    /**
     * 项目办结后
     *
     * @param
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
//		String projectId = instanceObj.getPRO_ID();
//		//System.out.println("办结"+projectId);
//		// 1 续表
//		IJFService jfService = (IJFService)Container.getBean("jfService");
//		JF jf = jfService.getJF(projectId);
//		String cfprojectid = jf.getCfProjectId();
//		
//		ICFService cfService = (ICFService)Container.getBean("cfService");
//		CF cf = cfService.getCFByProjectId(cfprojectid);
//		
//		ISJDService sjdService=(ISJDService)Container.getBean("sjdService");
//		SJD sjd= sjdService.getSJD(projectId);
//		
//		IProjectService projectService = (IProjectService)Container.getBean("projectService");
//		Project project = projectService.getProject(projectId);
//		
//		IDJKService djkService = (IDJKService)Container.getBean("djkService");
//		DJK djk = djkService.getDJKByDjh(cf.getDjh());
//		String djkbh = "";
//		Integer djkid = 0;
//		if (djk!=null){
//			djkbh = djk.getDjkbh();
//			djkid = djk.getDjkId();
//		}
//		DJKXB djkxb = new DJKXB();
//		djkxb.setDjkId(djkid);
//		djkxb.setProjectId(projectId);
//		djkxb.setDjh(cf.getDjh());
//		djkxb.setRq(CommonUtil.getCurrStrDate());
//		//djkxb.setDjjs("证号："+cf.getTdzh()+"，地号："+cf.getDjh()+",因"+jf.getJfyy()+"被解封。");
//		djkxb.setDjjs(jf.getXbnr());
//		djkxb.setDjkjbr(project.getCreater());
//		//djkxb.setDjkshr(djkshr);
//		djkxb.setDjrq(CommonUtil.getCurrStrDate());
//		djkxb.setDwdm(project.getDwdm());
//		djkxb.setTdzh(cf.getTdzh());
//		djkxb.setIslogout(0);
//		djkxb.setIsprinted(0);
//		djkxb.setDjkbh(djkbh);
//		djkxb.setBsm(sjd.getBsm());
//		//djkxb.setGhkh(ghkh);
//		djkxb.setSqlx(sjd.getSqlx());//cf.getCflx()
//		IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
//		if (djkxbService.getDJKXB(projectId) == null){
//			djkxbService.insertDJKXB(djkxb);
//		}else{
//			djkxbService.updateDJKXB(djkxb);
//		}
//		//更新查封记录ISJF=1
//		cf.setIsjf(1);
//		cfService.updateCF(cf);
//		//给预查封djkxb 回填 djkid
//		if (cf.getCflx().equals("预查封")){
//			djkxb = djkxbService.getDJKXB(cfprojectid);
//			if (djkxb != null && (djkxb.getDjkId() == null || djkxb.getDjkId().equals(""))){
//				djkxb.setDjkId(djkid);
//				djkxb.setDjkbh(djkbh);
//				djkxbService.updateDJKXB(djkxb);
//			}
//		}
//		// 3 项目结束
//		//IProjectService projectService = (IProjectService)Container.getBean("projectService");
//		projectService.finishProject(projectId, CommonUtil.getCurrDate());
        return false;
    }


    /**
     * 项目挂起前
     *
     * @param
     * @return
     */
    public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
        // TODO Auto-generated method stub
        return false;
    }

}
