package com.jsegov.tddj.workflow;

import cn.gtmap.exchange.cxf.services.CheckTransformService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.ServerCheckService;
import com.jsegov.tddj.services.interf.IArchivesPostService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProRelationService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.services.interf.IZSService;
import com.jsegov.tddj.util.CheckUtil;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.GYQDJK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import org.apache.commons.lang.StringUtils;


//更正登记        没有
public class WF_GZDJ implements WorkFlowEvent {

    /**
     * 项目转发后 --------节点传送拷贝数据
     * <p/>
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
        //获取当前活动ID
        String msg = "";
        //String activityID = wfac.getWfacdefineid();
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        //System.out.print("adid===="+remark+"===projectId==="+projectId);
        if (remark.equals("申请")) {
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            SQB sqb = (SQB) sqbService.getSQB(projectId);

            SPB spb = spbService.getSPB(projectId);
            if (spb == null) {
                spb = new SPB();
                spb = spbService.readSQB(spb, sqb);
                spbService.insertSPB(spb);
            } else {
                spb = spbService.readSQB(spb, sqb);
                spbService.updateSPB(spb);
            }
        } else if (remark.equals("批准")) {
            // 批准节点传送
            //            服务器验证
            // 批准节点传送
            ServerCheckService serverCheckService = (ServerCheckService) Container
                    .getBean("serverCheckService");
            String djlx = "更正登记";
            String sqlx = null;
            String djh = null;
            String tdzh = null;
            String qlr = null;
            String tdzl = null;
            String qsxz = null;
            SPB spb = spbService.getSPB(projectId);
            if (spb != null) {
                djh = spb.getDjh();
                sqlx = spb.getSqlx();
                qlr = spb.getRf1_dwmc();
                tdzh = spb.getZtdzh();
                tdzl = spb.getZl();
                qsxz = CheckUtil.getQsxz(spb.getQsxz());
            }
            msg = serverCheckService.serverCheck(djlx, sqlx, djh, tdzh, qlr, tdzl, qsxz);
            if (StringUtils.isEmpty(msg)) {
                doEndProject(projectId);
            }
        }
        return msg;
    }


    /**
     * 新增流程，写在ACTION中，这边不用
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj) {
        return false;
    }

    /**
     * 项目删除-------需要删除哪些业务表在这写
     * <p/>
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
        String projectId = instanceObj.getProId();
        //删除项目表

        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        projectService.deleteProject(projectId);
        //删除收件单

        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        sjdService.deleteSJD(projectId);
        //删除收件单材料

        sjdService.deleteSJDCL(projectId);
        //删除申请表

        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        SQB sqb = sqbService.getSQB(projectId);
        String ztdzh = sqb.getZtdzh();
        IZSService zsService = (IZSService) Container.getBean("zsService");
        zsService.logoutZS(ztdzh, 0);
        sqbService.deleteSQB(projectId);
        //保存删除的tdzh防止证书跳号
        CommonUtil.saveDelTdzh(projectId);

        //删除审批表

        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        spbService.deleteSPB(projectId);
        //删除登记卡

        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        djkService.deleteDJK(projectId);
        //删除登记卡续表

        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        djkxbService.deleteDJKXB(projectId);
        //删除土地证--待改进

        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        gytdsyzService.deleteGYTDSYZ(projectId);
        IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
        jttdsyzService.deleteJTTDSYZ(projectId);
        IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
        jttdsuzService.deleteJTTDSUZ(projectId);
        //删除归户卡

        IGHKService ghkService = (IGHKService) Container.getBean("ghkService");
        ghkService.deleteGHK(projectId);
        GHK ghk = ghkService.getGHKByTdzh(ztdzh);
        if (ghk != null) {
            ghk.setIslogout(0);// 还原老的归户卡

            ghkService.updateGHK(ghk);
        }
        //删除共有权登记卡
        IGYQDJKService gyqdjkService = (IGYQDJKService) Container.getBean("gyqDjkService");
        gyqdjkService.deleteGYQDJK(projectId);
        //删除项目关系表

        IProRelationService proRelationService = (IProRelationService) Container.getBean("proRelationService");
        proRelationService.deleteProjectRelation(projectId);
        // 删除土地证记事

        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        tdzjsService.deleteTDZJS(projectId);
        return false;
    }

    /**
     * 项目取回
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        取回前节点
     * @return
     */
    public boolean doGetBackAfter(WfInstance instanceObj, WfActivity wfac) {
        return false;
    }


    /**
     * 项目终止后
     *
     * @param instanceObj
     * @return
     */
    public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj) {
        String projectId = instanceObj.getProId();
        // IZSService zsService = (IZSService)Container.getBean("zsService");
        // ISPBService spbService =
        // (ISPBService)Container.getBean("spbService");
        // String projectId = instanceObj.getProId();
        // SPB spb = spbService.getSPB(projectId);
        // if (spb != null){
        // String tdzh = spb.getTdzh();
        // if (zsService.getZSByTdzh(tdzh) != null)
        // zsService.logoutZS(tdzh, 10);//注销为10终止的证书

        // }
        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
        IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        IGHKService ghkService = (IGHKService) Container.getBean("ghkService");
        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        IProRelationService proRelationService = (IProRelationService) Container.getBean("proRelationService");
        IGYQDJKService gyqdjkService = (IGYQDJKService) Container.getBean("gyqDjkService");

        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        IZSService zsService = (IZSService) Container.getBean("zsService");
        // 还原老证书状态

        SQB sqb = sqbService.getSQB(projectId);
        String ztdzh = sqb.getZtdzh();
        zsService.logoutZS(ztdzh, 0);
        // 还原归户卡状态

        GHK ghk = ghkService.getGHKByTdzh(ztdzh);
        if (ghk != null) {
            ghk.setIslogout(0);
            ghkService.updateGHK(ghk);
        }
        // 逻辑：如果项目终止且产生了相关不合法数据，就删掉
        gytdsyzService.deleteGYTDSYZ(projectId);
        jttdsyzService.deleteJTTDSYZ(projectId);
        jttdsuzService.deleteJTTDSUZ(projectId);
        djkService.deleteDJK(projectId);
        djkxbService.deleteDJKXB(projectId);
        ghkService.deleteGHK(projectId);
        tdzjsService.deleteTDZJS(projectId);
        proRelationService.deleteProjectRelation(projectId);
        gyqdjkService.deleteGYQDJK(projectId);
        return false;
    }

    public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        return false;
    }

    /**
     * 项目退回
     * <p/>
     * //* @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnBackAfter(WfInstance instanceObj, WfActivity wfac) {
        //System.out.println("退回");
        return false;
    }


    public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        return false;
    }

    /**
     * 工作流转发前
     * //* @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String projecttype = platUtil.getWfRemarkByProjectId(projectId);
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        ILimitFieldService limitFieldService = (ILimitFieldService) Container.getBean("limitFieldService");
        String msg=limitFieldService.checkLimitField(projecttype, remark, projectId);
        if(StringUtils.isBlank(msg)){
            if("注册打印".equals(remark)){
                IZSService zsService = (IZSService) Container.getBean("zsService");
                msg= zsService.checkTdzhIsExist(projectId);
            }
        }
        if(StringUtils.isBlank(msg) ){
            CheckTransformService checkTransformService= (CheckTransformService)Container.getBean("checkTransformService");
            msg=checkTransformService.checkTransformField(projecttype, remark, projectId);
        }
        return   msg;
    }

    public String doTurnBefore(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        return null;
    }

    /**
     * 项目办结后
     * <p/>
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
        String projectId = instanceObj.getPRO_ID();
        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        projectService.finishProject(projectId, CommonUtil.getCurrTime());
        //zdd 2011-5-7  办结后自动归档
        IArchivesPostService archivesPostService = (IArchivesPostService) Container.getBean("archivesPostService");
        archivesPostService.ArchivesPost(instanceObj.getPRO_ID());
        return false;
    }


    /**
     * 项目挂起前
     * <p/>
     * // * @param request
     * // * @param instanceObj 工作流实例对象
     * <p/>
     * //* @param wfac 活动实例对象
     *
     * @return
     */
    public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
        return false;
    }

    public void doEndProject(String projectId) {
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = (SPB) spbService.getSPB(projectId);
        // 1 生成土地证书
        IZSService zsService = (IZSService) Container.getBean("zsService");
        if (zsService.getZSBySpb(spb)== null) {
            zsService.creatZS(spb);
        } else {
            zsService.updateZS(spb);
        }
        // 1.2 土地证记事

        if (spb.getJs() != null && !spb.getJs().equals("")) {
            ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
            if (tdzjsService.getTDZJSByProjectId(projectId) == null) {
                tdzjsService.insertTDZJS(spb);
            } else {
                tdzjsService.updateTDZJS(spb);
            }
        }
        // 2 归户卡

        IGHKService ghkService = (IGHKService) Container.getBean("ghkService");
        if (ghkService.getGHK(projectId) == null) {
            ghkService.insertGHK(spb);
        } else {
            ghkService.updateGHK(spb);
        }
        /*
        判断是新地号还是老地号
         */
        String newDjh = "";
        String oldDjh = "";
        if (!spb.getDjh().equals("")) {
            if(spb.getDjh().length()==19 && spb.getTdjg().length()>4){
                if(spb.getDjh().substring(12,13).equals("G") || spb.getDjh().substring(12,13).equals("J")){
                    newDjh = spb.getDjh();
                }else {
                    oldDjh = spb.getDjh();
                }
            }
        }else{
            oldDjh =  spb.getDjh();
        }
        // 3 生成登记卡
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
//            if (djkService.getDJKByDjh(spb.getDjh()) == null) {
//                djkService.insertDJK(spb);
//            } else {
//                //djkService.updateDJK(spb);
//            }
        if(newDjh !=null && !newDjh.equals("")){
            if (djkService.getDJKByDjh(newDjh)==null){
                djkService.insertDJK(spb);
            }else{
                djkService.updateDJK(spb);
            }
        } else if(oldDjh!= null && !oldDjh.equals("")){
            if (djkService.getDJKByOldDjh(oldDjh)==null){
                djkService.insertDjk(spb);
            }else{
                djkService.updateDjk(spb);
            }
        }
        // 4 生成登记卡续表

        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        if (djkxbService.getDJKXB(projectId) == null) {
            djkxbService.insertDJKXB(spb);
        } else {
            djkxbService.updateDJKXB(spb);
        }
        // 5 记录项目关系
        IProRelationService proRelationService = (IProRelationService) Container.getBean("proRelationService");
        if (proRelationService.getProRelation(projectId) == null) {
            proRelationService.insertProjectRelation(spb);
        } else {
            proRelationService.updateProjectRelation(spb);
        }
        // 5 如果有共有权
        if (spb.getFtmj() > 0) {
            IGYQDJKService gyqdjkService = (IGYQDJKService) Container.getBean("gyqDjkService");
            if (gyqdjkService.getGYQDJK(projectId) == null) {
                gyqdjkService.insertGYQDJK(spb);
            } else {
                gyqdjkService.updateGYQDJK(spb);
            }
            GYQDJK gyqdjk = gyqdjkService.getGYQDJKbyTdzh(spb.getZtdzh());
            if (gyqdjk != null) {
                gyqdjk.setIslogout(1);
                gyqdjkService.updateGYQDJK(gyqdjk);
            }
        }
        // 6 注销变更的土地证
        zsService.logoutZS(spb.getZtdzh(), 1);
        // 7 注销原归户卡
        ghkService.logoutGHK(spb.getZtdzh());

        //System.out.println("办结"+projectId);
        // 项目结束
    }

}
