package com.jsegov.tddj.workflow;

import java.sql.Timestamp;
import java.util.Date;

import cn.gtmap.exchange.cxf.services.CheckTransformService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import org.apache.commons.lang.StringUtils;

//import com.jsegov.web2.vo.PfActivityVo;
//import com.jsegov.web2.vo.PfWorkFlowInstanceVo;
//import com.jsegov.wf.core.WfActivity;
//import com.jsegov.wf.core.WfInstance;
//查封
public class WF_CF implements WorkFlowEvent {

    /**
     * 项目转发后 --------节点传送拷贝数据
     * <p/>
     * <p/>
     * //	 * @param request
     * //	 * @param instanceObj
     * //	 *            工作流实例对象
     * <p/>
     * //	 * @param wfac
     * //	 *            活动实例对象
     * //	 * @return
     * //
     */
    public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        // TODO Auto-generated method stub
        return false;
    }

    public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        // 获取当前活动ID
        // String activityID = wfac.getWfacdefineid();
        String msg = "";
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        // System.out.print("adid===="+activityID+"===projectId==="+projectId);
        if (remark.equals("查封") || remark.equals("轮候查封")) {
            // 查封节点传送
            // System.out.println("查封节点传送");
            doTurnOverAfter(instanceObj, wfac);
        }
        return msg;
    }

    /**
     * 新增流程，写在ACTION中，这边不用
     * <p/>
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub

        return false;
    }

    /**
     * 项目删除-------需要删除哪些业务表在这写
     * <p/>
     * <p/>
     * // * @param request
     *
     * @param instanceObj 工作流实例对象
     * @return
     */
    public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub
        String projectId = instanceObj.getProId();
        // 删除项目表

        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        projectService.deleteProject(projectId);
        // 删除收件单

        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        sjdService.deleteSJD(projectId);
        // 删除收件单材料

        sjdService.deleteSJDCL(projectId);
        // 删除登记卡续表

        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        djkxbService.deleteDJKXB(projectId);
        // 查封
        ICFService cfService = (ICFService) Container.getBean("cfService");
        //删除续封是恢复 原查封的查封结束日期 恢复为默认查封开始日期后2年
        CF cf = cfService.getCFByProjectId(projectId);
        if(cf.getIsjf()!=null){
            if(cf.getIsjf()==3){
                CF ycf = cfService.getCFByProjectId(cf.getYcfprojectId());
                Date cfksrq = ycf.getCfksrq();
                Date cfjsrq = ycf.getCfjsrq();
                cfjsrq.setYear(cfksrq.getYear()+2);
                cfjsrq.setMonth(cfksrq.getMonth());
                cfjsrq.setDate(cfksrq.getDate());
                cfService.updateCF(ycf);
            }
        }
        cfService.deleteCF(projectId);
        return false;
    }

    /**
     * 项目取回
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        取回前节点
     * @return
     */
    public boolean doGetBackAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        return false;
    }

    /**
     * 项目终止后
     *
     * @param instanceObj
     * @return
     */
    public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj) {
        // TODO Auto-generated method stub
        return false;
    }

    /**
     * 项目退回
     * <p/>
     * <p/>
     * /// * @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnBackAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        System.out.println("退回");
        return false;
    }

    public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
        // TODO Auto-generated method stub
        return false;
    }

    /**
     * 工作流转发前
     * <p/>
     * //* @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String projecttype = platUtil.getWfRemarkByProjectId(projectId);
        String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
        ILimitFieldService limitFieldService = (ILimitFieldService) Container.getBean("limitFieldService");
        String msg=limitFieldService.checkLimitField(projecttype, remark, projectId);
        if(StringUtils.isBlank(msg) ){
            CheckTransformService checkTransformService= (CheckTransformService)Container.getBean("checkTransformService");
            msg=checkTransformService.checkTransformField(projecttype, remark, projectId);
        }
        return   msg;
    }

    public String doTurnBefore(PfWorkFlowInstanceVo instanceVo, PfActivityVo activityVo) {
        return null;
    }

    /**
     * 项目办结后
     * <p/>
     * <p/>
     * //* @param request
     *
     * @param instanceObj 工作流实例对象
     * @param wfac        活动实例对象
     * @return
     */
    public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
        // TODO Auto-generated method stub
        String projectId = instanceObj.getPRO_ID();
        // System.out.println("办结"+projectId);
        // 1 查封iscf=1
        ICFService cfService = (ICFService) Container.getBean("cfService");
        CF cf = cfService.getCFByProjectId(projectId);

        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        Project project = projectService.getProject(projectId);
        //如果是续封,修改原查封的查封结束日期
        if(cf.getIsjf()==3){
            CF ycf = cfService.getCFByProjectId(cf.getYcfprojectId());
            if(ycf!=null) {
                ycf.setCfjsrq(cf.getCfjsrq());
                cfService.updateCF(ycf);
            }
        }
        // 2 续表
        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        SJD sjd = sjdService.getSJD(projectId);

        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djk = djkService.getDJKByDjh(cf.getDjh());

        String djkbh = "";
        Integer djkid = 0;
        if (djk != null) {
            djkbh = djk.getDjkbh();
            djkid = djk.getDjkId();
        }
        DJKXB djkxb = new DJKXB();
        djkxb.setDjkId(djkid);
        djkxb.setProjectId(projectId);
        djkxb.setDjh(cf.getDjh());
        djkxb.setRq(CommonUtil.getCurrStrDate());
        //djkxb.setDjjs("证号：" + cf.getTdzh() + "，地号：" + cf.getDjh() + ",因"
        //		+ cf.getCfyy() + "被查封。");
        djkxb.setDjjs(cf.getXbnr());
        djkxb.setDjkjbr(project.getCreater());
        // djkxb.setDjkshr(djkshr);
        djkxb.setDjrq(CommonUtil.getCurrStrDate());
        djkxb.setDwdm(project.getDwdm());
        djkxb.setTdzh(cf.getTdzh());
        djkxb.setIslogout(0);
        djkxb.setIsprinted(0);
        djkxb.setDjkbh(djkbh);
        djkxb.setBsm(sjd.getBsm());
        // djkxb.setGhkh(ghkh);
        djkxb.setSqlx(cf.getCflx());
        IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
        if (djkxbService.getDJKXB(projectId) == null) {
            djkxbService.insertDJKXB(djkxb);
        } else {
            djkxbService.updateDJKXB(djkxb);
        }
        // 3 查封续表内容
        //System.out.println(cf.getXbnr());

        // 4 项目结束
        // IProjectService projectService =
        // (IProjectService)Container.getBean("projectService");
        projectService.finishProject(projectId, CommonUtil.getCurrTime());
        // 5 保存设定日期的时间

        String time = CommonUtil.getCurrStrTime();
        time = time.substring(10, time.length() - 1);
        String date = CommonUtil.formateDate(cf.getSdrq());
        if (!"".endsWith(date)) {
            cf.setSdrq(Timestamp.valueOf(date + time));
        }

        cfService.updateCF(cf);
        //轮候查封更新lhxh
        cfService.updateLhcf(cf, null);
        return false;
    }

    /**
     * 项目挂起前
     * <p/>
     * <p/>
     * //* @param request
     * // * @param instanceObj
     * 工作流实例对象
     * <p/>
     * //* @param wfac
     * 活动实例对象
     *
     * @return
     */
    public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
        // TODO Auto-generated method stub
        return false;
    }

}
