package com.jsegov.tddj.util;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelCheckUtil {
	public static String getStringCellValue(Cell cell) {
        if (cell == null){
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case HSSFCell.CELL_TYPE_BOOLEAN:
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            case HSSFCell.CELL_TYPE_NUMERIC:
                if (HSSFDateUtil.isCellDateFormatted(cell)) {
                    java.text.SimpleDateFormat TIME_FORMATTER = new java.text.SimpleDateFormat(
                            "yyyy-MM-dd");
                    result = TIME_FORMATTER.format(cell.getDateCellValue());
                }
                else{
                    cell.setCellType(HSSFCell.CELL_TYPE_STRING);

                    String cellValue = cell.toString();


                    result = "" + cellValue;
                }
                break;
            case HSSFCell.CELL_TYPE_STRING:
                if (cell.getRichStringCellValue() == null){
                    result = null;
                }
                else{
                    result = cell.getRichStringCellValue().getString();
                }
                break;
            case HSSFCell.CELL_TYPE_BLANK:
                result = null;
                break;
            case HSSFCell.CELL_TYPE_FORMULA:
                try{
                    result = String.valueOf(cell.getNumericCellValue());
                }catch(Exception e){
                    result = cell.getRichStringCellValue().getString();
                }
                break;
            default:
                result = "";
        }

        return result;
    }
}
