package com.jsegov.tddj.util;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IZDDZBService;
import com.jsegov.tddj.vo.ZDDZB;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: luqing
 * Date: 15-6-25
 * Time: 下午1:45
 * To change this template use File | Settings | File Templates.
 */
public class DjhConvert {
    private static String rtnMsg = "OK";
    public String getRtnMsg() {
        return rtnMsg;
    }

    public void setRtnMsg(String rtnMsg) {
        this.rtnMsg = rtnMsg;
    }



    //根据新老地号转换新地号
    public static HashMap ConvertToNewDjh(String oldDjh)
    {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if(StringUtils.isNotBlank(oldDjh)){
            IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");
            List<ZDDZB> zddzbList = zddzbService.selectNewDjhFromZddzb("%"+oldDjh+"%");
            String addDjh = null;
            //oracle in只支持1000个
            if(zddzbList!=null && zddzbList.size()>1000){
                rtnMsg = "模糊匹配数据超过1000条，请输入更精确的地号信息";
                int i = 0;
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                    i++;
                    if(i==1000){
                        break;
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }else{
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }

      }
        return map;
    }

    //根据新老地号转换老地号
    public static HashMap ConvertToOldDjh(String oldDjh)
    {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if(StringUtils.isNotBlank(oldDjh)){
            IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");
            List<ZDDZB> zddzbList = zddzbService.selectOldDjhFromZddzb("%"+oldDjh+"%");
            String addDjh = null;
            //oracle in只支持1000个
            if(zddzbList!=null && zddzbList.size()>1000){
                rtnMsg = "模糊匹配数据超过1000条，请输入更精确的地号信息";
                int i = 0;
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                    i++;
                    if(i==1000){
                        break;
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }else{
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }

    }
        return map;
   }

}

