package com.jsegov.tddj.util;

import com.gtis.spring.Container;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.vo.DelTdzh;
import com.jsegov.tddj.vo.FTP;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.XZQ;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

import javax.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class CommonUtil {

	 /* public static void main(String[] args) { 
		  CommonUtil a = new CommonUtil();
		  System.out.println("resultDouble:"+a.formatNumber(0.35555,"syq"));  
	  }*/
	 

	/**
	 * 格式化Double精度 type为默认

	 * 
	 * 默认是按照conf/tddj/tddj.xml下配置精度格式化
	 * 
	 * @param value 
	 * @return 默认面积精度
	 */
	public static Double formatNumber(Double value) {
		return formatNumber(value, "default");
	}

	/**
	 * 用于格式化数值型数据 type类型包括 syq,suq,je
	 * 
	 * @author liuz
	 * @param value 
	 * @param type
	 * @return 按精度类型格式化
	 */
	public static Double formatNumber(Double value, String type) {
		Common commom = new Common();
		String precision = commom.getPrecision(type);
		//System.out.println("precision:"+precision);
		//System.out.println("paramDouble:"+value);
		BigDecimal bd = new BigDecimal(Double.toString(value));
        BigDecimal one = new BigDecimal("1");
		bd = bd.divide(one,Integer.parseInt(precision),BigDecimal.ROUND_HALF_UP);
		//System.out.println("bigDecimal:"+bd);
		value = bd.doubleValue();
		return value;
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 字符串型当前时间
	 */
	public static String getCurrStrTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		return str;
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 日期型当前时间

	 */
	public static Date getCurrTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		Timestamp date = Timestamp.valueOf(str);
		return date;
	}

	/**
	 * 格式化时间 
	 * 
	 * @param date 类型为java.sql.date
	 * @return 字符串型日期和时间值

	 */
	public static String formateTime(java.sql.Date date) {
		String strDate = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		strDate = sdf.format(date);
		return strDate;
	}

	/**
	 * 格式化时间 
	 * 
	 * @param date 类型为java.util.date
	 * @return 字符串型日期和时间值 
	 */
	public static String formateTime(Date date) {
		String strDate = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		strDate = sdf.format(date);
		return strDate;
	}

	/**
	 * 获取当前时间 
	 * 
	 * @return 字符串型日期值

	 */
	public static String getCurrStrDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		return str;
	}

	/**
	 * 获取当前时间 
	 * 
	 * @return 日期型日期值

	 */
	public static Date getCurrDate() {
		Date date = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		try {
			date = sdf.parse(str);
		} catch (Exception e) {
			return null;
		}
		return date;
	}

	/**
	 * 格式化时间 
	 * 
	 * @param date 类型为java.util.date
	 * @return 日期型日期值

	 */
	public static Date formatDate(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String str = sdf.format(date);
		try {
			date = sdf.parse(str);
		} catch (Exception e) {
			return null;
		}
		return date;
	}

	/**
	 * 格式化时间 
	 * 
	 * @param date 类型为java.sql.date
	 * @return 字符型日期值

	 */
	public static String formateDate(java.sql.Date date) {
		String strDate = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		strDate = sdf.format(date);
		return strDate;
	}

	/**
	 * 格式化时间 
	 * 
	 * @param date 类型为java.util.date
	 * @return 字符型日期值

	 */
	public static String formateDate(Date date) {
		String strDate = "";
        if(date==null) {
            return "" ;
        }
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		strDate = sdf.format(date);
		return strDate;
	}

	/**
	 * 格式化日期字符串
	 * 
	 * @param dateString
	 * @return 日期型日期值

	 */
	public static Date formateDateToStr(String dateString) {
		Date formateDate = null;
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		try {
			formateDate = format.parse(dateString);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return formateDate;
	}

	/**
	 * 格式化日期字符串
	 * 
	 * @param dateString
	 * @return 字符型日期值

	 */
	public static String formateDateToString(String dateString) {
		Date formateDate = null;
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		try {
			formateDate = format.parse(dateString);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return formateDate(formateDate);
	}

	/**
	 * 获取当前年份
	 * 
	 * @return 字符串型当前年份
	 */
	public static String getCurrYear() {
		GregorianCalendar today = new GregorianCalendar();
		String curYear = today.get(GregorianCalendar.YEAR) + "";
		return curYear;
	}

	/**
	 * 获取XZQ对象
	 * 
	 * @return XZQ对象
	 */
	public static XZQ getXZQ() {
		Common commom = new Common();
		XZQ xzq = commom.getXZQ();
		return xzq;
	}

	/**
	 * 获取FTP对象
	 * 
	 * @return FTP对象
	 */
	public static FTP getFTP() {
		Common commom = new Common();
		FTP ftp = commom.getFTP();
		return ftp;
	}

	/**
	 * 读取tddj.XML中"filter/dwdm"的值判断：全局是否根据dwdm过滤数据 使用格式：map =
	 * CommonUtil.getDwdmQuery(request, map)
	 * 
	 * @author liuz
	 * @param request
	 * @param map
	 * @return map
	 */
	public static HashMap<String, Object> getDwdmQuery(HttpServletRequest request, HashMap<String, Object> map) {
        try {
    		String userDwdm = TddjUtil.getCurrentUserDwdm();
    		
    		Common commom = new Common();
    		if (commom.isFilterByDwdm()&& userDwdm!=null && !userDwdm.equals("") ) {
    			map.put("dwdm", userDwdm);
    		}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}		
		
		// map.put("djh",new StringBuilder(userDwdm).append("%").toString());
		return map;
	}

	/**
	 * 读取tddj.XML中"filter/djh"的值判断：全局是否根据djh过滤数据 使用格式：map =
	 * CommonUtil.getDwdmQuery(request, map)
	 * 
	 * @author liuz
	 * @param request
	 * @param map
	 * @return map
	 */
	public static HashMap<String, Object> getDjhQuery(HttpServletRequest request, HashMap<String, Object> map) {
		String userDwdm = TddjUtil.getCurrentUserDwdm();		
		Common commom = new Common();
		if (commom.isFilterByDwdm()) {
            if(userDwdm.equals("320800")){
                userDwdm="3208";
            }
			map.put("djh", new StringBuilder(userDwdm).append("%").toString());
		}	
		return map;
	}

	/**
	 * 从tddj/tddj.xml获取currentYear/value的值 结果为年份字符串 形式为"2008"
	 * 
	 * @author liuz
	 * @return 字符串型当前年份
	 */
	public static String getCURRENTYEAR() {
		Common commom = new Common();
		String curYear = commom.getCURRENTYEAR();
		return curYear;
	}

	/**
	 * 向tddj/tddj.xml写currentYear/value的值 curYear
	 * 为年份字符串 形式"2008"
	 * 
	 * @author liuz
	 * @param curYear
	 */
	public static void setCURRENTYEAR(String curYear) {
		Common commom = new Common();
		commom.setCURRENTYEAR(curYear);
	}

	/**
	 * 调用commom.getAllNodeid()获取全部活动描述(节点名称)
	 * 
	 * @author liuz
	 * @return listAllNodeid
	 */
	public static List<String> getAllNodeid() {
		Common commom = new Common();
		List<String> listAllNodeid = commom.getAllNodeid();
		return listAllNodeid;
	}

	/**
	 * 调用commom.getAllSqlx()获取全部申请类型
	 * 
	 * @author liuz
	 * @return listAllSqlx
	 */
	public static List<String> getAllSqlx() {
		Common commom = new Common();
		List<String> listAllSqlx = commom.getAllSqlx();
		return listAllSqlx;
	}

	/**
	 * 用于批量打印组织数据xml数据源包含detail数据
	 * 
	 * @param list
	 * @param listDetail
	 * @param request
	 * @return 获取数据后的StringBuffer
	 */
	public static StringBuffer getManyDatasWithDetailXML(List<Object> list, List<Object> listDetail,
			HttpServletRequest request) {
		StringBuffer sb = new StringBuffer();
		for (int j = 0; j < list.size(); j++) {
			sb.append("<datas>");
			int k = j;
			Object obj = list.get(j);

			if (obj != null) {
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						if (fieldName.equals("serialVersionUID")) {
							continue;
						}
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
								1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue = null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if (adate == null) {
								fieldValue = "";
							} else {
								fieldValue = formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue = avalue == null ? 0 : avalue;
							fieldValue = avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue = dvalue == null ? 0 : dvalue;
							fieldValue = dvalue.toString();
						}

						fieldValue = fieldValue == null ? "" : fieldValue;
						fieldValue = fieldValue.replaceAll("<", "&lt;");
						fieldValue = fieldValue.replaceAll(">", "&gt;");
						// 签名图片
						if (fieldName.indexOf("_sign") > -1) {
							sb.append("<data name=\"" + fieldName + "\" type=\"image\">");
							String path = request.getContextPath();
							String basePath = request.getScheme() + "://" + request.getServerName() + ":"
									+ request.getServerPort() + path + "/";
							sb.append(basePath + "GetSignServlet?signid=" + fieldValue);
							sb.append("</data>");
						} else {
							sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
							sb.append(fieldValue);
							sb.append("</data>");
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			sb.append("</datas>");
		}
		return sb;
	}

    /**
     * 用于批量打印组织数据xml数据源
     * @param list
     * @param request
     * @return 获取数据后的Document
     */
    public static Document getManyDatasXMLDoc(List<Object> list, HttpServletRequest request)
    {
        Document doc= DocumentHelper.createDocument();
        Element root = doc.addElement("fetchdatas");
        for (int j = 0; j < list.size(); j++) {
            Element page = root.addElement("page");
            Element datas = page.addElement("datas");
           
            int k = j;
            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,1).toUpperCase());
                        Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;
                        // 签名图片
                        if (fieldName.indexOf("_sign") > -1) {

                            Element data = datas.addElement("data");
                            data.addAttribute("name",fieldName) ;
                            data.addAttribute("type","image");

                            //图片路径
                            String path = request.getContextPath();
                            String basePath = request.getScheme() + "://" + request.getServerName() + ":"
                                    + request.getServerPort() + path + "/";

                            data.setText(basePath + "GetSignServlet?signid=" + fieldValue);

                        } else {
                            Element data = datas.addElement("data");
                            data.addAttribute("name",fieldName) ;
                            data.addAttribute("type","String(50)");
                            data.setText(fieldValue);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return doc;
    }

	/**
	 * 用于打印组织数据xml数据源包含detail数据
	 * 
	 * @param obj
	 * @return
	 */
	public static String getDataXML(Object obj) {
		StringBuffer sb = new StringBuffer();
		sb.append("<datas>");
		if (obj != null) {
			Field[] fds;
			try {
				fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
				for (int i = 0; i < fds.length; i++) {
					String fieldName = fds[i].getName();
					if (fieldName.equals("serialVersionUID")) {
						continue;
					}
					String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1)
							.toUpperCase());
					Method m = obj.getClass().getMethod("get" + tempFieldName, null);
					String returnType = m.getReturnType().getName();
					String fieldValue = null;
					if (returnType.equals("java.lang.String")) {
						fieldValue = (String) m.invoke(obj, null);
					} else if (returnType.equals("java.util.Date")) {
						Date adate = (Date) m.invoke(obj, null);
						if (adate == null) {
							fieldValue = "";
						} else {
							fieldValue = formateDate(adate);
						}
					} else if (returnType.equals("java.lang.Integer")) {
						Integer avalue = (Integer) m.invoke(obj, null);
						avalue = avalue == null ? 0 : avalue;
						fieldValue = avalue.toString();
					} else if (returnType.equals("java.lang.Double")) {
						Double dvalue = (Double) m.invoke(obj, null);
						dvalue = dvalue == null ? 0 : dvalue;
						fieldValue = dvalue.toString();
					}
					fieldValue = fieldValue == null ? "" : fieldValue;
					fieldValue = fieldValue.replaceAll("<", "&lt;");
					fieldValue = fieldValue.replaceAll(">", "&gt;");
					// 签名图片
					if (fieldName.indexOf("_sign") > -1) {
						sb.append("<data name=\"" + fieldName + "\" type=\"image\">");
						sb.append("GetSignServlet?signid=" + fieldValue);
						sb.append("</data>");
					} else {
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		sb.append("</datas>");
		return sb.toString();
	}

	/**
	 * 用于打印组织数据xml数据源datas数据
	 * 
	 * @param obj
	 * @param request
	 * @return
	 */
	public static String getDataXML(Object obj, HttpServletRequest request) {
		StringBuffer sb = new StringBuffer();
		sb.append("<datas>");
		if (obj != null) {
			Field[] fds;
			try {
				fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
				for (int i = 0; i < fds.length; i++) {
					String fieldName = fds[i].getName();
					if (fieldName.equals("serialVersionUID")) {
						continue;
					}
					String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1)
							.toUpperCase());
					Method m = obj.getClass().getMethod("get" + tempFieldName, null);
					String returnType = m.getReturnType().getName();
					String fieldValue = null;
					if (returnType.equals("java.lang.String")) {
						fieldValue = (String) m.invoke(obj, null);
					} else if (returnType.equals("java.util.Date")) {
						Date adate = (Date) m.invoke(obj, null);
						if (adate == null) {
							fieldValue = "";
						} else {
							fieldValue = formateDate(adate);
						}
					} else if (returnType.equals("java.lang.Integer")) {
						Integer avalue = (Integer) m.invoke(obj, null);
						avalue = avalue == null ? 0 : avalue;
						fieldValue = avalue.toString();
					} else if (returnType.equals("java.lang.Double")) {
						Double dvalue = (Double) m.invoke(obj, null);
						dvalue = dvalue == null ? 0 : dvalue;
						fieldValue = dvalue.toString();
					}
					fieldValue = fieldValue == null ? "" : fieldValue;
					fieldValue = fieldValue.replaceAll("<", "&lt;");
					fieldValue = fieldValue.replaceAll(">", "&gt;");
					// 签名图片
					if (fieldName.indexOf("_sign") > -1) {
						sb.append("<data name=\"" + fieldName + "\" type=\"image\">");
						String path = request.getContextPath();
						String basePath = request.getScheme() + "://" + request.getServerName() + ":"
								+ request.getServerPort() + path + "/";
						sb.append(basePath + "GetSignServlet?signid=" + fieldValue);
						sb.append("</data>");
					} else {
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		sb.append("</datas>");
		return sb.toString();
	}

    public static Document getDataXMLDoc(Object obj) {
        Document doc = DocumentHelper.createDocument();
        Element datas = doc.addElement("datas");

        if (obj != null) {
            Field[] fds;
            try {
                fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                for (int i = 0; i < fds.length; i++) {
                    String fieldName = fds[i].getName();
                    if (fieldName.equals("serialVersionUID")) {
                        continue;
                    }
                    String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1)
                            .toUpperCase());
                    Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                    String returnType = m.getReturnType().getName();
                    String fieldValue = null;
                    if (returnType.equals("java.lang.String")) {
                        fieldValue = (String) m.invoke(obj, null);
                    } else if (returnType.equals("java.util.Date")) {
                        Date adate = (Date) m.invoke(obj, null);
                        if (adate == null) {
                            fieldValue = "";
                        } else {
                            fieldValue = formateDate(adate);
                        }
                    } else if (returnType.equals("java.lang.Integer")) {
                        Integer avalue = (Integer) m.invoke(obj, null);
                        avalue = avalue == null ? 0 : avalue;
                        fieldValue = avalue.toString();
                    } else if (returnType.equals("java.lang.Double")) {
                        Double dvalue = (Double) m.invoke(obj, null);
                        dvalue = dvalue == null ? 0 : dvalue;
                        fieldValue = dvalue.toString();
                    }
                    fieldValue = fieldValue == null ? "" : fieldValue;
                    // 签名图片
                    if (fieldName.indexOf("_sign") > -1) {
                        Element data = datas.addElement("data");
                        data.addAttribute("name",fieldName) ;
                        data.addAttribute("type","image");
                        data.setText("GetSignServlet?signid=" + fieldValue);
                    } else {
                        Element data = datas.addElement("data");
                        data.addAttribute("name",fieldName) ;
                        data.addAttribute("type","String(50)");
                        data.setText(fieldValue);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    /**
     * 用于打印组织数据xml数据源detail数据
     *
     * @param list
     * @param detailId
     * @return
     */
    public static Document getDetailXMLDoc(List list, String detailId) {

        Document doc = DocumentHelper.createDocument();
        Element detail = doc.addElement("detail") ;
        detail.addAttribute("ID", detailId);

        for (int j = 0; j < list.size(); j++) {
            int k = j;
            Element row =  detail.addElement("row");
            row.addAttribute("ID",String.valueOf(k)) ;

            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
                                1).toUpperCase());
                        Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;

                        Element data =  detail.addElement("data");
                        data.addAttribute("name",fieldName) ;
                        data.addAttribute("type","String(50)") ;
                        data.setText(fieldValue);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return doc;
    }

	/**
	 * 用于打印组织数据xml数据源detail数据
	 * 
	 * @param list
	 * @param detailId
	 * @return
	 */
	public static String getDetailXML(List list, String detailId) {
		StringBuffer sb = new StringBuffer();
		sb.append("<detail ID=\"");
		sb.append(detailId);
		sb.append("\">");
		for (int j = 0; j < list.size(); j++) {
			int k = j;
			sb.append("<row ID=\"" + k + "\">");
			Object obj = list.get(j);

			if (obj != null) {
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						if (fieldName.equals("serialVersionUID")) {
							continue;
						}
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
								1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue = null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if (adate == null) {
								fieldValue = "";
							} else {
								fieldValue = formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue = avalue == null ? 0 : avalue;
							fieldValue = avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue = dvalue == null ? 0 : dvalue;
							fieldValue = dvalue.toString();
						}

						fieldValue = fieldValue == null ? "" : fieldValue;
						fieldValue = fieldValue.replaceAll("<", "&lt;");
						fieldValue = fieldValue.replaceAll(">", "&gt;");
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			sb.append("</row>");
		}
		sb.append("</detail>");
		return sb.toString();
	}

	/**
	 * 用于打印组织数据xml数据源detail数据
	 * 
	 * @param list
	 * @param detailId
	 * @param vo
	 * @return
	 */
	public static String getDetailXML(List list, String detailId, Object vo) {
		StringBuffer sb = new StringBuffer();
		sb.append("<datas></datas>");
		sb.append("<detail ID='");
		sb.append(detailId);
		sb.append("'>");
		for (int j = 0; j < list.size(); j++) {
			int k = j;
			sb.append("<row ID=\"" + k + "\">");
			Object obj = list.get(j);

			if (obj != null) {
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						if (fieldName.equals("serialVersionUID")) {
							continue;
						}
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
								1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue = null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if (adate == null) {
								fieldValue = "";
							} else {
								fieldValue = formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue = avalue == null ? 0 : avalue;
							fieldValue = avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue = dvalue == null ? 0 : dvalue;
							fieldValue = dvalue.toString();
						}

						fieldValue = fieldValue == null ? "" : fieldValue;

						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
					// vo
					if (vo != null) {
						Field[] fds_vo;
						try {
							fds_vo = Class.forName(vo.getClass().getName()).getDeclaredFields();
							for (int i = 0; i < fds_vo.length; i++) {
								String fieldName = fds_vo[i].getName();
								if (fieldName.equals("serialVersionUID")) {
									continue;
								}
								String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName
										.substring(0, 1).toUpperCase());
								Method m = vo.getClass().getMethod("get" + tempFieldName, null);
								String returnType = m.getReturnType().getName();
								String fieldValue = null;
								if (returnType.equals("java.lang.String")) {
									fieldValue = (String) m.invoke(vo, null);
								} else if (returnType.equals("java.util.Date")) {
									Date adate = (Date) m.invoke(vo, null);
									if (adate == null) {
										fieldValue = "";
									} else {
										fieldValue = formateDate(adate);
									}
								} else if (returnType.equals("java.lang.Integer")) {
									Integer avalue = (Integer) m.invoke(vo, null);
									avalue = avalue == null ? 0 : avalue;
									fieldValue = avalue.toString();
								} else if (returnType.equals("java.lang.Double")) {
									Double dvalue = (Double) m.invoke(vo, null);
									dvalue = dvalue == null ? 0 : dvalue;
									fieldValue = dvalue.toString();
								}
								fieldValue = fieldValue == null ? "" : fieldValue;
								fieldName = "add" + fieldName;
								sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
								sb.append(fieldValue);
								sb.append("</data>");
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
					}

				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			sb.append("</row>");
		}
		sb.append("</detail>");
		return sb.toString();
	}
    /**
     * 用于打印组织数据xml数据源detail数据
     *
     * @param list
     * @param detailId
     * @param vo
     * @return
     */
    public static String getDetailXML1(List list, String detailId, List voo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<datas></datas>");
        sb.append("<detail ID='");
        sb.append(detailId);
        sb.append("'>");
        for (int j = 0; j < list.size(); j++) {
            int k = j;
            sb.append("<row ID=\"" + k + "\">");
            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
                                1).toUpperCase());
                        Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;

                        sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
                        sb.append(fieldValue);
                        sb.append("</data>");
                    }
                    // vo
                    Object vo = voo.get(j);
                    if (vo != null) {
                        Field[] fds_vo;
                        try {
                            fds_vo = Class.forName(vo.getClass().getName()).getDeclaredFields();
                            for (int i = 0; i < fds_vo.length; i++) {
                                String fieldName = fds_vo[i].getName();
                                if (fieldName.equals("serialVersionUID")) {
                                    continue;
                                }
                                String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName
                                        .substring(0, 1).toUpperCase());
                                Method m = vo.getClass().getMethod("get" + tempFieldName, null);
                                String returnType = m.getReturnType().getName();
                                String fieldValue = null;
                                if (returnType.equals("java.lang.String")) {
                                    fieldValue = (String) m.invoke(vo, null);
                                } else if (returnType.equals("java.util.Date")) {
                                    Date adate = (Date) m.invoke(vo, null);
                                    if (adate == null) {
                                        fieldValue = "";
                                    } else {
                                        fieldValue = formateDate(adate);
                                    }
                                } else if (returnType.equals("java.lang.Integer")) {
                                    Integer avalue = (Integer) m.invoke(vo, null);
                                    avalue = avalue == null ? 0 : avalue;
                                    fieldValue = avalue.toString();
                                } else if (returnType.equals("java.lang.Double")) {
                                    Double dvalue = (Double) m.invoke(vo, null);
                                    dvalue = dvalue == null ? 0 : dvalue;
                                    fieldValue = dvalue.toString();
                                }
                                fieldValue = fieldValue == null ? "" : fieldValue;
                                fieldName = "add" + fieldName;
                                sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
                                sb.append(fieldValue);
                                sb.append("</data>");
                            }
                        } catch (SecurityException e) {
                            e.printStackTrace();
                        } catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        } catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        } catch (IllegalAccessException e) {
                            e.printStackTrace();
                        } catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        } catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }

                } catch (SecurityException e) {
                    e.printStackTrace();
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            sb.append("</row>");
        }
        sb.append("</detail>");
        return sb.toString();
    }
     /*
     用于获取单独打印登记卡续表的数据源xml
      */
    public static String getDjkXBDetailXML(List list, String detailId){
        StringBuffer sb = new StringBuffer();
        sb.append("<datas></datas>");
        sb.append("<detail ID='");
        sb.append(detailId);
        sb.append("'>");
        for (int j = 0; j < list.size(); j++) {
            int k = j;
            sb.append("<row ID=\"" + k + "\">");
            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID") || fieldName.equals("tdzh") || fieldName.equals("ghkh") || fieldName.equals("islogout") || fieldName.equals("djkbh")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
                                1).toUpperCase());
                        Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;
                        fieldValue = fieldValue.replaceAll("<", "&lt;");
                        fieldValue = fieldValue.replaceAll(">", "&gt;");
                        sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
                        sb.append(fieldValue);
                        sb.append("</data>");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sb.append("</row>");
        }
        sb.append("</detail>");
        return sb.toString();
    }
    /**
     * 用于打印组织数据登记卡续表xml数据源detail数据
     * 去除续表中与主卡同名的字段
     * @param list
     * @param detailId
     * @return
     */
	public static String getDjkxbDetailXML(List list, String detailId) {
		StringBuffer sb = new StringBuffer();
		sb.append("<detail ID='");
		sb.append(detailId);
		sb.append("'>");
		for (int j = 0; j < list.size(); j++) {
			int k = j;
			sb.append("<row ID=\"" + k + "\">");
			Object obj = list.get(j);

			if (obj != null) {
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						if (fieldName.equals("serialVersionUID") || fieldName.equals("tdzh") || fieldName.equals("ghkh") || fieldName.equals("islogout") || fieldName.equals("djkbh")) {
							continue;
						}
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
								1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue = null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if (adate == null) {
								fieldValue = "";
							} else {
								fieldValue = formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue = avalue == null ? 0 : avalue;
							fieldValue = avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue = dvalue == null ? 0 : dvalue;
							fieldValue = dvalue.toString();
						}

						fieldValue = fieldValue == null ? "" : fieldValue;
						fieldValue = fieldValue.replaceAll("<", "&lt;");
						fieldValue = fieldValue.replaceAll(">", "&gt;");
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			sb.append("</row>");
		}
		sb.append("</detail>");
		return sb.toString();
	}

    /**
     * 用于打印组织数据登记卡续表xml数据源detail数据
     * 去除续表中与主卡同名的字段
     * @param list
     * @param detailId
     * @return
     */
    public static Document getDjkxbDetailXMLDoc(List list, String detailId) {
        Document doc = DocumentHelper.createDocument();
        Element detail = doc.addElement("detail");
        detail.addAttribute("ID",detailId);

        for (int j = 0; j < list.size(); j++) {
            int k = j;

            Element row = detail.addElement("row");
            row.addAttribute("ID",String.valueOf(k));

            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID") || fieldName.equals("tdzh") || fieldName.equals("ghkh") || fieldName.equals("islogout") || fieldName.equals("djkbh")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0,
                                1).toUpperCase());
                        Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;
                        Element data = row.addElement("data");
                        data.addAttribute("name",fieldName);
                        data.addAttribute("type","String(50)");
                        data.addText(fieldValue);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return doc;
    }

	/**
	 * 用于分割证打印组织数据

	 * 
	 * @param obj
	 * @param dataXML
	 * @return
	 */
	public static String addDataXML(Object obj, String dataXML) {
		String addDataXML = dataXML.replaceFirst("<datas>", "");
		addDataXML = addDataXML.replaceFirst("</datas>", "");
		StringBuffer sb = new StringBuffer(addDataXML);
		if (obj != null) {
			Field[] fds;
			try {
				fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
				for (int i = 0; i < fds.length; i++) {
					String fieldName = fds[i].getName();
					if (fieldName.equals("serialVersionUID")) {
						continue;
					}
					String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1)
							.toUpperCase());
					Method m = obj.getClass().getMethod("get" + tempFieldName, null);
					String returnType = m.getReturnType().getName();
					String fieldValue = null;
					if (returnType.equals("java.lang.String")) {
						fieldValue = (String) m.invoke(obj, null);
					} else if (returnType.equals("java.util.Date")) {
						Date adate = (Date) m.invoke(obj, null);
						if (adate == null) {
							fieldValue = "";
						} else {
							fieldValue = formateDate(adate);
						}
					} else if (returnType.equals("java.lang.Integer")) {
						Integer avalue = (Integer) m.invoke(obj, null);
						avalue = avalue == null ? 0 : avalue;
						fieldValue = avalue.toString();
					} else if (returnType.equals("java.lang.Double")) {
						Double dvalue = (Double) m.invoke(obj, null);
						dvalue = dvalue == null ? 0 : dvalue;
						fieldValue = dvalue.toString();
					}
					fieldValue = fieldValue == null ? "" : fieldValue;
					fieldName = "add" + fieldName;
					sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
					sb.append(fieldValue);
					sb.append("</data>");
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			sb.append("<data name=\"addztdzh\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addzl\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addth\" type=\"String(50)\"></data>");
			sb.append("<data name=\"adddjh\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addsyqlx\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addyt\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addzdmj\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addzzrq\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addfddbr\" type=\"String(50)\"></data>");
			sb.append("<data name=\"adddwxz\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addtxdz\" type=\"String(50)\"></data>");
			sb.append("<data name=\"addlxdh\" type=\"String(50)\"></data>");

		}
		return ("<datas>" + sb + "</datas>").toString();
	}
    /**
     * 用于分割证打印组织数据

     *
     * @param obj
     * @param dataXML
     * @return
     */
    public static String addDataXML1(Object obj) {
        StringBuffer sb = new StringBuffer();
        if (obj != null) {
            Field[] fds;
            try {
                fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
                for (int i = 0; i < fds.length; i++) {
                    String fieldName = fds[i].getName();
                    if (fieldName.equals("serialVersionUID")) {
                        continue;
                    }
                    String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1)
                            .toUpperCase());
                    Method m = obj.getClass().getMethod("get" + tempFieldName, null);
                    String returnType = m.getReturnType().getName();
                    String fieldValue = null;
                    if (returnType.equals("java.lang.String")) {
                        fieldValue = (String) m.invoke(obj, null);
                    } else if (returnType.equals("java.util.Date")) {
                        Date adate = (Date) m.invoke(obj, null);
                        if (adate == null) {
                            fieldValue = "";
                        } else {
                            fieldValue = formateDate(adate);
                        }
                    } else if (returnType.equals("java.lang.Integer")) {
                        Integer avalue = (Integer) m.invoke(obj, null);
                        avalue = avalue == null ? 0 : avalue;
                        fieldValue = avalue.toString();
                    } else if (returnType.equals("java.lang.Double")) {
                        Double dvalue = (Double) m.invoke(obj, null);
                        dvalue = dvalue == null ? 0 : dvalue;
                        fieldValue = dvalue.toString();
                    }
                    fieldValue = fieldValue == null ? "" : fieldValue;
                    fieldName = "add" + fieldName;
                    sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
                    sb.append(fieldValue);
                    sb.append("</data>");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sb.append("<data name=\"addztdzh\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addzl\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addth\" type=\"String(50)\"></data>");
            sb.append("<data name=\"adddjh\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addsyqlx\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addyt\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addzdmj\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addzzrq\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addfddbr\" type=\"String(50)\"></data>");
            sb.append("<data name=\"adddwxz\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addtxdz\" type=\"String(50)\"></data>");
            sb.append("<data name=\"addlxdh\" type=\"String(50)\"></data>");

        }
        return ("<datas>" + sb + "</datas>").toString();
    }
	public static String getPfUserName(){
		BasicDataSource dataSource = (BasicDataSource)Container.getBean("globalDataSource");
		String pf_userName = dataSource.getUsername();
		return pf_userName;
	}
	/**
	 * 连接平台数据库

	 * @param sql
	 * @return 返回PreparedStatement 
	 */	 
	public static PreparedStatement getPfStatement(String sql){
		PreparedStatement statement = null;
		try {
			BasicDataSource dataSource = (BasicDataSource)Container.getBean("globalDataSource");
			statement=dataSource.getConnection().prepareStatement(sql);			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return statement;		
	}
	/**
	 * 用于将平方格式化保留一位小数

	 * 
	 * @author zx
	 * @param value 
	 * @return 按精度类型格式化
	 */
	public static String formatNumber(String value) {
		DecimalFormat df= new DecimalFormat("#0.0");
		if(value!=null && !value.equals("")){
			BigDecimal value1=new BigDecimal(value);
			value=df.format(value1);
			if(value.equals("0.0")){
				value=null;
			}
		}
		return value;
	}

	public static String getArchiveProjectId(String xml){
		Common c=new Common();
		String archiveProjectId=null;
		try {
			if(xml!=null && !xml.equals("")){
				archiveProjectId=c.getArchiveProjectId(xml);
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}		
		return archiveProjectId;
	}
	public static String getArchiveMsg(String xml){
		Common c=new Common();
		String msg=null;
		try {
			if(xml!=null && !xml.equals("")){
				StringReader read = new StringReader(xml);
		        //创建新的输入源SAX 解析器将使用 InputSource 对象来确定如何读取 XML 输入
		        InputSource source = new InputSource(read);
		        //创建一个新的SAXBuilder
		        SAXBuilder sb = new SAXBuilder();		        
				org.jdom.Document doc = sb.build(source);
	        	org.jdom.Element root = doc.getRootElement();
	        	org.jdom.Element result = root.getChild("archive");
	        	if(result.getAttributeValue("msg")!=null ){	        		
	        		msg=result.getAttributeValue("msg");
	        	}
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}		
		return msg;
	}

    /**
     * 保存删除的tdzh防止证书跳号
     * @param projectId
     * @param spbService
     */
    public static void saveDelTdzh(String projectId) {
        //保存tdzh到 Tbl_deltdzh表 防止跳号
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectId);
        IBHService bhService = (IBHService) Container.getBean("bhService");
        DelTdzh delTdzh = new DelTdzh();
        String zstype = "";
        if(spb!=null){
            if (StringUtils.isNotBlank(spb.getTdzh())) {
                if (spb.getTdzh().indexOf("国用") > -1) {
                    zstype = "gytdsyz";
                } else if (spb.getTdzh().indexOf("集用") > -1) {
                    zstype = "jttdsyz";
                } else if (spb.getTdzh().indexOf("集有") > -1) {
                    zstype = "jttdsuz";
                } else if (spb.getTdzh().indexOf("他项") > -1) {
                    zstype = "txqlzms";
                }
                if(!zstype.equals("")){
                    delTdzh.setProjectId(spb.getProjectId());
                    delTdzh.setZstype(zstype);
                    delTdzh.setDwdm(spb.getDwdm());
                    delTdzh.setTdzh(spb.getTdzh());
                    bhService.insertDelTdzh(delTdzh);
                }
            }
        }
    }

    //在批准节点转发进行自动签名等信息
    public static SPB checkSheetinfo(String projectType,String remark,SPB spb,String userid){
        try {
            Common common = new Common();
            Document document = common.getTddjXml();
            Element root = document.getRootElement();
            List list = root.selectNodes("//Config/djlx[@name='"+projectType+"']/node");
            if (list!=null){
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Element Activity = (Element) it.next();

                    if (StringUtils.equals(Activity.attributeValue("name"),remark)){
                        List nodes = Activity.selectNodes("user");
                        for(int i=0;i<nodes.size();i++){
                            Element pz = (Element) nodes.get(i);
                            // Element root0 =(Element)pz.selectSingleNode("userDWDM");
                            if(userid.equals(pz.attributeValue("userId"))){
//                        	   Element root1 =(Element)pz.selectSingleNode("userSignId");
//                        	   String attr1=root1.attributeValue("fieldName");
//                               Method method=spb.getClass().getDeclaredMethod(attr1, String.class);
                                //method.invoke(obj, args)
                                Element root1 =(Element)pz.selectSingleNode("userSignId");
                                if(root1!=null){
                                    String attr1=root1.attributeValue("fieldName");
                                    Field f1 = SPB.class.getDeclaredField(attr1);
                                    f1.setAccessible(true);
                                    f1.set(spb, root1.getTextTrim());
                                }


                                Element root2 =(Element)pz.selectSingleNode("userSignName");
                                if(root2!=null){
                                    String attr2=root2.attributeValue("fieldName");
                                    Field f2 = SPB.class.getDeclaredField(attr2);
                                    f2.setAccessible(true);
                                    f2.set(spb, root2.getTextTrim());
                                }


                                Element root3 =(Element)pz.selectSingleNode("userYJ");
                                if(root3!=null){
                                    String attr3=root3.attributeValue("fieldName");
                                    Field f3 = SPB.class.getDeclaredField(attr3);
                                    f3.setAccessible(true);
                                    f3.set(spb, root3.getTextTrim());
                                }

                                Element root4 =(Element)pz.selectSingleNode("userRQ");
                                if(root4!=null){
                                    String attr4=root4.attributeValue("fieldName");
                                    Field f4 = SPB.class.getDeclaredField(attr4);
                                    f4.setAccessible(true);
                                    f4.set(spb, getCurrDate());
                                }

                                Element root5 =(Element)pz.selectSingleNode("userZGZH");
                                if(root5!=null){
                                    String attr5=root5.attributeValue("fieldName");
                                    Field f5 = SPB.class.getDeclaredField(attr5);
                                    f5.setAccessible(true);
                                    f5.set(spb, root5.getTextTrim());
                                }
                            }
                        }

                    }
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return spb;
    }
}