package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IStatTDZService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.util.GetStatSQL;
import com.jsegov.tddj.vo.StatTDZ;
import com.jsegov.tddj.vo.StatTDZResult;

public class StatTDZChartXML extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor of the object.
	 */
	public StatTDZChartXML() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String zslx=request.getParameter("zslx");
		String ksrq=request.getParameter("ksrq");
		String jsrq=request.getParameter("jsrq");
		String tjnr=request.getParameter("tjnr");
		String spectype=request.getParameter("spectype");
		String chartType=request.getParameter("chartType");
	
		IStatTDZService statTDZService=(IStatTDZService)Container.getBean("statTdzService");
		//统计证书
		ArrayList<StatTDZResult> statList=new ArrayList<StatTDZResult>();
		StringBuffer sqlstr=new StringBuffer();
		sqlstr=GetStatSQL.getStatTDZSQLForChart(spectype, zslx, ksrq, jsrq);
		
//		System.out.println("===>"+sqlstr.toString());
		statList = statTDZService.getStatTDZ(sqlstr.toString());
		
		StringBuffer sb=new StringBuffer();
		if(tjnr==null || tjnr.equals("") || tjnr.equals("sl")){
			sb.append("<chart caption=\"");
			sb.append("证书数量");
			if(chartType==null || chartType.equals("") || chartType.equals("bar")){
				sb.append("统计柱状图\" ");
			}else{
				sb.append("统计饼状图\" ");
			}
			
		}else{
			sb.append("<chart caption=\"");
			sb.append("证书面积");
			if(chartType==null || chartType.equals("") || chartType.equals("bar")){
				sb.append("统计柱状图\" ");
			}else{
				sb.append("统计饼状图\" ");
			}
		}
		if(spectype!=null && spectype.equals("qsxz")){
			sb.append("xAxisName=\"权属性质\"");
		}else if(spectype!=null && spectype.equals("syqlx")){
			sb.append("xAxisName=\"使用权类型\"");
		}else if(spectype!=null && spectype.equals("yt")){
			sb.append("xAxisName=\"土地用途\"");
		}else if(spectype!=null && spectype.equals("djlx")){
			sb.append("xAxisName=\"登记类型\"");
		}else if(spectype!=null && spectype.equals("fzqy")){
			sb.append("xAxisName=\"发证区域\"");
		}else if(spectype!=null && spectype.equals("dwxz")){
			sb.append("xAxisName=\"单位性质\"");
		}else if(spectype!=null && spectype.equals("zslx")){
			sb.append("xAxisName=\"证书类型\"");
		}
		if(chartType==null || chartType.equals("") || chartType.equals("bar")){
			sb.append(" outCnvBaseFontSize=\"14\" formatNumberScale=\"0\" ");
			if(tjnr==null || tjnr.equals("") || tjnr.equals("sl")){
				sb.append("yAxisName=\"数量:个\" decimalPrecision=\"2\" >");
			}else{
				sb.append("yAxisName=\"面积:平方米\"");
				sb.append(" forceDecimals=\"1\"  decimals=\"1\" >");
			}
		}else{
			if(tjnr==null || tjnr.equals("") || tjnr.equals("sl")){
				sb.append(" baseFontSize=\"12\" formatNumberScale=\"0\" yAxisName=\"数量:个\"");
				sb.append("  decimals=\"0\"");
			}else{
				sb.append(" baseFontSize=\"12\" formatNumberScale=\"0\" \"");
				sb.append("yAxisName=\"面积:平方米\"");
				sb.append("  decimals=\"1\"");
				
			}
			sb.append("  showPercentageInLabel=\"1\" enableSmartLabels=\"1\" enableRotation=\"0\" " +
					"bgColor=\"99CCFF,FFFFFF\" bgAlpha=\"40,100\" bgRatio=\"0,100\" bgAngle=\"360\" " +
					"showBorder=\"0\" startingAngle=\"70\" forceDecimals=\"1\" chartRightMargin=\"60\">");
		}
		
		for(int i=0;i<statList.size();i++){
			sb.append("<set label=\"");
			sb.append(statList.get(i).getDwmc());
			sb.append("\" value=\"");
			if(tjnr==null || tjnr.equals("") || tjnr.equals("sl")){
				sb.append(statList.get(i).getZj());
			}else{
				sb.append(statList.get(i).getMj());
			}
			if(i==1){
				if(chartType==null || chartType.equals("") || chartType.equals("bar")){
					sb.append("\" />");
				}else{
					sb.append("\"  isSliced=\"1\"/>");
				}
			}else{
				sb.append("\" />");
			}
		}
		if(chartType==null || chartType.equals("") || chartType.equals("line")){
			sb.append("<styles><definition><style name=\"Anim1\" type=\"animation\" param=\"_xscale\" start=\"0\" duration=\"1\" />");
			sb.append("<style name=\"Anim2\" type=\"animation\" param=\"_alpha\" start=\"0\" duration=\"0.6\" />");
			sb.append("<style name=\"DataShadow\" type=\"Shadow\" alpha=\"40\"/>");	
			sb.append("<style name=\"myCaptionFont\" type=\"font\" font=\"Arial\" size=\"20\" color=\"666666\" bold=\"1\" />");
			sb.append("</definition><application><apply toObject=\"DIVLINES\" styles=\"Anim1\" />");
			sb.append("<apply toObject=\"HGRID\" styles=\"Anim2\" />");
			sb.append("<apply toObject=\"DATALABELS\" styles=\"DataShadow,Anim2\" />");
			sb.append("<apply toObject=\"Caption\" styles=\"myCaptionFont\" />");
			sb.append("</application></styles>");
			sb.append("</chart>");
		}else{
			sb.append("<styles><definition><style name=\"myCaptionFont\" type=\"font\" font=\"Arial\" size=\"17\" color=\"666666\" bold=\"1\" />" );
			sb.append("</definition><application><apply toObject=\"Caption\" styles=\"myCaptionFont\" /></application></styles></chart>");
		}
		//System.out.println("sb===="+ sb);
		response.setContentType("text/xml;charset=UTF-8");
		response.getOutputStream().write(sb.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}
	
	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request,response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
