package com.jsegov.tddj.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.TXQLZMS;

public class SignPrinted extends HttpServlet {

    /**
     *
     */
    private static final long serialVersionUID = -89412748817405229L;

    /**
     * Constructor of the object.
     */
    public SignPrinted() {
        super();
    }

    /**
     * Destruction of the servlet. <br>
     */
    public void destroy() {
        super.destroy(); // Just puts "destroy" string in log
        // Put your code here
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     *
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws java.io.IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String zslx=request.getParameter("zslx");
        String projectId = request.getParameter("projectId");
        if(zslx!=null && zslx.equals("gytdsyz")){
            IGytdsyzService gytdsyzService=(IGytdsyzService)Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZ(projectId);
            gytdsyz.setIsprinted(1);
            gytdsyzService.updateGYTDSYZ(gytdsyz);
        }
        else if(zslx!=null && zslx.equals("jttdsyz")){
            IJttdsyzService jttdsyzService=(IJttdsyzService)Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
            jttdsyz.setIsprinted(1);
            jttdsyzService.updateJTTDSYZ(jttdsyz);
        }
        else if(zslx!=null && zslx.equals("txqlzms")){
            ITxqlzmsService txqlzmsService=(ITxqlzmsService)Container.getBean("txqlzmsService");
            TXQLZMS txqlzms= txqlzmsService.getTXQLZMS(projectId);
            txqlzms.setIsprinted(1);
            txqlzmsService.updateTXQLZMS(txqlzms);
        }

        //System.out.println("projectId="+projectId);
        String returnMessage = "OK";

        //System.out.println(returnMessage);
        response.setContentType("text/xml;charset=GBK");
        response.getOutputStream().write(returnMessage.toString().getBytes());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     *
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws java.io.IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        doGet(request,response);
    }

    /**
     * Initialization of the servlet. <br>
     *
     * @throws ServletException if an error occurs
     */
    public void init() throws ServletException {
        // Put your code here
    }

}
