package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.util.DataSourceManager;

public class SetUpQSBNum extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8440439656821849925L;

	/**
	 * Constructor of the object.
	 */
	public SetUpQSBNum() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	public String setupCSZ(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException{
		String qsbNum = "";
		String returnValue = "";
		if (request.getParameter("qsbNum") != null)
			qsbNum = new String(request.getParameter("qsbNum").getBytes("ISO8859_1"), "GBK");
		
		Connection conn = null;
		Statement st = null;
		String dropSequence = "drop sequence SQ_ZSXL";
		String createSequence = "create sequence SQ_ZSXL minvalue 1 maxvalue 9999999999 start with "+qsbNum+" increment by 1 cache 20";
		
		try {
			conn = DataSourceManager.getDataSource("tddj").getConnection();
			st = conn.createStatement();
		} catch (SQLException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		try {
			st.execute(dropSequence);
		} catch (SQLException e1) {
			// TODO Auto-generated catch block
			//e1.printStackTrace();
		}
		
		try{
			st.execute(createSequence);
			st.close();
			returnValue = "初始化成功！";
		}catch (SQLException e){
			returnValue = "初始化失败："+e.getMessage();
			e.printStackTrace();
		}finally{
			try{
				st.close();
				conn.close();
			}catch (SQLException e){
				returnValue = "初始化失败："+e.getMessage();
				e.printStackTrace();
			}
		}
		return returnValue;
	}
	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(setupCSZ(request,response).toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(setupCSZ(request,response).toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
