package com.jsegov.tddj.servlet;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: chengli
 * Date: 13-8-13
 * Time: 下午4:02
 * To change this template use File | Settings | File Templates.
 */
public class ReadSqbToSpb extends HttpServlet {
    /**
     *
     */
    private static final long serialVersionUID = -8716541825522866103L;


    /**
     * Destruction of the servlet. <br>
     */
    public void destroy() {
        super.destroy(); // Just puts "destroy" string in log
        // Put your code here
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws javax.servlet.ServletException
     *             if an error occurred
     * @throws java.io.IOException
     *             if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
              throws ServletException, IOException {
        try {
            String projectId = request.getParameter("proId");
            if (projectId!=null && !projectId.equals("")){
                ISPBService spbService = (ISPBService) Container.getBean("spbService");
                ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
                SQB sqb = sqbService.getSQB(projectId);
                SPB spb=spbService.getSPB(projectId);
                if(spb==null){
                    spb=new SPB();
                    spb= spbService.readSQB(spb,sqb);
                    spbService.insertSPB(spb);
                } else {
                    spb = spbService.readSQB(spb, sqb);
                    spbService.updateSPB(spb);
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }

    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to
     * post.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws javax.servlet.ServletException
     *             if an error occurred
     * @throws java.io.IOException
     *             if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
              throws ServletException, IOException {
        doGet(request, response);
    }

    /**
     * Initialization of the servlet. <br>
     *
     * @throws javax.servlet.ServletException
     *             if an error occurs
     */
    public void init() throws ServletException {
        // Put your code here
    }

}
