package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.XZQ;

public class PrintServlet extends HttpServlet {

    /**
     *
     */
    private static final long serialVersionUID = -3891155055402353040L;

    /**
     * Constructor of the object.
     */
    public PrintServlet() {
        super();
    }

    /**
     * Destruc tion of the servlet. <br>
     */
    public void destroy() {
        super.destroy(); // Just puts "destroy" string in log
        // Put your code here
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws ServletException
     *             if an error occurred
     * @throws java.io.IOException
     *             if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /**
         * (改动后请修改下列注释) 用途：打印服务程序 根据sheetName为打印控件组织xml数据源 参数：sheetName
         * 最后修改日期：2008-12-05 修改人：刘仲阳

         */
        String sheetName = request.getParameter("sheetName");
        String projectId = "";
        String gyq_tdzh = "";
        /**
         *  用途：证卡打印：分割证——批量打印  bug：批量打印的结果不是根据查询条件获取的结果，没有获取dwdm过滤
         *  修改说明:  参数：userDwdm  获取userDwdm传参到PrintFGZ.getAllFgz（）函数中，去数据库中读取dwdm
         * 最后修改日期：2010-07-22 修改人：陈典姣

         */
        String userDwdm = null;
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        if (request.getParameter("userDwdm") != null)
            userDwdm = new String(request.getParameter("userDwdm").getBytes("ISO8859_1"), "utf-8");
        map1.put("dwdm", userDwdm+"%");
        //System.out.println("dwdm=="+userDwdm);

        if (request.getParameter("projectId") != null) {
            projectId = request.getParameter("projectId");
            //System.out.print("projectId===="+projectId);
        } else if (request.getParameter("proid") != null) {
            projectId = request.getParameter("proid");
        }
        if (request.getParameter("tdzh") != null) {
            gyq_tdzh = request.getParameter("tdzh");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
        sb.append("<fetchdatas>");
        String resultXML = null;
        if (sheetName != null && sheetName.equals("sjd")) {
            resultXML = PrintSJD.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("sqb")) {
            resultXML = PrintSQB.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("spb")) {
            // resultXML=PrintJDSPB.getSpbXML(projectId, request, response);
            resultXML = PrintJDSPB.getPrintXML(projectId, request);
        } else if (sheetName != null && sheetName.equals("gytdsyz")) {
            resultXML = PrintGytdsyz.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("gytdsyz_dt")) {
            resultXML = PrintGytdsyz.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("jttdsyz")) {
            resultXML = PrintJttdsyz.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("jttdsyz_dt")) {
            resultXML = PrintJttdsyz.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("jttdsuz")) {
            resultXML = PrintJttdsuz.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("fm_dt")) {
            resultXML = PrintJDSPB.getFmPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("fm")) {
            resultXML = PrintJDSPB.getFmPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("txqlzms")) {
            resultXML = PrintTxqlzms.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("txqlzms_dt")) {
            resultXML = PrintTxqlzms.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("djk")) {
            // resultXML=PrintDJK.getPrintXML(projectId);
            resultXML = PrintDJK.getPrintXMLByDjh(projectId);
        } else if (sheetName != null && sheetName.equals("djkzk")) {
            resultXML = PrintDJK.getDjkZkXMLByDjh(projectId);
        } else if (sheetName != null && sheetName.equals("djkxb")) {
            resultXML = PrintDJK.getDjkxbXMLByDjh(projectId);
        } else if (sheetName != null && sheetName.equals("gyqdjkxb")) {
            resultXML = PrintDJK.getGyqDjkxbXML(projectId, gyq_tdzh);
        } else if (sheetName != null && sheetName.equals("jd_djk")) {
            resultXML = PrintDJK.getPrintXMLByDjh(projectId);
        } else if (sheetName != null && sheetName.equals("ghk")) {
            resultXML = PrintGHK.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("fgz")) {
            resultXML = PrintFGZ.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("jzs")) {
            resultXML = PrintJZS.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("ftmjb")) {
            resultXML = PrintFTMJB.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("djf")) {
            resultXML = PrintJDSPB.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("allfgz")) {
            resultXML = PrintFGZ.getAllFgz(projectId);
        } else if (sheetName != null && sheetName.equals("fgzpldy")) {
            String djh = "";
            if (request.getParameter("djh") != null) {
                djh = new String(request.getParameter("djh").getBytes("ISO8859_1"), "utf-8");
            }
            String qlr = "";
            if (request.getParameter("qlr") != null) {
                qlr = URLDecoder.decode(request.getParameter("qlr"),"UTF-8");
            }
            String zl = "";
            if (request.getParameter("zl") != null) {
                zl = URLDecoder.decode(request.getParameter("zl"),"UTF-8");
            }
            String tdzh = "";
            if (request.getParameter("tdzh") != null) {
                tdzh = URLDecoder.decode(request.getParameter("tdzh"),"UTF-8");
            }
//			String oldDjh="";
//			if(request.getParameter("oldDjh") != null){
//				oldDjh=new String(request.getParameter("oldDjh").getBytes("ISO8859_1"), "GBK");
//			}
            resultXML = PrintFGZ.getAllFgz(projectId, djh, qlr, zl, tdzh,userDwdm);
        } else if (sheetName != null && sheetName.equals("jdgyqdjk")) {
            resultXML = PrintJDGYQDJK.getPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("gyttddjkml")) {
            resultXML = PrintJDGYQDJK.getGyqPrintXML(projectId);
        } else if (sheetName != null && sheetName.equals("zsReport")) {
            String zslx = null;
            //String tdzh = null;
            //String djh = null;
            //String qlr = null;
            //String zl = null;
            //String syqlx = null;
            String fzrq1 = null;
            String fzrq2 = null;
            String tdzh1 = null;
            String tdzh2 = null;
            //String organ = null;
            //String zsno = null;

            // String queryZslx = null;
            //String queryTdzh = null;
            //String queryDjh = null;
            //String queryQlr = null;
            //String queryZl = null;
            //String querySyqlx = null;
            Date queryFzrq1 = null;
            Date queryFzrq2 = null;
            String queryTdzh1 = null;
            String queryTdzh2 = null;
            String queryTdzhYear = null;
            //String queryZsno = null;
            HashMap<String, Object> map = new HashMap<String, Object>();
            //map = CommonUtil.getDwdmQuery(request, map);
            map.put("dwdm", userDwdm+"%");
            // resultXML=PrintJDGYQDJK.getPrintXML(projectId);
            if (request.getParameter("zslx") != null)
                zslx = new String(request.getParameter("zslx").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("tdzh") != null)
            //	tdzh = new String(request.getParameter("tdzh").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("djh") != null)
            //	djh = new String(request.getParameter("djh").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("qlr") != null)
            //	qlr = new String(request.getParameter("qlr").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("zl") != null)
            //	zl = new String(request.getParameter("zl").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("syqlx") != null)
            //	syqlx = new String(request.getParameter("syqlx").getBytes("ISO8859_1"), "GBK");
            if (request.getParameter("fzrq1") != null)
                fzrq1 = new String(request.getParameter("fzrq1").getBytes("ISO8859_1"), "GBK");
            if (request.getParameter("fzrq2") != null)
                fzrq2 = new String(request.getParameter("fzrq2").getBytes("ISO8859_1"), "GBK");
            if (request.getParameter("tdzh1") != null)
                tdzh1 = java.net.URLDecoder.decode(request.getParameter("tdzh1"),"UTF-8");
            if (request.getParameter("tdzh2") != null)
                tdzh2 =java.net.URLDecoder.decode(request.getParameter("tdzh2"),"UTF-8");
            //if (request.getParameter("organ") != null)
            //	organ = new String(request.getParameter("organ").getBytes("ISO8859_1"), "GBK");
            //if (request.getParameter("zsno") != null)
            //	zsno = new String(request.getParameter("zsno").getBytes("ISO8859_1"), "GBK");

            //if (tdzh != null && !tdzh.equals("")) {
            //	queryTdzh = "%" + tdzh + "%";
            //}
            //if (djh != null && !djh.equals("")) {
            //	queryDjh = "%" + djh + "%";
            //}
            //if (qlr != null && !qlr.equals("")) {
            //	queryQlr = "%" + qlr + "%";
            //}
            //if (zl != null && !zl.equals("")) {
            //	queryZl = "%" + zl + "%";
            //}
            //if (syqlx != null && !syqlx.equals("")) {
            //	querySyqlx = "%" + syqlx + "%";
            //}
            if (fzrq1 != null && !fzrq1.equals("")) {
                queryFzrq1 = CommonUtil.formateDateToStr(fzrq1);
            }
            if (fzrq2 != null && !fzrq2.equals("")) {
                queryFzrq2 = CommonUtil.formateDateToStr(fzrq2);
            }
            XZQ xzq = CommonUtil.getXZQ();
            String xzqShortName = xzq.getXzqShortName();
            if (tdzh1 != null && !tdzh1.equals("")) {
                queryTdzh1 = tdzh1.replace("(", "");
                queryTdzh1 = queryTdzh1.replace(")", "");
                queryTdzh1 = queryTdzh1.replace("（", "");
                queryTdzh1 = queryTdzh1.replace("）", "");
                queryTdzh1 = queryTdzh1.replace(xzqShortName + "国用", "");
                queryTdzh1 = queryTdzh1.replace(xzqShortName + "集用", "");
                queryTdzh1 = queryTdzh1.replace(xzqShortName + "他项", "");
                queryTdzh1 = queryTdzh1.replace("第", "");
                queryTdzh1 = queryTdzh1.replace("号", "");
                queryTdzhYear = "(" + queryTdzh1.substring(0, 4) + ")";
                queryTdzh1 = queryTdzh1.substring(4, queryTdzh1.length());
                map.put("TdzhYear", "%" + queryTdzhYear + "%");
                map.put("queryTdzhYear", queryTdzhYear);
            }
            if (tdzh2 != null && !tdzh2.equals("")) {
                queryTdzh2 = tdzh2.replace("(", "");
                queryTdzh2 = queryTdzh2.replace(")", "");
                queryTdzh2 = queryTdzh2.replace("（", "");
                queryTdzh2 = queryTdzh2.replace("）", "");
                queryTdzh2 = queryTdzh2.replace(xzqShortName + "国用", "");
                queryTdzh2 = queryTdzh2.replace(xzqShortName + "集用", "");
                queryTdzh2 = queryTdzh2.replace(xzqShortName + "他项", "");
                queryTdzh2 = queryTdzh2.replace("第", "");
                queryTdzh2 = queryTdzh2.replace("号", "");
                if (tdzh1 == null || tdzh1.equals("")) {
                    queryTdzhYear = "(" + queryTdzh2.substring(0, 4) + ")";
                    map.put("TdzhYear", "%" + queryTdzhYear + "%");
                    map.put("queryTdzhYear", queryTdzhYear);
                }
                queryTdzh2 = queryTdzh2.substring(4, queryTdzh2.length());
            }
            //if (zsno != null && !zsno.equals("")) {
            //	queryZsno = "%" + zsno + "%";
            //}

            // map.put("tdzh", queryTdzh);
            // map.put("djh", queryDjh);
            // map.put("qlr", queryQlr);
            // map.put("zl", queryZl);
            // map.put("syqlx", querySyqlx);
            map.put("fzrq1", queryFzrq1);
            map.put("fzrq2", queryFzrq2);
            map.put("tdzh1", queryTdzh1);
            map.put("tdzh2", queryTdzh2);
            // map.put("organ", organ);
            // map.put("zsno", queryZsno);
            map.put("zsstate", "0");// 查找可用用的证书
            map.put("iscomplete", "1");// 查找项目已经完成的证书


            if (zslx.equals("gytdsyz")) {
                resultXML = PrintGytdsyz.getZsPrintXML(map);
            } else if (zslx.equals("jttdsyz")) {
                // IJttdsyzService jttdsyzService = (IJttdsyzService)
                // Container.getBean("jtTdsyzService");
                resultXML = PrintJttdsyz.getZsPrintXML(map);

            } else if (zslx.equals("txqlzms")) {
                // ITxqlzmsService txqlzmsService = (ITxqlzmsService)
                // Container.getBean("txqlzmsService");
                resultXML = PrintTxqlzms.getZsPrintXML(map);
            }
        } else if (sheetName != null && sheetName.equals("zsgs")) {
            resultXML = PrintZSGS.getPrintXML(projectId);
        }

        sb.append(resultXML);
        sb.append("</fetchdatas>");
        //System.out.println(sb.toString());
        response.setContentType("text/xml;charset=GBK");
        response.getOutputStream().write(sb.toString().getBytes());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to
     * post.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws ServletException
     *             if an error occurred
     * @throws java.io.IOException
     *             if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doGet(request, response);
    }

    /**
     * Initialization of the servlet. <br>
     *
     * @throws ServletException
     *             if an error occurs
     */
    public void init() throws ServletException {
        // Put your code here
    }
}
