package com.jsegov.tddj.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.util.DataSourceManager;
import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.PrintSPB;
import com.jsegov.tddj.vo.SPB;

public class PrintJDSPB {
	public static String getPrintXML(String projectId){
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		SPB spbVo=spbService.getSPB(projectId);
		String dataXML= CommonUtil.getDataXML(spbVo);
		return dataXML;
	}

	public static String getPrintXML(String projectId,HttpServletRequest request){
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		SPB spbVo=spbService.getSPB(projectId);
		String dataXML= CommonUtil.getDataXML(spbVo,request);
		return dataXML;
	}	
	
	public static String getSpbXML(String projectId,HttpServletRequest request, HttpServletResponse response){
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		SPB spbVo=spbService.getSPB(projectId);
		try {
			getPic(spbVo, request, response);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String dataXML= CommonUtil.getDataXML(spbVo);
		return dataXML;
	}
	
	public static String getFmPrintXML(String projectId){
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		PrintSPB spbVo=spbService.getPrintSPB(projectId);
		if (spbVo.getSqlx().equals("土地使用权抵押权初始登记") || spbVo.getSqlx().equals("他项权利证明书注销登记")){
			spbVo.setRf1_dwmc(spbVo.getRf2_dwmc());
		}
		String dataXML= CommonUtil.getDataXML(spbVo);
		//System.out.println(dataXML);
		return dataXML;
	}
	
	public static void getPic(SPB spbVo,HttpServletRequest request, HttpServletResponse response) throws SQLException, Exception{
		//签名图片
		if(spbVo!=null){
			Field[] fds;
			String sqlstr="select t.sign_pic from pf_usersign t where t.sign_id=?";
			Connection conn = DataSourceManager.getDataSource("globalDataSource").getConnection();
			PreparedStatement upps = conn.prepareStatement(sqlstr);
			InputStream in = null;
			ResultSet uprs = null;
			try {
				fds = Class.forName(spbVo.getClass().getName()).getDeclaredFields();
				String fieldName = "";
				String fieldValue = "";
				String tempFieldName = "";
				Method m = null;
				for (int i = 0; i < fds.length; i++) {
					fieldName = fds[i].getName();
					if (fieldName.indexOf("sign")>-1){
						tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1).toUpperCase());
						m = spbVo.getClass().getMethod("get" + tempFieldName, null);
						fieldValue = (String) m.invoke(spbVo, null);
						if (fieldValue!=null && !fieldValue.equals("")){
							upps.setString(1, fieldValue);
							uprs = upps.executeQuery();
							while(uprs.next()){
								if (uprs.getBlob("sign_pic")!=null){
									in=uprs.getBlob("sign_pic").getBinaryStream();
									creatPicFile(in, fieldName, request, response);
								}
							}		
							uprs.close();
						}
					}
				}
			}catch (Exception e) {
				// TODO: handle exception
			}finally{
				upps.close();
				conn.close();
			}
		}
	}
	
	public static void creatPicFile(InputStream in, String picName,HttpServletRequest request, HttpServletResponse response) throws IOException{

//		response.setContentType("application/jpg;charset=utf-8");
//		response.addHeader("Content-Disposition", "attachment; filename=test.jpg");
//		OutputStream outStream = response.getOutputStream();
//		byte[] bytes = new byte[1024];
//		int len = 0;
//		while ((len = in.read(bytes)) != -1){
//			outStream.write(bytes, 0, len);
//		}
//		in.close();
//		outStream.flush();
//		outStream.close();
		String filePath = "c:\\signtemp";
		delPicFile(filePath);
		File file = new File(filePath);
		file.mkdirs();
		String fileName = "c:\\signtemp\\"+picName+".jpg";
		FileOutputStream out = new FileOutputStream(fileName); 
		byte[] bytes = new byte[1024];
		int len = 0;
		while ((len = in.read(bytes)) != -1){
			out.write(bytes, 0, len);
		}
		in.close();
		out.flush();
		out.close();
	}
	
	public static void delPicFile(String fileName){
		File file = new File(fileName);
		if (file.exists()){
			file.delete();
		}
	}
	
//	public static void main(String args[]){
//		String filePath = "c:\\signtemp";
//		String fileName = "c:\\signtemp\\jbr.jpg";
//		File file = new File(filePath);
//		file.mkdirs();
//		File ofile = new File("c:\\signtemp\\jh.jpg");
//		FileInputStream in = null;
//		try {
//			in = new FileInputStream(ofile);
//		} catch (FileNotFoundException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}
//		FileOutputStream out = null;
//		try {
//			out = new FileOutputStream(fileName);
//			byte[] bytes = new byte[1024];
//			int len = 0;
//			while ((len = in.read(bytes)) != -1){
//				out.write(bytes, 0, len);
//			}
//			in.close();
//			out.flush();
//			out.close();
//		} catch (FileNotFoundException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}
}
