package com.jsegov.tddj.servlet;

import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.GYQDJK;
import org.apache.commons.lang.StringUtils;

public class PrintJDGYQDJK {
    public static String getPrintXML(String projectId){
        /**
         *  (改动后请修改下列注释)
         * 	用途：根据projectId获取djk数据 再根据djk对应的djh和tdzh获取djkxb 组织xml数据源

         * 	参数：projectId
         *  最后修改日期：2009-2-16
         *  修改人：刘仲阳

         */
        //IGYQDJKService gyqdjkService = (IGYQDJKService)Container.getBean("gyqDjkService");
        //GYQDJK gyqdjk = gyqdjkService.getGYQDJK(projectId);

        IDJKService djkService=(IDJKService)Container.getBean("djkService");
        DJK djkVo=djkService.getDJKByTdzh(projectId);
        //获得主表
        String dataXML= CommonUtil.getDataXML(djkVo);
        //System.out.println(dataXML);
        //获得续表 根据 djh 和 tdzh获得
        //Integer djkId=djkVo.getDjkId();

        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");

        String djh = djkVo.getDjh();
        String tdzh = djkVo.getTdzh();
        List djkxbList=djkxbService.getDJKXBList(djh, tdzh);

        String detailXML=CommonUtil.getDjkxbDetailXML(djkxbList,"DJKXB");

        //连接输出
        StringBuffer sb = new StringBuffer();
        sb.append(dataXML);
        sb.append(detailXML);
        return sb.toString();
        //return dataXML;
    }


    public static String getGyqPrintXML(String djh){
        IGYQDJKService gyqdjkService = (IGYQDJKService)Container.getBean("gyqDjkService");
        List<GYQDJK> gyqdjk = gyqdjkService.getGyqDjk(djh);
        StringBuffer sb = new StringBuffer();
        sb.append("<datas>");
            sb.append("<data name=\"DJH\" type=\"String(50)\">");
            if(gyqdjk!=null && gyqdjk.size()!=0){
                sb.append(gyqdjk.get(0).getDjh());
            }
            sb.append("</data>");
        sb.append("</datas>");
        //IDJKService djkService=(IDJKService)Container.getBean("djkService");
        //DJK djkVo=djkService.getDJKByTdzh(projectId);

       // String dataXML= CommonUtil.getDataXML(djkVo);
        //Integer djkId=djkVo.getDjkId();
        //System.out.println(dataXML);
        //IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        //List djkxbList=djkxbService.getDJKXBList(djkId);

        String detailXML=CommonUtil.getDetailXML(gyqdjk,"GYQDJKML");
        sb.append(detailXML);

        return sb.toString();
    }

}
