package com.jsegov.tddj.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDHDZBService;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.XZQ;

public class PrintFGZ {
	public static String getPrintXML(String projectId){
		IFGZService fgzService=(IFGZService)Container.getBean("fgzService");
		FGZ fgzVo = fgzService.getFGZById(projectId);
		String dataXML= CommonUtil.getDataXML(fgzVo);
		
		XZQ xzq = new XZQ();
		xzq = CommonUtil.getXZQ();
		String xzqName = "<data name=\"rmzf\" type=\"String(50)\">"+xzq.getXzqName()+"</data></datas>";
		dataXML = dataXML.replace("</datas>", xzqName);
		
		//System.out.println(dataXML);
		IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
		FGINFO fginfo = fginfoService.getFGINFO(fgzVo.getProjectId());
		if (fginfo == null ) {
			fginfo = new FGINFO();
		}
		dataXML= CommonUtil.addDataXML(fginfo, dataXML);
		return dataXML;
	}
	
	public static String getAllFgz(String projectId){
		IFGZService fgzService=(IFGZService)Container.getBean("fgzService");
		IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
		FGINFO fginfo = fginfoService.getFGINFO(projectId);
		//dataXML = CommonUtil.getDataXML(fginfo);
		List fgzList = fgzService.getFGZByProjectID(projectId);
		String dataXML = CommonUtil.getDetailXML(fgzList,"FGZ",fginfo);
		
		XZQ xzq = new XZQ();
		xzq = CommonUtil.getXZQ();
		String xzqName = "<data name=\"rmzf\" type=\"String(50)\">"+xzq.getXzqName()+"</data></row>";
		dataXML = dataXML.replaceAll("</row>", xzqName);
		
		return dataXML;
	}
	
	public static String getAllFgz(String projectId,String djh,String qlr,String zl,String tdzh,String userDwdm){
//		String userDwdm = null;
//		HashMap<String, Object> map1 = new HashMap<String, Object>();
//		if (request.getParameter("userDwdm") != null)
//			userDwdm = new String(request.getParameter("userDwdm").getBytes("ISO8859_1"), "utf-8");
//		map.put("dwdm", userDwdm+"%");
//		System.out.println("dwdm=="+userDwdm);

		IFGZService fgzService=(IFGZService)Container.getBean("fgzService");
		IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
		String thisprojectId = "";
		//dataXML = CommonUtil.getDataXML(fginfo);
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("dwdm", userDwdm+"%");
		//System.out.println("dwdm=="+userDwdm);
		if (djh!=null && !djh.equals("")) map.put("djh", "%"+djh+"%");
		if (qlr!=null && !qlr.equals("")) map.put("qlr", "%"+qlr+"%");
		if (zl!=null && !zl.equals("")) map.put("zl", "%"+zl+"%");
		if (tdzh!=null && !tdzh.equals("")) map.put("fgzh", "%"+tdzh+"%");
//		IDHDZBService dhdzbService = (IDHDZBService)Container.getBean("dhDzbService");
//		map=dhdzbService.putNewDjhToMap(map, oldDjh, "Tbl_FGZ");
		//System.out.println(map);
		List fgzList = fgzService.getFGZ(map);
        List fgzinfoList = new ArrayList<FGINFO>();
        if (fgzList.size()>0){
            for(int i=0; i<fgzList.size(); i++){
                FGZ fgz = (FGZ)fgzList.get(i);
                thisprojectId = fgz.getProjectId();
                fgzinfoList.add(fginfoService.getFGINFO(thisprojectId));
            }
        }
		String dataXML = CommonUtil.getDetailXML1(fgzList,"FGZ",fgzinfoList);

		XZQ xzq = new XZQ();
		xzq = CommonUtil.getXZQ();
		String xzqName = "<data name=\"rmzf\" type=\"String(50)\">"+xzq.getXzqName()+"</data></row>";
		dataXML = dataXML.replaceAll("</row>", xzqName);

		return dataXML;
	}
}
