package com.jsegov.tddj.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

import com.gtis.config.AppConfig;
import com.gtis.spring.Container;
import com.jsegov.tddj.services.ZdDjdcbService;
import com.jsegov.tddj.services.interf.IZD_DJDCBService;
import com.jsegov.tddj.vo.ZD_DJDCB;
import com.lowagie.text.Document;

public class GetZDTSMJServlet extends HttpServlet {

    /**
     * Constructor of the object.
     */
    public GetZDTSMJServlet() {
        super();
    }

    /**
     * Destruction of the servlet. <br>
     */
    public void destroy() {
        super.destroy(); // Just puts "destroy" string in log
        // Put your code here
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws ServletException
     *             if an error occurred
     * @throws IOException
     *             if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doPost(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to
     * post.
     *
     * @param request
     *            the request send by the client to the server
     * @param response
     *            the response send by the server to the client
     * @throws ServletException
     *             if an error occurred
     * @throws IOException
     *             if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        String djh = request.getParameter("djh");
        String path = AppConfig.getProperty("zdtDownload.path");
        HashMap<String,Object> map = new HashMap<String, Object>();
        map.put("djh",djh);
        IZD_DJDCBService zd_djdcbService =(IZD_DJDCBService)Container.getBean("zdDjdcbService");
        ZD_DJDCB zd_djdcb = zd_djdcbService.getZDTSMJByDjh(map);
        if(zd_djdcb!=null){
            if(StringUtils.isNotBlank(zd_djdcb.getZdsmj())){
                System.out.println("filePath:" + path+zd_djdcb.getZdsmj());
                String filePath = path+zd_djdcb.getZdsmj();
                byte[] buffer = new byte[1024];
                String strZipName = "ZDTSMJtemp.zip";
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream("D:\\ZDTSMJtemp.zip"));
                out.setEncoding("GBK");
                File file = new File(filePath);
                if (file.isDirectory()) {
                    String[] filelist = file.list();
                    for (int i = 0; i < filelist.length; i++) {
                        File readfile = new File(filePath + "\\" + filelist[i]);
                        if (!readfile.isDirectory()) {
                            FileInputStream fis = new FileInputStream(readfile.getPath());
                            out.putNextEntry(new ZipEntry(readfile.getName()));
                            int len;
                            // 读入需要下载的文件的内容，打包到zip文件
                            while((len = fis.read(buffer))>0) {
                                out.write(buffer,0,len);
                            }
                            out.closeEntry();
                            fis.close();
                        }
                    }
                    out.close();
                }
                File file1 = new File("d:\\ZDTSMJtemp.zip");
                downloadZip(file1,response);
            }
        }
    }

    /**
     * Initialization of the servlet. <br>
     *
     * @throws ServletException
     *             if an error occurs
     */
    public void init() throws ServletException {
        // Put your code here
    }

    /**
     * 下载打包的文件
     *
     * @param file
     * @param response
     */
    public void downloadZip(File file, HttpServletResponse response) {
        try {
            // 以流的形式下载文件。
            BufferedInputStream fis = new BufferedInputStream(
                    new FileInputStream(file.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            OutputStream toClient = new BufferedOutputStream(response
                    .getOutputStream());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename="
                    + file.getName());
            toClient.write(buffer);
            toClient.flush();
            toClient.close();
            file.delete(); // 将生成的服务器端文件删除
        } catch (IOException ex) {
            ex.printStackTrace();

        }
    }
}
