package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.util.DataSourceManager;

public class GetSignServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7948074912865194691L;

	/**
	 * Constructor of the object.
	 */
	public GetSignServlet() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String signId = request.getParameter("signid");
		// System.out.println("+++++++==="+modalName);
		if (!signId.equals("")) {
			String sqlstr_pic = "select t.sign_pic from pf_usersign t where t.sign_id=?";
			String sqlstr_id = "select t.user_sign from pf_usersign a, pf_user t where a.user_id=t.user_id and a.sign_id=?";

			Connection conn = null;
			InputStream in = null;
			try {
				conn = DataSourceManager.getDataSource("globalDataSource").getConnection();
				// 增加数据
				PreparedStatement upps = conn.prepareStatement(sqlstr_id);
				upps.setString(1, signId);
				ResultSet uprs = upps.executeQuery();
				while (uprs.next()) {
					if (uprs.getBlob("user_sign") != null)
						in = uprs.getBlob("user_sign").getBinaryStream();
				}
				// System.out.println(in == null);
				if (in == null) {
					upps = conn.prepareStatement(sqlstr_pic);
					upps.setString(1, signId);
					uprs = upps.executeQuery();
					while (uprs.next()) {
						if (uprs.getBlob("sign_pic") != null)
							in = uprs.getBlob("sign_pic").getBinaryStream();
					}
				}
				uprs.close();
				upps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (Exception e) {
				// TODO 自动生成 catch 块

				e.printStackTrace();
			} finally {
				try {
					conn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}

			response.setContentType("application/jpg;charset=utf-8");
			response.addHeader("Content-Disposition","attachment; filename=test.jpg");

			OutputStream outStream = response.getOutputStream();
			byte[] bytes = new byte[1024];

			int len = 0;
			if(in!=null){
				while ((len = in.read(bytes)) != -1) {
					outStream.write(bytes, 0, len);

				}
				
			}
			if(in!=null){
				in.close();
			}
			outStream.flush();
			outStream.close();
		}
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
