package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.vo.TDZJS;

public class GetJS extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6256566987219553875L;

	/**
	 * Constructor of the object.
	 */
	public GetJS() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String tdzjsid="";
		if(request.getParameter("tdzjsid")!=null) tdzjsid=request.getParameter("tdzjsid");
		
		ITDZJSService tdzjsService=(ITDZJSService)Container.getBean("tdzJsService");
		TDZJS tdzjs=tdzjsService.getTDZJS(tdzjsid);
		
		String returnMessage="";
		if(tdzjs!=null){
			returnMessage=tdzjs.getJs();
		}
		returnMessage=returnMessage==null?"":returnMessage;
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(returnMessage.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
		//doPost(request,response);
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		//doGet(request, response);
		String js="";
		String tdzh = URLDecoder.decode(request.getParameter("tdzh"),"utf-8");
		ITDZJSService tdzjsService = (ITDZJSService)Container.getBean("tdzJsService");
		//System.out.println(tdzh);
		List tdzjsList = tdzjsService.getTDZJSList(tdzh);
		if (tdzjsList.size()>0){
			for (int i=0; i<tdzjsList.size(); i++){
				TDZJS tdzjs=(TDZJS)tdzjsList.get(i);
				js = js + tdzjs.getJs()+ ";";
				//System.out.println(js);
			}
			js = js.substring(0, js.length()-1);
		}
		
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(js.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
