package com.jsegov.tddj.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.vo.DJKXB;

public class GetBHServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8716541825522866103L;

	/**
	 * Constructor of the object.
	 */
	public GetBHServlet() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String bhlx = "";
		String zslx = "";
		if (request.getParameter("bhlx") != null)
			bhlx = request.getParameter("bhlx");
		if (request.getParameter("zslx") != null)
			zslx = request.getParameter("zslx");
		IBHService bhService = (IBHService) Container.getBean("bhService");

		String returnMessage = "";
		if (bhlx != null) {
			if (bhlx.equals("tdzh")) {
				if (zslx.equals("") || zslx == null) {
					returnMessage = bhlx+",请选择证书类型。";
				} else if (zslx.equals("GY")) {
					returnMessage = bhlx+","+bhService.getGYTDSYZBH();
				} else if (zslx.equals("JY")) {
					returnMessage = bhlx+","+bhService.getJTTDSYZBH();
				} else if (zslx.equals("TX")) {
					returnMessage = bhlx+","+bhService.getTXQLZMSBH();
				} else if (zslx.equals("JU")) {
					returnMessage = bhlx+","+bhService.getJTTDSUZBH();
				}
			} else if (bhlx.equals("spb.spbh")) {
				returnMessage = bhlx+","+bhService.getSPBBH();
			} else if (bhlx.equals("sqsbh")) {
				returnMessage = bhlx+","+bhService.getSQBBH();
			}
		}
		returnMessage = returnMessage == null ? "" : returnMessage;
		
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(returnMessage.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
