package com.jsegov.tddj.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;

public class CheckSheetExists extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3451047931150350890L;

	/**
	 * Constructor of the object.
	 */
	public CheckSheetExists() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String sheetName = request.getParameter("sheetName");
		String projectId = request.getParameter("projectId");
		String resultXML = "OK";
		if (sheetName != null && sheetName.equals("sjd")) {
			ISJDService sjdService = (ISJDService) Container
					.getBean("sjdService");
			SJD sjd = sjdService.getSJD(projectId);
			if (sjd == null) {
				resultXML = "不存在收件单";
			}
		} else if (sheetName != null && sheetName.equals("sqb")) {
			ISQBService sqbService = (ISQBService) Container
					.getBean("sqbService");
			SQB sqb = sqbService.getSQB(projectId);
			if (sqb == null) {
				resultXML = "不存在申请表";
			}
		} else if (sheetName != null && (sheetName.equals("spb") || sheetName.equals("fm") || sheetName.equals("fm_dt"))) {
			ISPBService spbService = (ISPBService) Container
					.getBean("spbService");
			SPB spb = spbService.getSPB(projectId);
			if (spb == null) {
				resultXML = "不存在审批表";
			}
		} else if (sheetName != null && sheetName.equals("djk")) {
			ISPBService spbService = (ISPBService) Container.getBean("spbService");
			SPB spb = spbService.getSPB(projectId);
			String djh = spb.getDjh();
			IDJKService djkService = (IDJKService) Container.getBean("djkService");
			DJK djk = djkService.getDJKByDjh(djh);
			if (djk == null) {
				resultXML = "不存在登记卡";
			}
		} else if (sheetName != null && sheetName.equals("ghk")) {
			IGHKService ghkService = (IGHKService) Container
					.getBean("ghkService");
			GHK ghk = ghkService.getGHK(projectId);
			if (ghk == null) {
				resultXML = "不存在归户卡";
			}
		} else if (sheetName != null && sheetName.equals("gytdsyz")) {
			//String tdzh=request.getParameter("tdzh");
			if(request.getParameter("tdzh")!=null){
				String tdzh=new String(request.getParameter("tdzh").getBytes("ISO8859_1"),"GBK");
	//			String tdzh3=new String(request.getParameter("tdzh").getBytes("ISO8859_1"));
	//			System.out.println("tdzh2="+tdzh2);
	//			System.out.println("tdzh3="+tdzh3);
				
				IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
				GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZbyTdzh(tdzh);
				if (gytdsyz == null) {
					resultXML = "不存在国有土地使用证<"+tdzh+">";
				}
			}
		}

		// System.out.println(sb.toString());
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(resultXML.getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
