package com.jsegov.tddj.services.interf;

import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.SPB;


public interface IDJKService {
    DJK getDJK(String projectId);

    DJK getDJKByDjh(String djh);

    DJK getDJKByOldDjh(String olddjh);

    DJK getDJKByTdzh(String tdzh);

    void insertDJK(DJK djk);//添加记录

    void insertDJK(SPB spb);//通过新地号添加记录

    void insertDjk(SPB spb); //通过老地号添加记录

    void updateDJK(DJK djk);//修改记录

    void updateDJK(SPB spb);//通过新地号修改记录

    void updateDjk(SPB spb); //通过老地号修改记录

    void deleteDJK(String projectId);//删除记录

    List<Object> getDjkListForBatchPrint(HashMap<String, Object> map);  //批量打印用

    /**
     * 根据新老地号关系 更新新老的登记卡的地籍号为最新的地籍号
     *
     * @param newdjh
     */
    public void updateDjk(String newdjh);
}
