package com.jsegov.tddj.services;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZsService implements IZSService {
	@Autowired
    IGytdsyzService gyTdsyzService;
    @Autowired
    IJttdsyzService jtTdsyzService;
    @Autowired
    IJttdsuzService jtTdsuzService;
    @Autowired
    ITxqlzmsService txqlzmsService;
    @Autowired
    ISPBService spbService;

	public void creatZS(SPB spb) {
		// TODO Auto-generated method stub
		String qsxz = spb.getQsxz();
		String sqlx = spb.getSqlx();
		
		if (qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权") ) {
			qsxz="国有土地使用权";
		}else if (qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")){
			qsxz="集体土地使用权";
		}
		
		if (qsxz.equals("国有土地使用权") || qsxz.equals("")){
			if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记") 
					|| sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记") 
					|| sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
					|| sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
					|| sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
					|| sqlx.equals("政府储备土地使用权抵押初始登记")){
                txqlzmsService.insertTXQLZMS(spb);
			}else{
                gyTdsyzService.insertGYTDSYZ(spb);
			}
		}else if (qsxz.equals("集体土地使用权")){
			if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记") 
					|| sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记") 
					|| sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
					|| sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
					|| sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
					|| sqlx.equals("政府储备土地使用权抵押初始登记")){
                txqlzmsService.insertTXQLZMS(spb);
			}else{
                jtTdsyzService.insertJTTDSYZ(spb);
			}
		}else if (qsxz.equals("集体土地所有权")){
            jtTdsuzService.insertJTTDSUZ(spb);
		}
	}
	
	public void updateZS(SPB spb) {
		// TODO Auto-generated method stub
		String qsxz = spb.getQsxz();
		String sqlx = spb.getSqlx();
		
		if (qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权") ) {
			qsxz="国有土地使用权";
		}else if (qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")){
			qsxz="集体土地使用权";
		}
		
		if (qsxz.equals("国有土地使用权") || qsxz.equals("")){
			if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记") 
					|| sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记") 
					|| sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
					|| sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
					|| sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
					|| sqlx.equals("政府储备土地使用权抵押初始登记")){
                txqlzmsService.updateTXQLZMS(spb);
			}else{
                gyTdsyzService.updateGYTDSYZ(spb);
			}
		}else if (qsxz.equals("集体土地使用权")){
			if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记") 
					|| sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记") 
					|| sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
					|| sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
					|| sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
					|| sqlx.equals("政府储备土地使用权抵押初始登记")){
                txqlzmsService.updateTXQLZMS(spb);
			}else{
                jtTdsyzService.updateJTTDSYZ(spb);
			}
		}else if (qsxz.equals("集体土地所有权")){
            jtTdsuzService.updateJTTDSUZ(spb);
		}
	}
	
	public ZS getZSByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		if (tdzh.indexOf("国用")>0){
			GYTDSYZ gytdsyz = new GYTDSYZ();
			gytdsyz.setTdzh(tdzh);
			return gyTdsyzService.getGYTDSYZ(gytdsyz);
		}else if (tdzh.indexOf("集用")>0){
			//JTTDSYZ 
			return jtTdsyzService.getJTTDSYZByTdzh(tdzh);
		}else if (tdzh.indexOf("集有")>0){
			return jtTdsuzService.getJTTDSUZByTdzh(tdzh);
		}else if (tdzh.indexOf("他项")>0){
			return txqlzmsService.getTXQLZMSByTdzh(tdzh);
		}else{
			GYTDSYZ gytdsyz = new GYTDSYZ();
			gytdsyz.setTdzh(tdzh);
			return gyTdsyzService.getGYTDSYZ(gytdsyz);
		}
	}

	public void logoutZS(String tdzh,Integer logoutType) {
		// TODO Auto-generated method stub
		if (tdzh.indexOf("国用")>0){
			GYTDSYZ gytdsyz = (GYTDSYZ)getZSByTdzh(tdzh);
			gytdsyz.setIslogout(logoutType);
            gyTdsyzService.updateGYTDSYZ(gytdsyz);
		}else if (tdzh.indexOf("集用")>0){
			JTTDSYZ jttdsyz = (JTTDSYZ)getZSByTdzh(tdzh);
			jttdsyz.setIslogout(logoutType);
            jtTdsyzService.updateJTTDSYZ(jttdsyz);
		}else if (tdzh.indexOf("集有")>0){
			JTTDSUZ jttdsuz = (JTTDSUZ)getZSByTdzh(tdzh);
			jttdsuz.setIslogout(logoutType);
            jtTdsuzService.updateJTTDSUZ(jttdsuz);
		}else if (tdzh.indexOf("他项")>0){
			TXQLZMS txqlzms= (TXQLZMS)getZSByTdzh(tdzh);
			txqlzms.setIslogout(logoutType);
            txqlzmsService.updateTXQLZMS(txqlzms);
		}else{
			GYTDSYZ gytdsyz = (GYTDSYZ)getZSByTdzh(tdzh);
			gytdsyz.setIslogout(logoutType);
            gyTdsyzService.updateGYTDSYZ(gytdsyz);
		}
	}

	public void logoutZSToTX(SPB spb) {
		// TODO Auto-generated method stub
		Integer islogout = 4;
//		Double txmj = spbService.statTXMJ(spb.getZtdzh());
//		Double tdqlmj = spb.getSyqmj();
//		if (tdqlmj>txmj){
//			islogout = 3;
//		}else if(tdqlmj==txmj){
//			islogout = 4;
//		}
		if (spb.getZtdzh().indexOf("国用")>0){
			GYTDSYZ gytdsyz = (GYTDSYZ)getZSByTdzh(spb.getZtdzh());
			gytdsyz.setIslogout(islogout);
            gyTdsyzService.updateGYTDSYZ(gytdsyz);
		}else if (spb.getZtdzh().indexOf("集用")>0){
			JTTDSYZ jttdsyz = (JTTDSYZ)getZSByTdzh(spb.getZtdzh());
			jttdsyz.setIslogout(islogout);
            jtTdsyzService.updateJTTDSYZ(jttdsyz);
		}
	}

	public void printZS(String tdzh) {
		// TODO Auto-generated method stub
		if (tdzh.indexOf("国用")>0){
			GYTDSYZ gytdsyz = (GYTDSYZ)getZSByTdzh(tdzh);
			gytdsyz.setIsprinted(1);
            gyTdsyzService.updateGYTDSYZ(gytdsyz);
		}else if (tdzh.indexOf("集用")>0){
			JTTDSYZ jttdsyz = (JTTDSYZ)getZSByTdzh(tdzh);
			jttdsyz.setIsprinted(1);
            jtTdsyzService.updateJTTDSYZ(jttdsyz);
		}else if (tdzh.indexOf("集有")>0){
			JTTDSUZ jttdsuz = (JTTDSUZ)getZSByTdzh(tdzh);
			jttdsuz.setIsprinted(1);
            jtTdsuzService.updateJTTDSUZ(jttdsuz);
		}else if (tdzh.indexOf("他项")>0){
			TXQLZMS txqlzms= (TXQLZMS)getZSByTdzh(tdzh);
			txqlzms.setIsprinted(1);
            txqlzmsService.updateTXQLZMS(txqlzms);
		}else{
		}
	}
    public ZS getZSBySpb(SPB spb){
        String qsxz = spb.getQsxz();
        String sqlx = spb.getSqlx();
        String projectId=spb.getProjectId();
        if (qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权") ) {
            qsxz="国有土地使用权";
        }else if (qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")){
            qsxz="集体土地使用权";
        }
        if (qsxz.equals("国有土地使用权") || qsxz.equals("")){
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
                    || sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
                    || sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
                    || sqlx.equals("政府储备土地使用权抵押初始登记")){
                return txqlzmsService.getTXQLZMS(projectId);
            }else{
                return gyTdsyzService.getGYTDSYZ(projectId);
            }
        }else if (qsxz.equals("集体土地使用权")){
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")
                    || sqlx.equals("抵押期间使用权及抵押权变更登记") || sqlx.equals("因主债权转让抵押权变更登记")
                    || sqlx.equals("出让土地使用权抵押权初始登记") || sqlx.equals("划拨土地使用权抵押权初始登记")
                    || sqlx.equals("政府储备土地使用权抵押初始登记")){
                return txqlzmsService.getTXQLZMS(projectId);
            }else{
               return  jtTdsyzService.getJTTDSYZ(projectId);
            }
        }else if (qsxz.equals("集体土地所有权")){
            return jtTdsuzService.getJTTDSUZ(projectId);
        }  else{
            return null;
        }
    }
    public String checkTdzhIsExist(String projectId){
        String msg="";
        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZ(projectId);
        if(gytdsyz!=null && gytdsyz.getTdzh().equals("")) {
            msg="请获取土地证号后再转发";
        }
        IJttdsyzService jttdsyzService = (IJttdsyzService) Container .getBean("jtTdsyzService");
        JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
        if(jttdsyz!=null && jttdsyz.getTdzh().equals("")) {
            msg="请获取土地证号后再转发";
        }
        IJttdsuzService jttdsuzService = (IJttdsuzService) Container .getBean("jtTdsuzService");
        JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
        if(jttdsuz!=null && jttdsuz.getTdzh().equals("")) {
            msg="请获取土地证号后再转发";
        }
        ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container .getBean("txqlzmsService");
        TXQLZMS txqlzms = txqlzmsService.getTXQLZMS(projectId);
        if(txqlzms!=null && txqlzms.getTdzh().equals("")) {
            msg="请获取土地证号后再转发";
        }
        return msg;
    }
}

