package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.dao.ZD_DJDCBDAO;
import com.jsegov.tddj.services.interf.IZD_DJDCBService;
import com.jsegov.tddj.vo.ZD_DJDCB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZdDjdcbService implements IZD_DJDCBService {

    @Autowired
    ZD_DJDCBDAO djdcbDAO;
	

	public ZD_DJDCB selectDjdcb(ZD_DJDCB djdcb) {
		// TODO Auto-generated method stub
		List djdcbList = getDjdcb(djdcb);
		if (djdcbList!=null && djdcbList.size()>0){
			djdcb = (ZD_DJDCB)djdcbList.get(0);
		}
		return djdcb;
	}

	public List getDjdcb(ZD_DJDCB parameterDJDCB) {
		// TODO Auto-generated method stub
		List list = null;
		try {
			list=djdcbDAO.getDjdcb(parameterDJDCB);
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return list;
	}

	public Double getFzmj(String djh) {
		// TODO Auto-generated method stub
		ZD_DJDCB djdcb = new ZD_DJDCB();
		djdcb.setDjh(djh);
		djdcb = selectDjdcb(djdcb);
		return djdcb.getFzmj();
	}

	public Double getScmj(String djh) {
		// TODO Auto-generated method stub
		ZD_DJDCB djdcb = new ZD_DJDCB();
		djdcb.setDjh(djh);
		djdcb = selectDjdcb(djdcb);
		return djdcb.getScmj();
	}

	public String getBlcDm(String blc) {
		// TODO Auto-generated method stub
		String blcDm = null;
		try {
			if (blc!=null && !blc.equals(""))
				blc = djdcbDAO.getBlcDm(blc);
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return blcDm;
	}

	public String getBlcByDjh(String djh) {
		// TODO Auto-generated method stub
		String blc = "";
		try {
			if (djh!=null && !djh.equals(""))
				blc = djdcbDAO.getBlcByDjh(djh);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return blc;
	}
    public String getUniqueIdByDjh(String djh){
		return djdcbDAO.getUniqueIdByDjh(djh);
	}

    public ZD_DJDCB getZDTSMJByDjh(HashMap<String, Object> map){
        return djdcbDAO.getZDTSMJByDjh(map);
    }
}
