package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.dao.TxqlzmsDAO;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.TXQLZMS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxqlzmsService implements ITxqlzmsService {
	@Autowired
    TxqlzmsDAO txqlzmsDAO;

	public void deleteTXQLZMS(String projectId) {
		txqlzmsDAO.deleteTXQLZMS(projectId);
	}

	public TXQLZMS getTXQLZMS(String projectId) {
		return txqlzmsDAO.getTXQLZMS(projectId);
	}

	public void insertTXQLZMS(TXQLZMS txqlzms) {
		txqlzmsDAO.insertTXQLZMS(txqlzms);
	}

	public void updateTXQLZMS(TXQLZMS txqlzms) {
		txqlzmsDAO.updateTXQLZMS(txqlzms);
	}

	public void insertTXQLZMS(SPB spb) {
		// TODO Auto-generated method stub
		txqlzmsDAO.insertTXQLZMS(getTXQLZMSBySPB(spb));	
	}

	public void updateTXQLZMS(SPB spb) {
		// TODO Auto-generated method stub
		txqlzmsDAO.updateTXQLZMS(getTXQLZMSBySPB(spb));
	}
	
	public TXQLZMS getTXQLZMSByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		return txqlzmsDAO.getTXQLZMSByTdzh(tdzh);
	}
	
	public TXQLZMS getTXQLZMSBySPB(SPB spb){
		//根据审批表生成他项权利证明书
		//projectid, tdzh, qlr, ywr, zl, djh, th, qsxz, syqmj, yt, 
		//syqlx, txql, qlsx, cxqx, dwdm, fzrq, sdrq, islogout, rmzf, olddata
		TXQLZMS txqlzms = new TXQLZMS();
		txqlzms.setProjectId(spb.getProjectId());
		txqlzms.setTdzh(spb.getTdzh());
		txqlzms.setQlr(spb.getRf1_dwmc());
		txqlzms.setYwr(spb.getRf2_dwmc());
		txqlzms.setZl(spb.getZl());
		txqlzms.setDjh(spb.getDjh());
		txqlzms.setTh(spb.getTh());
		txqlzms.setQsxz(spb.getQsxz());
		txqlzms.setSyqmj(spb.getSyqmj());
		txqlzms.setYt(spb.getYt());
		txqlzms.setSyqlx(spb.getSyqlx());
		txqlzms.setTxql(spb.getTxql());
		txqlzms.setQlsx(spb.getQlsx());
		txqlzms.setCxqx(spb.getCxqx());
		txqlzms.setDwdm(spb.getDwdm());
		
		String fzrq = "";
		if (spb.getPzrq() != null){
			fzrq = CommonUtil.formateDate(spb.getPzrq());
		}
//		else if(spb.getShrq() != null){
//			fzrq =CommonUtil.formateDate(spb.getShrq());
//		}
		else {
			fzrq =CommonUtil.getCurrStrDate();
		}
		txqlzms.setFzrq(fzrq);
		txqlzms.setSdrq(spb.getSdrq());
		txqlzms.setIslogout(0);
		txqlzms.setRmzf(spb.getRmzf());
		txqlzms.setOlddata(0);
		return txqlzms;
	}

	public List<Object> expTxqlzms(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return txqlzmsDAO.expTxqlzms(map);
	}

	public List<Object> printZsQsb(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return txqlzmsDAO.printZsQsb(map);
	}

    public List<TXQLZMS> queryTxqlzmsByYtdzh(String ztdzh) {
        // TODO Auto-generated method stub
        List<TXQLZMS> list = null;
        try {
            if (ztdzh!=null && !ztdzh.equals("")){
                list = txqlzmsDAO.queryTxqlzmsByYtdzh(ztdzh);
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return list;
    }
}
