package com.jsegov.tddj.services;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

import com.gtis.util.DataSourceManager;
import com.gtis.spring.Container;
import com.jsegov.tddj.dao.SPBDAO;
import com.jsegov.tddj.services.interf.IAutoSign;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IQSZD_DJDCBService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.vo.PrintSPB;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpbService implements ISPBService {
	@Autowired
    SPBDAO spbDAO;

    @Autowired
    IAutoSign AutoSign;
	
	public void deleteSPB(String projectId) {
		// TODO Auto-generated method stub
		spbDAO.deleteSPB(projectId);
	}

	public SPB getSPB(String projectId) {
		// TODO Auto-generated method stub
		return spbDAO.getSPB(projectId);
	}

	public void insertSPB(SPB spb) {
		// TODO Auto-generated method stub
		spbDAO.insertSPB(spb);
	}

	public void updateSPB(SPB spb) {
		// TODO Auto-generated method stub
		spbDAO.updateSPB(spb);
	}

	public SPB getSPB(SPB spb) {
		// TODO Auto-generated method stub
		return spbDAO.getSPB(spb);
	}
	
	//根据申请表生成审批表
	public SPB readSQB(SPB spb,SQB sqb){
		if (spb.getSpbh()==null || spb.getSpbh().equals("")){
			IBHService bhService = (IBHService)Container.getBean("bhService");
			spb.setSpbh(bhService.getSPBBH());
            //STORY #3223 土地证号不在此处生成、在注册打印节点生成
			//spb.setTdzh(bhService.getSPBHBySqlx(sqb.getProjectId(),sqb.getSqlx(), sqb.getQsxz()));
			//spb.setSpbh(sqb.getSqsbh());
			//spb.setTdzh(sqb.getSqsbh());
		}
		
		//对应字段
		//projectid, sqsbh, sqlx, rf1_dwmc, rf1_sfzmtype, rf1_sfzmnum, rf1_dwxz, rf1_fddbrxm, rf1_zgbm, rf1_lxfs, 
		spb.setProjectId(sqb.getProjectId());
		//spb.setSpbh(bhService.getSPBHBySqlx(sqb.getSqlx(), sqb.getQsxz()));
		//spb.setTdzh(tdzh);
		spb.setSqlx(sqb.getSqlx());
		spb.setDw(sqb.getDw());
		spb.setRf1(sqb.getRf1());
		spb.setRf1_dwmc(sqb.getRf1_dwmc());
		spb.setRf1_sfzmtype(sqb.getRf1_sfzmtype());
		spb.setRf1_sfzmnum(sqb.getRf1_sfzmnum());
		spb.setRf1_dwxz(sqb.getRf1_dwxz());
		spb.setRf1_fddbr(sqb.getRf1_fddbr());
		//spb.setRf1_zgbm(sqb.getRf1_zgbm());
		spb.setRf1_lxdh(sqb.getRf1_lxdh());
		spb.setRf1_lxr(sqb.getRf1_lxr());
		spb.setRf1_dzyj(sqb.getRf1_dzyj());
		//rf1_txdz, rf1_yb, rf2_dwmc, rf2_sfzmtype, rf2_sfzmnum, rf2_dwxz, rf2_fddbrxm, rf2_zgbm, rf2_lxfs, rf2_txdz,
		spb.setRf1_txdz(sqb.getRf1_txdz());
		spb.setRf1_yb(sqb.getRf1_yb());
		spb.setRf2(sqb.getRf2());
		spb.setRf2_dwmc(sqb.getRf2_dwmc());
		spb.setRf2_sfzmtype(sqb.getRf2_sfzmtype());
		spb.setRf2_sfzmnum(sqb.getRf2_sfzmnum());
		spb.setRf2_dwxz(sqb.getRf2_dwxz());
		spb.setRf2_fddbr(sqb.getRf2_fddbr());
		//spb.setRf2_zgbm(sqb.getRf2_zgbm());
		spb.setRf2_lxdh(sqb.getRf2_lxdh());
		spb.setRf2_lxr(sqb.getRf2_lxr());
		spb.setRf2_dzyj(sqb.getRf2_dzyj());
		spb.setRf2_txdz(sqb.getRf2_txdz());
		//rf2_yb, djh, th, ztdzh, dcbh, qsxz, syqlx, qdrq, zzrq, zdmj, tdqlmj, zl, bddj, yt, tddj, qdjg, jzrjl, jzmd, 
		spb.setRf2_yb(sqb.getRf2_yb());
		spb.setDjh(sqb.getDjh());
		spb.setTh(sqb.getTh());
		spb.setZtdzh(sqb.getZtdzh());
		spb.setDcbh(sqb.getDcbh());
		spb.setQsxz(sqb.getQsxz());
		spb.setSyqlx(sqb.getSyqlx());
		//spb.setQdrq(sqb.getQdrq());
		spb.setQlslqk(sqb.getQlslqk());
		spb.setSyqx(sqb.getSyqx());
		spb.setZzrq(sqb.getZzrq());
		spb.setZdmj(sqb.getZdmj());
		//spb.setTdqlmj(sqb.getTdqlmj());
		//if (!sqb.getSqlx().equals("房改房登记")){
		if (!sqb.getSqlx().equals("小区变更登记")){
			if(sqb.getSyqmj()== null || sqb.getSyqmj()==0.0) {
				try{
					Double syqmj = 0.0;
					if (sqb.getZdmj()!=null && !"".equals(sqb.getZdmj())){
						syqmj = Double.parseDouble(sqb.getZdmj());
					}
					spb.setSyqmj(syqmj);
					spb.setDymj(syqmj);
				}catch(Exception e){
					System.out.println("ERROR----SpbService.readSQB.Double.parseDouble(sqb.getZdmj())");
				}
			} else {
				spb.setSyqmj(sqb.getSyqmj());
				spb.setDymj(sqb.getDymj());
			}
			spb.setFtmj(sqb.getFtmj());
		}
		spb.setZl(sqb.getZl());
		spb.setYt(sqb.getYt());
		//spb.setTddj(sqb.getTddj());
		spb.setQdjg(sqb.getQdjg());
		spb.setJzrjl(sqb.getJzrjl());
		spb.setJzmd(sqb.getJzmd());
		//jzxg, jzwzdmj, jzwlx, sbjzwqs, txqllx, qlsx, txmj, dyl, sdrq, cxqx, dyje, zdj, txql, txjs, dwdm,rmzf
		spb.setJzxg(sqb.getJzxg());
		spb.setJzwzdmj(sqb.getJzwzdmj());
		spb.setJzwlx(sqb.getJzwlx());
		spb.setSbjzwqs(sqb.getSbjzwqs());
		spb.setTxqllx(sqb.getTxqllx());
		spb.setQlsx(sqb.getQlsx());
		spb.setTxmj(sqb.getTxmj());
		spb.setDyl(sqb.getDyl());
		spb.setSdrq(sqb.getSdrq());
		spb.setCxqx(sqb.getCxqx());
		spb.setDyje(sqb.getDyje());
		spb.setTdjg(sqb.getTdjg());
		spb.setTxql(sqb.getTxql());
		spb.setTxjs(sqb.getTxjs());
		spb.setDwdm(sqb.getDwdm());
		spb.setRmzf(sqb.getRmzf());
		//spb.setQsly(sqb.getZmcl());
		spb.setBsm(sqb.getBsm());
		spb.setZdsz(sqb.getZdsz());
		
		if(spb.getSqlx().indexOf("集体土地所有权")>-1){
			spb = readSYQDJDCB(spb);
			spb.setDymj(0.0);
			spb.setSyqmj(0.0);
			spb.setFtmj(0.0);
		}
		/*spb.setRf1_str(sqb.getRf1_str());
		spb.setRf1_strsfzmtype(sqb.getRf1_strsfzmtype());
		spb.setRf1_strsfzmnum(sqb.getRf1_strsfzmnum());
		spb.setRf2_str(sqb.getRf2_str());
		spb.setRf2_strsfzmtype(sqb.getRf2_strsfzmtype());
		spb.setRf2_strsfzmnum(sqb.getRf2_strsfzmnum());
		spb.setJzmj(sqb.getJzmj());
		spb.setFczh(sqb.getFczh());*/

		return spb;
	}

	public SPB readSYQDJDCB(SPB spb){
		/**
		 * 用途：读取QSZD_ZDMJ表  按一级分类求土地的分类面积 填入SPB
		 * 参数：SPB 
		 * 修改日期：2008-12-10
		 * 修改人：刘仲阳

		 */
		String djh = spb.getDjh();
		HashMap<String, Object> map = new HashMap<String, Object>();
		String queryDldm = "";
		
		Double dlmj[] = new Double[12];
		
		IQSZD_DJDCBService qszd_djdcbService = (IQSZD_DJDCBService)Container.getBean("qszd_DjdcbService");
		for (int i = 1 ; i <= 12 ; i++){
			if (String.valueOf(i).length() == 1){
				queryDldm = "0" + String.valueOf(i) + "%";
				map.clear();
				map.put("djh", djh);
				map.put("dldm", queryDldm);
				dlmj[i-1] = qszd_djdcbService.sumDLMJ(map);	
			} else {
				queryDldm = String.valueOf(i) + "%";
				map.clear();
				map.put("djh", djh);
				map.put("dldm", queryDldm);
				dlmj[i-1] = qszd_djdcbService.sumDLMJ(map);	
			}
		}
		spb.setGd(dlmj[0]);
		spb.setYd(dlmj[1]);
		spb.setLd(dlmj[2]);
		spb.setCd(dlmj[3]);
		spb.setSfyd(dlmj[4]);
		spb.setGkyd(dlmj[5]);
		spb.setZzyd(dlmj[6]);
		spb.setGgyd(dlmj[7]);
		spb.setTsyd(dlmj[8]);
		spb.setJtyd(dlmj[9]);
		spb.setSyyd(dlmj[10]);
		spb.setQtyd(dlmj[11]);
		return spb;
	}
	
	public Double statTXMJ(String tdzh) {
		// TODO Auto-generated method stub
		return spbDAO.statTXMJ(tdzh);
	}

	public SPB getSPB(String projectId, String tdzh) {
		return spbDAO.getSPB(projectId, tdzh);
	}

	public PrintSPB getPrintSPB(String projectId) {
		// TODO Auto-generated method stub
		return spbDAO.getPrintSPB(projectId);
	}

	public List<Object> expSPB(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return spbDAO.expSPB(map);
	}

	public void autoSign(ISPBService spbService,SPB spb) {
		// TODO Auto-generated method stub
		String projectId = spb.getProjectId();
		try {
            AutoSign.setConn(DataSourceManager.getDataSource("globalDataSource").getConnection());
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        AutoSign.delSign(projectId);
		spb.setScr_sign(AutoSign.sign(projectId, "王立兴"));
		spb.setShr_sign(AutoSign.sign(projectId, "管卫忠"));
		if (spb.getSqlx().indexOf("抵押")==-1){
			spb.setPzr_sign(AutoSign.sign(projectId, "奚文彪"));
		}
        AutoSign.colseConn();
		spbService.updateSPB(spb);
	}

	public List<Object> querySPB(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return spbDAO.querySPB(map);
	}
}
