package com.jsegov.tddj.services;

import java.util.Date;

import com.jsegov.tddj.dao.ProjectDAO;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.vo.Project;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectService implements IProjectService {

    @Autowired
    ProjectDAO projectDAO;
	
	public void deleteProject(String projectId) {
		projectDAO.deleteProject(projectId);
	}

	public Project getProject(String projectId) {
		return projectDAO.getProject(projectId);
	}

	public void insertProject(Project project) {
		projectDAO.insertProject(project);
	}

	public void updateProject(Project project) {
		projectDAO.updateProject(project);
	}

	public void finishProject(String projectId, Date endTime) {
		// TODO Auto-generated method stub
		Project project = projectDAO.getProject(projectId);
		project.setEndTime(endTime);
		projectDAO.updateProject(project);
	}
}
