package com.jsegov.tddj.services;

import java.util.List;
import java.util.Map;

import com.jsegov.tddj.check.CreateTaskCheck;
import com.jsegov.tddj.dao.*;
import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.vo.NewProjectCheck;


public class NewProjectCheckService implements INewProjectCheckService {

    private NewProjectCheckDao newProjectCheckDao;
    private Map<Integer,CreateTaskCheck> checkFns;
    private GytdsyzDAO gytdsyzDAO;
    private TxqlzmsDAO txqlzmsDAO;

    public List getNewProjectCheck(String workFlowID) {
		return newProjectCheckDao.getNewProjectCheck(workFlowID);
	}

    @Override
    public List<NewProjectCheck> getNewProjectCheckByDjlx(String djlx) {
        return newProjectCheckDao.getNewProjectCheckByDjlx(djlx);
    }

    public String statBgmj(String tdzh) {
        // TODO Auto-generated method stub
        return gytdsyzDAO.statBgmj(tdzh);
    }

    public String statTxmj(String tdzh) {
        // TODO Auto-generated method stub
        return txqlzmsDAO.statTxmj(tdzh);
    }

    @Override
    public CreateTaskCheck getCheckFn(Integer checkCode) {
        return checkFns.get(checkCode);
    }

    public void setNewProjectCheckDao(NewProjectCheckDao newProjectCheckDao) {
        this.newProjectCheckDao = newProjectCheckDao;
    }

    public NewProjectCheckDao getNewProjectCheckDao() {
        return newProjectCheckDao;
    }

    public void setCheckFns(Map<Integer,CreateTaskCheck> checkFns) {
        this.checkFns = checkFns;
    }

    public void setGytdsyzDAO(GytdsyzDAO gytdsyzDAO) {
        this.gytdsyzDAO = gytdsyzDAO;
    }

    public GytdsyzDAO getGytdsyzDAO() {
        return gytdsyzDAO;
    }

    public void setTxqlzmsDAO(TxqlzmsDAO txqlzmsDAO) {
        this.txqlzmsDAO = txqlzmsDAO;
    }

    public TxqlzmsDAO getTxqlzmsDAO() {
        return txqlzmsDAO;
    }
}
