package com.jsegov.tddj.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.CFDAO;
import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.dao.JttdsyzDAO;
import com.jsegov.tddj.dao.LimitFieldDAO;
import com.jsegov.tddj.dao.SJDDAO;
import com.jsegov.tddj.dao.SPBDAO;
import com.jsegov.tddj.dao.SQBDAO;
import com.jsegov.tddj.dao.TxqlzmsDAO;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.ISJDCLService;
import com.jsegov.tddj.services.interf.IYYDJService;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.LimitField;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TXQLZMS;
import com.jsegov.tddj.vo.YYDJ;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LimitFieldService implements ILimitFieldService {
	@Autowired
    LimitFieldDAO limitFieldDAO;
    @Autowired
	SJDDAO sjdDAO;
    @Autowired
	SQBDAO sqbDAO;
	@Autowired
    SPBDAO spbDAO;
    @Autowired
	CFDAO cfDAO;
    @Autowired
    GytdsyzDAO gytdsyzDAO;
	@Autowired
    JttdsyzDAO jttdsyzDAO;
	@Autowired
    TxqlzmsDAO txqlzmsDAO;

	public String checkLimitField(String projecttype, String nodeid, String projectId){
		// TODO Auto-generated method stub
		SJD sjd_sqlx = sjdDAO.getSJD(projectId);
		String sqlx = sjd_sqlx.getSqlx();
		List limitFieldList = getLimitField(sqlx,nodeid);
		if (limitFieldList.size()>0){
			SJD sjd = sjdDAO.getSJD(projectId);
			SQB sqb = sqbDAO.getSQB(projectId);
			SPB spb = spbDAO.getSPB(projectId);			
			GYTDSYZ gytdsyz = gytdsyzDAO.getGYTDSYZ(projectId);
			TXQLZMS txqlzms = txqlzmsDAO.getTXQLZMS(projectId);
			for (Integer i=0; i<limitFieldList.size(); i++){
				LimitField limitField = (LimitField)limitFieldList.get(i);
				String tableName = limitField.getTablename();
				String fieldName = limitField.getFieldname();
				String memo = limitField.getMemo();
				if (tableName.equals("tbl_sjd")){
					
					if (sjd != null){
						if (!getFieldValue(sjd,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("zd_sqdj")){
					
					if (sqb != null){
						if (!getFieldValue(sqb,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("tbl_cf")){
					CF cf = cfDAO.getCF(projectId);
					if (cf != null){
						if (!getFieldValue(cf,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("zd_qssp")){
					
					if (spb != null){
						if (!getFieldValue(spb,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("tbl_gytdsyz")){
					
					if (gytdsyz != null){
						if (!getFieldValue(gytdsyz,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("tbl_txqlzms")){
					
					if (txqlzms != null){
						if (!getFieldValue(txqlzms,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("tbl_jttdsyz")){
					JTTDSYZ jttdsyz = jttdsyzDAO.getJTTDSYZ(projectId);
					if (jttdsyz != null){
						if (!getFieldValue(jttdsyz,fieldName)){
							return memo;
						}
					}
				}else if (tableName.equals("tbl_yydj")){
					IYYDJService yydjService = (IYYDJService)Container.getBean("yydjService");
					YYDJ yydj = yydjService.getYYDJ(projectId);
					if (yydj != null){
						if (!getFieldValue(yydj,fieldName)){
							return memo;
						}
					}					
				}else if (tableName.equals("tbl_sjdcl")){
					ISJDCLService sjdclService = (ISJDCLService)Container.getBean("sjdClService");
					boolean bb = sjdclService.isSaveSJDCL(projectId);
					if (!bb){
						return memo;
					}					
				}
			}
		}
		return null;
	}

	public List getLimitField(String projecttype, String nodeid) {
		// TODO Auto-generated method stub
		return limitFieldDAO.getLimitField(projecttype, nodeid);
	}

	public boolean getFieldValue(Object obj, String fieldName){
		String fieldValue = "";
		fieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1).toUpperCase());
		Method m = null;
		try {
			m = obj.getClass().getMethod("get" + fieldName, null);
		} catch (SecurityException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchMethodException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		String returnType = m.getReturnType().getName();
		if (returnType.equals("java.lang.String")) {
			try {
				fieldValue = (String) m.invoke(obj, null);
				if (fieldValue ==null){
					return false;
				}else{
					fieldValue = fieldValue.trim();
				}
				if (fieldValue.equals("")){
					return false;
				}
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else if (returnType.equals("java.util.Date")) {
			Date adate = null;
			try {
				adate = (Date) m.invoke(obj, null);
				if(adate==null){
					return false;
				}
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (returnType.equals("java.lang.Integer")) {
			Integer avalue = 0;
			try {
				avalue = (Integer) m.invoke(obj, null);
				if(avalue==0){
					return false;
				}
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (returnType.equals("java.lang.Double")) {
			Double dvalue = 0.0;
			try {
				dvalue = (Double) m.invoke(obj, null);
				if(dvalue == 0.0){
					return false;
				}
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} 
		return true;
	}

	public List getLimitFieldByTable(String projecttype, String tableName,String nodeName) {
		// TODO Auto-generated method stub
		return limitFieldDAO.getLimitFieldByTable(projecttype, tableName,nodeName);
	}

	public String getLimitFieldString(String sqlx, String tableName,String remark) {
		// TODO Auto-generated method stub
		StringBuffer limitField = new StringBuffer();
		try {			
	 		List limitList = getLimitFieldByTable(sqlx, tableName,remark);
	 		
	 		if (limitList.size() > 0) {
	 			for (int i = 0; i < limitList.size(); i++) {
	 				LimitField limit = (LimitField) limitList.get(i);
	 				limitField.append(limit.getFieldname());
	 				limitField.append(",");
	 			}
	 		}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}		
		return limitField.toString();
	}
}
