package com.jsegov.tddj.services;


import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GyTdsyzService implements IGytdsyzService {

    @Autowired
    GytdsyzDAO gytdsyzDAO;


	public void deleteGYTDSYZ(String projectId) {
		gytdsyzDAO.deleteGYTDSYZ(projectId);
	}

	public void insertGYTDSYZ(GYTDSYZ gytdsyz) {
		gytdsyzDAO.insertGYTDSYZ(gytdsyz);
	}

	public void updateGYTDSYZ(GYTDSYZ gytdsyz) {
		gytdsyzDAO.updateGYTDSYZ(gytdsyz);
	}

	public GYTDSYZ getGYTDSYZ(GYTDSYZ gytdsyz) {
		// TODO Auto-generated method stub
		return gytdsyzDAO.getGytdsyz(gytdsyz);
	}

	public GYTDSYZ getGYTDSYZ(String projectId) {
		// TODO Auto-generated method stub
		return gytdsyzDAO.getGYTDSYZ(projectId);
	}

	public void insertGYTDSYZ(SPB spb) {
		// TODO Auto-generated method stub
		gytdsyzDAO.insertGYTDSYZ(getGYTDSYZBySPB(spb));	
	}

	public void updateGYTDSYZ(SPB spb) {
		// TODO Auto-generated method stub
		gytdsyzDAO.updateGYTDSYZ(getGYTDSYZBySPB(spb));
	}
	
	public GYTDSYZ getGYTDSYZbyTdzh(String tdzh) {
		// TODO Auto-generated method stub
		GYTDSYZ gytdsyz = new GYTDSYZ();
		gytdsyz.setTdzh(tdzh);
		return gytdsyzDAO.getGytdsyz(gytdsyz);
	}	
	
	public GYTDSYZ getGYTDSYZBySPB(SPB spb){
		//根据审批表生成国有土地使用证
		//字段对应---注意人方一及人方二
		GYTDSYZ gytdsyz = new GYTDSYZ();
		//String sqlx = spb.getSqlx();
		
		/*if (!spb.getRf2_dwmc().equals("")){
			gytdsyz.setQlr(spb.getRf2_dwmc());
		}else{
			gytdsyz.setQlr(spb.getRf1_dwmc());
		}*/
		gytdsyz.setQlr(spb.getRf1_dwmc());
		gytdsyz.setProjectId(spb.getProjectId());
		//gytdsyz.setTdzh(spb.getSpbh());
		gytdsyz.setTdzh(spb.getTdzh());
		gytdsyz.setZl(spb.getZl());
		gytdsyz.setDjh(spb.getDjh());
		gytdsyz.setTh(spb.getTh());
		gytdsyz.setYt(spb.getYt());
		gytdsyz.setQdjg(spb.getQdjg());
		gytdsyz.setSyqlx(spb.getSyqlx());
		gytdsyz.setZzrq(spb.getZzrq());
		gytdsyz.setSyqmj(spb.getSyqmj());
		gytdsyz.setDymj(spb.getDymj());
		gytdsyz.setFtmj(spb.getFtmj());
		String fzrq = "";
		if (spb.getPzrq() != null){
			fzrq = CommonUtil.formateDate(spb.getPzrq());
		}
//		else if(spb.getShrq() != null){
//			fzrq =CommonUtil.formateDate(spb.getShrq());
//		}
		else {
			fzrq =CommonUtil.getCurrStrDate();
		}
		gytdsyz.setFzrq(fzrq);
		gytdsyz.setDwdm(spb.getDwdm());
		gytdsyz.setIslogout(0);
		gytdsyz.setRmzf(spb.getRmzf());
		gytdsyz.setOlddata(0);
		return gytdsyz;
	}

	public GYTDSYZ getGYTDSYZBySQB(SQB sqb){
		//根据申请表生成国有土地使用证----
		GYTDSYZ gytdsyz = new GYTDSYZ();
		gytdsyz.setQlr(sqb.getRf2_dwmc());
		gytdsyz.setProjectId(sqb.getProjectId());
		gytdsyz.setTdzh(sqb.getSqsbh());
		gytdsyz.setZl(sqb.getZl());
		gytdsyz.setDjh(sqb.getDjh());
		gytdsyz.setTh(sqb.getTh());
		gytdsyz.setYt(sqb.getYt());
		gytdsyz.setQdjg(sqb.getQdjg());
		gytdsyz.setSyqlx(sqb.getSyqlx());
		gytdsyz.setZzrq(sqb.getZzrq());
		gytdsyz.setSyqmj(sqb.getSyqmj());
		gytdsyz.setDymj(sqb.getDymj());
		gytdsyz.setFtmj(sqb.getFtmj());
		gytdsyz.setFzrq(CommonUtil.getCurrStrDate());
		gytdsyz.setDwdm(sqb.getDwdm());
		gytdsyz.setIslogout(0);
		gytdsyz.setRmzf(sqb.getRmzf());
		gytdsyz.setOlddata(0);
		return gytdsyz;
	}
	
	public void insertGYTDSYZ(SQB sqb) {
		// TODO Auto-generated method stub
		gytdsyzDAO.insertGYTDSYZ(getGYTDSYZBySQB(sqb));
	}

	public void updateGYTDSYZ(SQB sqb) {
		// TODO Auto-generated method stub
		gytdsyzDAO.updateGYTDSYZ(getGYTDSYZBySQB(sqb));
	}

	public String statBgmj(String tdzh) {
		// TODO Auto-generated method stub
		return gytdsyzDAO.statBgmj(tdzh);
	}

	public List<Object> expGytdsyz(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return gytdsyzDAO.expGytdsyz(map);
	}

	public List<Object> printZsQsb(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return gytdsyzDAO.printZsQsb(map);
	}

}
