package com.jsegov.tddj.services;

import java.util.List;

import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GhkService implements IGHKService {
	@Autowired
    GHKDAO ghkDAO;
	@Autowired
    IBHService bhService;

	public void deleteGHK(String projectId) {
		// TODO Auto-generated method stub
		ghkDAO.deleteGHK(projectId);
	}

	public List getGHK(GHK ghk) {
		// TODO Auto-generated method stub
		return ghkDAO.getGHK(ghk);
	}

	public GHK getGHK(String projectId) {
		// TODO Auto-generated method stub
		return ghkDAO.getGHK(projectId);
	}

	public void insertGHK(GHK ghk) {
		// TODO Auto-generated method stub
		ghkDAO.insertGHK(ghk);
	}

	public void insertGHK(SPB spb) {
		// TODO Auto-generated method stub
		ghkDAO.insertGHK(getGHKBySPB(spb));
	}

	public void updateGHK(GHK ghk) {
		// TODO Auto-generated method stub
		ghkDAO.updateGHK(ghk);
	}

	public void logoutGHK(String tdzh) {
		// TODO Auto-generated method stub
		GHK ghk = new GHK();
		ghk.setTdzh(tdzh);
		List ghkList = ghkDAO.getGHK(ghk);
		if (ghkList.size() > 0) {
			ghk = (GHK) ghkList.get(0);
		}
		ghk.setIslogout(1);
		ghkDAO.updateGHK(ghk);
	}

	public void updateGHK(SPB spb) {
		// TODO Auto-generated method stub
		String qlr;
		String dwxz;
		String txdz;
		String sfzmtype;
		String sfzmnum;
		String ghkh="";
//		if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")){
//			qlr = spb.getRf1_dwmc();
//			dwxz = spb.getRf1_dwxz(); 
//			txdz = spb.getRf1_txdz(); 
//			sfzmtype = spb.getRf1_sfzmtype(); 
//			sfzmnum = spb.getRf1_sfzmnum();
//		}else{
//			qlr = spb.getRf2_dwmc();
//			dwxz = spb.getRf2_dwxz(); 
//			txdz = spb.getRf2_txdz(); 
//			sfzmtype = spb.getRf2_sfzmtype(); 
//			sfzmnum = spb.getRf2_sfzmnum();
//		}
		qlr = spb.getRf1_dwmc();
		dwxz = spb.getRf1_dwxz();
		txdz = spb.getRf1_txdz();
		sfzmtype = spb.getRf1_sfzmtype();
		sfzmnum = spb.getRf1_sfzmnum();
		if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
			GHK ghk = new GHK();
			ghk.setSfzmnum(sfzmnum);
			ghk.setSfzmtype(sfzmtype);
			List ghkList = ghkDAO.getGHK(ghk);
			if (ghkList.size() > 0) {
				ghk = (GHK) ghkList.get(0);
				ghkh = ghk.getGhkh();
			} else {
				ghkh = bhService.getGHKBH();
			}
		}else{
			ghkh = bhService.getGHKBH();
		}
		GHK ghkResult=getGHK(spb.getProjectId());
		ghkResult.setGhkh(ghkh);
		ghkResult.setQlr(qlr);
		ghkResult.setSfzmnum(sfzmnum);
		ghkResult.setDwxz(dwxz);
		ghkResult.setTxdz(txdz);
		ghkResult.setSfzmtype(sfzmtype);
		ghkResult.setProjectId(spb.getProjectId());
		ghkResult.setDjh(spb.getDjh());
		ghkResult.setTh(spb.getTh());
		ghkResult.setZl(spb.getZl());
		ghkResult.setQsxz(spb.getQsxz());
		ghkResult.setYt(spb.getYt());
        //zdd 2011-5-25 集体土地所有权面积为宗地面积		
		if (spb.getQsxz()!=null && spb.getQsxz().indexOf("集体土地所有权")>-1){
			if (spb.getZdmj()!=null && !spb.getZdmj().equals(""))
				ghkResult.setMj(Double.valueOf(spb.getZdmj()));
		}else{
			if (spb.getSyqmj()!=null && spb.getSyqmj() != 0){
				ghkResult.setMj(spb.getSyqmj());
			}else if (spb.getZdmj()!=null && !spb.getZdmj().equals("")){
				ghkResult.setMj(Double.valueOf(spb.getZdmj()));
			}
			
		}
		
		ghkResult.setJbr(spb.getScr());
		
		// ghkResult.setGhkh(ghkh);
		ghkResult.setIslogout(0);
		ghkResult.setDwdm(spb.getDwdm());
		ghkResult.setTdzh(spb.getTdzh());
		ghkResult.setSyqlx(spb.getSyqlx());
		String rq;
		if (spb.getPzrq() != null){
			rq = CommonUtil.formateDate(spb.getPzrq());
		}
		else if(spb.getShrq() != null){
			rq =CommonUtil.formateDate(spb.getShrq());
		}
		else {
			rq =CommonUtil.getCurrStrDate();
		}
		ghkResult.setRq(rq);
		ghkDAO.updateGHK(ghkResult);
	}

	public GHK getGHKBySPB(SPB spb) {
		String qlr;
		String dwxz;
		String txdz;
		String sfzmtype;
		String sfzmnum;
		String ghkh;
		
//		if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")) {
//			qlr = spb.getRf1_dwmc();
//			dwxz = spb.getRf1_dwxz();
//			txdz = spb.getRf1_txdz();
//			sfzmtype = spb.getRf1_sfzmtype();
//			sfzmnum = spb.getRf1_sfzmnum();
//		} else {
//			qlr = spb.getRf2_dwmc();
//			dwxz = spb.getRf2_dwxz();
//			txdz = spb.getRf2_txdz();
//			sfzmtype = spb.getRf2_sfzmtype();
//			sfzmnum = spb.getRf2_sfzmnum();
//		}
		qlr = spb.getRf1_dwmc();
		dwxz = spb.getRf1_dwxz();
		txdz = spb.getRf1_txdz();
		sfzmtype = spb.getRf1_sfzmtype();
		sfzmnum = spb.getRf1_sfzmnum();
		// 生成归户卡号
		// 已有归户卡则取原卡号，否则新生成。若Sfzm为空则也新生成一个

		if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
			GHK ghk = new GHK();
			ghk.setSfzmnum(sfzmnum);
			ghk.setSfzmtype(sfzmtype);
			List ghkList = ghkDAO.getGHK(ghk);
			if (ghkList.size() > 0) {
				GHK ghkResult = (GHK) ghkList.get(0);
				ghkh = ghkResult.getGhkh();
			} else {
				ghkh = bhService.getGHKBH();
			}
		} else {
			ghkh = bhService.getGHKBH();
		}
		GHK newGHK = new GHK();
		newGHK.setQlr(qlr);
		newGHK.setSfzmnum(sfzmnum);
		newGHK.setDwxz(dwxz);
		newGHK.setTxdz(txdz);
		newGHK.setSfzmtype(sfzmtype);
		newGHK.setProjectId(spb.getProjectId());
		newGHK.setDjh(spb.getDjh());
		newGHK.setTh(spb.getTh());
		newGHK.setZl(spb.getZl());
		newGHK.setQsxz(spb.getQsxz());
		newGHK.setYt(spb.getYt());
        //zdd 2011-5-25 集体土地所有权面积为宗地面积
		
		if (spb.getQsxz()!=null && spb.getQsxz().indexOf("集体土地所有权")>-1){
			if (spb.getZdmj()!=null && !spb.getZdmj().equals(""))
				newGHK.setMj(Double.valueOf(spb.getZdmj()));
		}else{
			if (spb.getSyqmj()!=null && spb.getSyqmj() != 0){
				newGHK.setMj(spb.getSyqmj());
			}else if (spb.getZdmj()!=null && !spb.getZdmj().equals("")){
				newGHK.setMj(Double.valueOf(spb.getZdmj()));
			}			
		}
		
		newGHK.setJbr(spb.getJbr());
		
		//newGHK.setJbr(spb.getScr());
		newGHK.setGhkh(ghkh);
		newGHK.setIslogout(0);
		newGHK.setDwdm(spb.getDwdm());
		newGHK.setTdzh(spb.getTdzh());
		newGHK.setSyqlx(spb.getSyqlx());
		String rq;
		if (spb.getPzrq() != null) {
			rq = CommonUtil.formateDate(spb.getPzrq());
		} else if (spb.getShrq() != null) {
			rq = CommonUtil.formateDate(spb.getShrq());
		} else {
			rq = CommonUtil.getCurrStrDate();
		}
		newGHK.setRq(rq);
		return newGHK;
	}

	public void insertGHK(SQB sqb) {
		// TODO Auto-generated method stub
		String ghkh;
//		String qlr = sqb.getRf2_dwmc();
//		String dwxz = sqb.getRf2_dwxz();
//		String txdz = sqb.getRf2_txdz();
//		String sfzmtype = sqb.getRf2_sfzmtype();
//		String sfzmnum = sqb.getRf2_sfzmnum();
		String qlr = sqb.getRf1_dwmc();
		String dwxz = sqb.getRf1_dwxz();
		String txdz = sqb.getRf1_txdz();
		String sfzmtype = sqb.getRf1_sfzmtype();
		String sfzmnum = sqb.getRf1_sfzmnum();
		// 生成归户卡号
		// 已有归户卡则取原卡号，否则新生成。若Sfzm为空则也新生成一个

		if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
			GHK ghk = new GHK();
			ghk.setSfzmnum(sfzmnum);
			ghk.setSfzmtype(sfzmtype);
			List ghkList = ghkDAO.getGHK(ghk);
			if (ghkList.size() > 0) {
				GHK ghkResult = (GHK) ghkList.get(0);
				ghkh = ghkResult.getGhkh();
			} else {
				ghkh = bhService.getGHKBH();
			}
		} else {
			ghkh = bhService.getGHKBH();
		}
		GHK newGHK = new GHK();
		newGHK.setQlr(qlr);
		newGHK.setSfzmnum(sfzmnum);
		newGHK.setDwxz(dwxz);
		newGHK.setTxdz(txdz);
		newGHK.setSfzmtype(sfzmtype);
		newGHK.setProjectId(sqb.getProjectId());
		newGHK.setDjh(sqb.getDjh());
		newGHK.setTh(sqb.getTh());
		newGHK.setZl(sqb.getZl());
		newGHK.setQsxz(sqb.getQsxz());
		newGHK.setYt(sqb.getYt());
		newGHK.setMj(sqb.getSyqmj());
		//newGHK.setJbr(sqb.getSjr());
		newGHK.setGhkh(ghkh);
		newGHK.setIslogout(0);
		newGHK.setDwdm(sqb.getDwdm());
		newGHK.setTdzh(sqb.getSqsbh());
		newGHK.setSyqlx(sqb.getSyqlx());
		newGHK.setRq(CommonUtil.getCurrStrDate());
		ghkDAO.insertGHK(newGHK);
	}

	public void updateGHK(SQB sqb) {
		// TODO Auto-generated method stub
//		String qlr = sqb.getRf2_dwmc();
//		String dwxz = sqb.getRf2_dwxz();
//		String txdz = sqb.getRf2_txdz();
//		String sfzmtype = sqb.getRf2_sfzmtype();
//		String sfzmnum = sqb.getRf2_sfzmnum();
		String qlr = sqb.getRf1_dwmc();
		String dwxz = sqb.getRf1_dwxz();
		String txdz = sqb.getRf1_txdz();
		String sfzmtype = sqb.getRf1_sfzmtype();
		String sfzmnum = sqb.getRf1_sfzmnum();
		String ghkh = "";
		if (!sfzmtype.equals("") && !sfzmnum.equals("")) {
			GHK ghk = new GHK();
			ghk.setSfzmnum(sfzmnum);
			ghk.setSfzmtype(sfzmtype);
			List ghkList = ghkDAO.getGHK(ghk);
			if (ghkList.size() > 0) {
				ghk = (GHK) ghkList.get(0);
				ghkh = ghk.getGhkh();
			} else {
				ghkh = bhService.getGHKBH();
			}
		}else{
			ghkh = bhService.getGHKBH();
		}
		GHK ghkResult=getGHK(sqb.getProjectId());
		ghkResult.setGhkh(ghkh);
		ghkResult.setQlr(qlr);
		ghkResult.setSfzmnum(sfzmnum);
		ghkResult.setDwxz(dwxz);
		ghkResult.setTxdz(txdz);
		ghkResult.setSfzmtype(sfzmtype);
		ghkResult.setProjectId(sqb.getProjectId());
		ghkResult.setDjh(sqb.getDjh());
		ghkResult.setTh(sqb.getTh());
		ghkResult.setZl(sqb.getZl());
		ghkResult.setQsxz(sqb.getQsxz());
		ghkResult.setYt(sqb.getYt());
		ghkResult.setMj(sqb.getSyqmj());
		//ghkResult.setJbr(sqb.getSjr());
		ghkResult.setIslogout(0);
		ghkResult.setDwdm(sqb.getDwdm());
		ghkResult.setTdzh(sqb.getSqsbh());
		ghkResult.setSyqlx(sqb.getSyqlx());
		ghkResult.setRq(CommonUtil.getCurrStrDate());
		ghkDAO.updateGHK(ghkResult);
	}

	public GHK getGHKByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		GHK ghk = new GHK();
		ghk.setTdzh(tdzh);
		List ghkList = ghkDAO.getGHK(ghk);
		if (ghkList.size()>0){
			return (GHK) ghkList.get(0);
		}else{
			return null;
		}
	}
	
}
