package com.jsegov.tddj.services;

import java.util.List;

import com.jsegov.tddj.dao.FGINFODAO;
import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.dao.SPBDAO;
import com.jsegov.tddj.dao.ZD_DJDCBDAO;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.ZD_DJDCB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FgInfoService implements IFGINFOService {
	@Autowired
    FGINFODAO fginfoDAO;
    @Autowired
    ZD_DJDCBDAO djdcbDAO;
    @Autowired
    GytdsyzDAO gytdsyzDAO;
    @Autowired
    SPBDAO spbDAO;
	
	public void deleteFGINFOByProjectID(String projectId) {
		// TODO Auto-generated method stub
		fginfoDAO.deleteFGINFOByProjectID(projectId);
	}

	public FGINFO getFGINFO(FGINFO fginfo) {
		// TODO Auto-generated method stub
		return fginfoDAO.getFGINFO(fginfo);
	}

	public void insertFGINFO(FGINFO fginfo) {
		// TODO Auto-generated method stub
		fginfoDAO.insertFGINFO(fginfo);
	}

	public void updateFGINFO(FGINFO fginfo) {
		// TODO Auto-generated method stub
		fginfoDAO.updateFGINFO(fginfo);
	}

	public void insertFGINFO(Project project) {
		// TODO Auto-generated method stub
		FGINFO fginfo = new FGINFO();
		//projectid, fgtype, ztdzh, djh,zl,  
		//zdmj, zjzmj, th, syqlx, yt, zzrq, fddbr, dwxz, lxdh, txdz
		fginfo.setProjectId(project.getProjectId());
		fginfo.setFgtype(project.getSqlx());
		fginfo.setZtdzh(project.getTdzh());
		fginfo.setDjh(project.getDjh());
		fginfo.setZl(project.getTdzl());
		fginfo.setQlr(project.getQlr());
		//读取证书的信息

		if (!project.getTdzh().equals("")){
			GYTDSYZ gytdsyz = new GYTDSYZ();
			gytdsyz.setTdzh(project.getTdzh());
			gytdsyz = gytdsyzDAO.getGytdsyz(gytdsyz);
			SPB spb = null;
			if (gytdsyz != null){
				spb = spbDAO.getSPB(gytdsyz.getProjectId());
			}
			String zdmj = "";
			if (spb == null && gytdsyz != null){
				//拷贝证书数据
				if (gytdsyz.getSyqmj()!=null)zdmj=gytdsyz.getSyqmj().toString();
				fginfo.setZdmj(zdmj);
				fginfo.setTh(gytdsyz.getTh());
				fginfo.setSyqlx(gytdsyz.getSyqlx());
				fginfo.setYt(gytdsyz.getYt());
				fginfo.setZzrq(gytdsyz.getZzrq());
			}else if(spb != null){
				//拷贝审批表数据

				if (spb.getSyqmj()!=null)zdmj=spb.getSyqmj().toString();
				fginfo.setZdmj(zdmj);
				fginfo.setTh(spb.getTh());
				fginfo.setSyqlx(spb.getSyqlx());
				fginfo.setYt(spb.getYt());
				fginfo.setZzrq(spb.getZzrq());
				if (spb.getRf2_dwmc().equals("") || spb.getRf2_dwmc() == null){
					fginfo.setFddbr(spb.getRf1_fddbr());
					fginfo.setDwxz(spb.getRf1_dwxz());
					fginfo.setLxdh(spb.getRf1_lxdh());
					fginfo.setTxdz(spb.getRf1_txdz());
				}else{
					fginfo.setFddbr(spb.getRf2_fddbr());
					fginfo.setDwxz(spb.getRf2_dwxz());
					fginfo.setLxdh(spb.getRf2_lxdh());
					fginfo.setTxdz(spb.getRf2_txdz());
				}
			}
		}
		//读取调查表的信息
		if (!project.getDjh().equals("") && !project.getQlr().equals("")){
			ZD_DJDCB djdcb = new ZD_DJDCB();
			djdcb.setDjh(project.getDjh());
			//djdcb.setQlrmc(project.getQlr());
			List djdcbList = djdcbDAO.getDjdcb(djdcb);
			if (djdcbList.size()>0){
				djdcb = (ZD_DJDCB)djdcbList.get(0);
				//zdmj, zjzmj, th, syqlx, yt, zzrq, fddbr, dwxz, lxdh, txdz
				if (djdcb.getFzmj()!=null && djdcb.getFzmj()>0){
					fginfo.setZdmj(djdcb.getFzmj().toString());
				}
				if (djdcb.getSztfh()!=null && !djdcb.getSztfh().equals(""))fginfo.setTh(djdcb.getSztfh());
				if (djdcb.getYt()!=null && !djdcb.getYt().equals(""))fginfo.setYt(djdcb.getYt());
				if (djdcb.getZzrq()!=null && !djdcb.getZzrq().equals(""))fginfo.setZzrq(djdcb.getZzrq());
				//if (!djdcb.ge)fginfo.setFddbr(djdcb.getFrdbxm());
				//if (fginfo.getDwxz().equals(""))fginfo.setDwxz(djdcb.getdw)
			}
		}
		fginfoDAO.insertFGINFO(fginfo);
	}

	public FGINFO getFGINFO(String projectId) {
		return fginfoDAO.getFGINFO(projectId);
	}
	
	public static void main(String[] args){
		Double d = 1.1;
		Double e = null;
		//System.out.println(e.toString());--error
		e = e==null?0.0:e;
		//System.out.println(d.toString());
		//System.out.println(e.toString());
	}
	
}
