package com.jsegov.tddj.services;

import java.util.List;

import com.jsegov.tddj.dao.DJKDAO;
import com.jsegov.tddj.dao.DJKXBDAO;
import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.SPB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DjkXbService implements IDJKXBService{
	@Autowired
    DJKXBDAO djkxbDAO;
    @Autowired
    DJKDAO djkDAO;
    @Autowired
    GHKDAO ghkDAO;
	
	public void deleteDJKXB(String projectId) {
		djkxbDAO.deleteDJKXB(projectId);
	}

	public DJKXB getDJKXB(String projectId) {
		return djkxbDAO.getDJKXB(projectId);
	}

	public void insertDJKXB(DJKXB djkxb) {
		djkxbDAO.insertDJKXB(djkxb);
	}

	public void updateDJKXB(DJKXB djkxb) {
		djkxbDAO.updateDJKXB(djkxb);
	}

	public void insertDJKXB(SPB spb) {
		// TODO Auto-generated method stub
		//抵押权初始登记？
		//System.out.println(spb.getSqlx().indexOf("初始登记"));
		if (spb.getSqlx().indexOf("初始登记")>0 || !spb.getXbnr().equals("")){
			djkxbDAO.insertDJKXB(getDjkxbBySPB(spb));
		}
	}

	public List getDJKXBList(Integer djkId) {
		return djkxbDAO.getDJKXBList(djkId);
	}

	public void updateDJKXB(SPB spb) {
		// TODO Auto-generated method stub
		if (spb.getSqlx().indexOf("初始登记")>0 || !spb.getXbnr().equals("")){
			djkxbDAO.updateDJKXB(getDjkxbBySPB(spb));
		}
	}
	
	public DJKXB getDjkxbBySPB(SPB spb){
		String djh = spb.getDjh();
		String projectId = spb.getProjectId();
		//djkid, djkbh
		DJK djk = djkDAO.getDJKByDjh(djh);
		Integer djkId = 0;
		if (djk!=null){
			djkId = djk.getDjkId();
		}
		String djkbh = "";
		if (djk!=null){
			djkbh = djk.getDjkbh();
		}
		
		//ghkh
		GHK ghk = ghkDAO.getGHK(projectId);
		String ghkh = "";
		if (ghk != null){
			ghkh = ghk.getGhkh();
		}
		//rq
		String rq = "";
		if (spb.getPzrq() != null){
			rq = CommonUtil.formateDate(spb.getPzrq());
		}
		else if(spb.getShrq() != null){
			rq =CommonUtil.formateDate(spb.getShrq());
		}
		else {
			rq =CommonUtil.getCurrStrDate();
		}
		DJKXB djkxb = new DJKXB();
		djkxb.setDjkId(djkId);
		djkxb.setDjkbh(djkbh);
		djkxb.setGhkh(ghkh);
		djkxb.setProjectId(projectId);
		djkxb.setDjh(djh);
		djkxb.setRq(rq);
		djkxb.setDjjs(spb.getXbnr());
		if ("江都市".equals(spb.getRmzf())){
			djkxb.setDjkjbr(spb.getJbr());
			djkxb.setDjkshr(spb.getScr());
		}else{
			djkxb.setDjkjbr(spb.getJbr());
			djkxb.setDjkshr(spb.getShr());
		}
		djkxb.setDjrq(rq);
		djkxb.setDwdm(spb.getDwdm());
		djkxb.setTdzh(spb.getTdzh());
		djkxb.setIslogout(0);
		djkxb.setIsprinted(0);
		djkxb.setBsm(spb.getBsm());
		djkxb.setSqlx(spb.getSqlx());
		return djkxb;
	}

	public List getDJKXBList(String djh) {
		// TODO Auto-generated method stub
		return djkxbDAO.getDJKXBList(djh);
	}

	public List getDJKXBList(String djh, String tdzh) {
		// TODO Auto-generated method stub
		return djkxbDAO.getDJKXBList(djh, tdzh);
	}
}
