package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.DJKDAO;
import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IZDDZBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.ZDDZB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class DjkService implements IDJKService {
    @Autowired
    DJKDAO djkDAO;
    @Autowired
    IBHService bhService;
    @Autowired
    GHKDAO ghkDAO;


    public void deleteDJK(String projectId) {
        djkDAO.deleteDJK(projectId);
    }

    public DJK getDJK(String projectId) {
        return djkDAO.getDJK(projectId);
    }

    public void insertDJK(DJK djk) {
        djkDAO.insertDJK(djk);
    }

    public void updateDJK(DJK djk) {
        djkDAO.updateDJK(djk);
    }
    /*
    通过新地号插入登记卡
     */
    public void insertDJK(SPB spb) {
        // TODO Auto-generated method stub
        String djh = spb.getDjh();
        DJK djk = djkDAO.getDJKByDjh(djh);
        if (djk == null) {
            djk = new DJK();
            String qlr = "";
            String dwxz = "";
            String sfzmtype = "";
            String sfzmnum = "";
            String txdz = "";
            /*if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")){
                   qlr = spb.getRf1_dwmc();
                   dwxz = spb.getRf1_dwxz();
                   txdz = spb.getRf1_txdz();
                   sfzmtype = spb.getRf1_sfzmtype();
                   sfzmnum = spb.getRf1_sfzmnum();
               }else{
                   qlr = spb.getRf2_dwmc();
                   dwxz = spb.getRf2_dwxz();
                   txdz = spb.getRf2_txdz();
                   sfzmtype = spb.getRf2_sfzmtype();
                   sfzmnum = spb.getRf2_sfzmnum();
               }*/
            if(spb.getSqlx().indexOf("抵押")>-1 || spb.getSqlx().indexOf("地役")>-1 || spb.getSqlx().indexOf("租赁")>-1){
                qlr = spb.getRf2_dwmc();
            }else {
                qlr = spb.getRf1_dwmc();
            }
            dwxz = spb.getRf1_dwxz();
            txdz = spb.getRf1_txdz();
            sfzmtype = spb.getRf1_sfzmtype();
            sfzmnum = spb.getRf1_sfzmnum();
            //qlr, dwxz,txdz,sfzmtype, sfzmnum,
            djk.setYb(spb.getRf1_yb());
            djk.setSyqx(spb.getSyqx());
            djk.setSyqmj(spb.getSyqmj());
            djk.setDymj(spb.getDymj());
            djk.setFtmj(spb.getFtmj());

            djk.setQlr(qlr);
            djk.setSfzmnum(sfzmnum);
            djk.setDwxz(dwxz);
            djk.setTxdz(txdz);
            djk.setSfzmtype(sfzmtype);
            //projectid, djh, th, zdmj, yt, zl, qsxz,
            djk.setProjectId(spb.getProjectId());
            djk.setDjh(spb.getDjh());
            djk.setTh(spb.getTh());
            djk.setZdmj(spb.getZdmj());
            djk.setYt(spb.getYt());
            djk.setZl(spb.getZl());
            djk.setQsxz(spb.getQsxz());
            //syqlx, zzrq, tdzh, dcbh, spbh, tddj, bddj, jzrjl,
            djk.setSyqlx(spb.getSyqlx());
            djk.setZzrq(spb.getZzrq());
            djk.setTdzh(spb.getTdzh());
            djk.setDcbh(spb.getDcbh());
            djk.setSpbh(spb.getSpbh());
            //djk.setTddj(spb.getTddj());
            //djk.setBddj(spb.getBddj());
            djk.setJzrjl(spb.getJzrjl());
            //ghkh,djkbh
            if (!spb.getSqlx().equals("按幢分割") && !spb.getSqlx().equals("按整宗分割")) {
                String ghkh = "";
                GHK ghk = new GHK();
                ghk.setSfzmnum(sfzmnum);
                ghk.setSfzmtype(sfzmtype);
                List ghkList = ghkDAO.getGHK(ghk);
                if (ghkList.size() > 0) {
                    ghk = (GHK) ghkList.get(0);
                    ghkh = ghk.getGhkh();
                }
                djk.setGhkh(ghkh);
            }
            djk.setDjkbh(bhService.getDJKBH());
            //jzmd, jzxg, jzwzdmj, jzwlx, sbjzwqs, qsly, islogout,
            djk.setJzmd(spb.getJzmd());
            djk.setJzxg(spb.getJzxg());
            djk.setJzwzdmj(spb.getJzwzdmj());
            djk.setJzwlx(spb.getJzwlx());
            djk.setSbjzwqs(spb.getSbjzwqs());
            djk.setQsly(spb.getQsly());
            djk.setIslogout(0);
            //dwdm, djrq, ,qdjg
            djk.setDwdm(spb.getDwdm());
            String rq;
            if (spb.getPzrq() != null) {
                rq = CommonUtil.formateDate(spb.getPzrq());
            } else if (spb.getShrq() != null) {
                rq = CommonUtil.formateDate(spb.getShrq());
            } else {
                rq = CommonUtil.getCurrStrDate();
            }
            djk.setDjrq(rq);
            djk.setQdjg(spb.getQdjg());
            djkDAO.insertDJK(djk);
        }
    }

    /*
    通过老地号插入登记卡
     */
    public void insertDjk(SPB spb) {
        // TODO Auto-generated method stub
        String oldDjh = spb.getDjh();
        DJK djk = djkDAO.getDJKByOldDjh(oldDjh);
        if (djk == null) {
            djk = new DJK();
            String qlr = "";
            String dwxz = "";
            String sfzmtype = "";
            String sfzmnum = "";
            String txdz = "";
            /*if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")){
                   qlr = spb.getRf1_dwmc();
                   dwxz = spb.getRf1_dwxz();
                   txdz = spb.getRf1_txdz();
                   sfzmtype = spb.getRf1_sfzmtype();
                   sfzmnum = spb.getRf1_sfzmnum();
               }else{
                   qlr = spb.getRf2_dwmc();
                   dwxz = spb.getRf2_dwxz();
                   txdz = spb.getRf2_txdz();
                   sfzmtype = spb.getRf2_sfzmtype();
                   sfzmnum = spb.getRf2_sfzmnum();
               }*/
            if(spb.getSqlx().indexOf("抵押")>-1 || spb.getSqlx().indexOf("地役")>-1 || spb.getSqlx().indexOf("租赁")>-1){
                qlr = spb.getRf2_dwmc();
            }else {
                qlr = spb.getRf1_dwmc();
            }
            dwxz = spb.getRf1_dwxz();
            txdz = spb.getRf1_txdz();
            sfzmtype = spb.getRf1_sfzmtype();
            sfzmnum = spb.getRf1_sfzmnum();
            //qlr, dwxz,txdz,sfzmtype, sfzmnum,
            djk.setYb(spb.getRf1_yb());
            djk.setSyqx(spb.getSyqx());
            djk.setSyqmj(spb.getSyqmj());
            djk.setDymj(spb.getDymj());
            djk.setFtmj(spb.getFtmj());

            djk.setQlr(qlr);
            djk.setSfzmnum(sfzmnum);
            djk.setDwxz(dwxz);
            djk.setTxdz(txdz);
            djk.setSfzmtype(sfzmtype);
            //projectid, djh, th, zdmj, yt, zl, qsxz,
            djk.setProjectId(spb.getProjectId());
            djk.setDjh(spb.getDjh());
            djk.setOlddjh(spb.getDjh());
            djk.setTh(spb.getTh());
            djk.setZdmj(spb.getZdmj());
            djk.setYt(spb.getYt());
            djk.setZl(spb.getZl());
            djk.setQsxz(spb.getQsxz());
            //syqlx, zzrq, tdzh, dcbh, spbh, tddj, bddj, jzrjl,
            djk.setSyqlx(spb.getSyqlx());
            djk.setZzrq(spb.getZzrq());
            djk.setTdzh(spb.getTdzh());
            djk.setDcbh(spb.getDcbh());
            djk.setSpbh(spb.getSpbh());
            //djk.setTddj(spb.getTddj());
            //djk.setBddj(spb.getBddj());
            djk.setJzrjl(spb.getJzrjl());
            //ghkh,djkbh
            if (!spb.getSqlx().equals("按幢分割") && !spb.getSqlx().equals("按整宗分割")) {
                String ghkh = "";
                GHK ghk = new GHK();
                ghk.setSfzmnum(sfzmnum);
                ghk.setSfzmtype(sfzmtype);
                List ghkList = ghkDAO.getGHK(ghk);
                if (ghkList.size() > 0) {
                    ghk = (GHK) ghkList.get(0);
                    ghkh = ghk.getGhkh();
                }
                djk.setGhkh(ghkh);
            }
            djk.setDjkbh(bhService.getDJKBH());
            //jzmd, jzxg, jzwzdmj, jzwlx, sbjzwqs, qsly, islogout,
            djk.setJzmd(spb.getJzmd());
            djk.setJzxg(spb.getJzxg());
            djk.setJzwzdmj(spb.getJzwzdmj());
            djk.setJzwlx(spb.getJzwlx());
            djk.setSbjzwqs(spb.getSbjzwqs());
            djk.setQsly(spb.getQsly());
            djk.setIslogout(0);
            //dwdm, djrq, ,qdjg
            djk.setDwdm(spb.getDwdm());
            String rq;
            if (spb.getPzrq() != null) {
                rq = CommonUtil.formateDate(spb.getPzrq());
            } else if (spb.getShrq() != null) {
                rq = CommonUtil.formateDate(spb.getShrq());
            } else {
                rq = CommonUtil.getCurrStrDate();
            }
            djk.setDjrq(rq);
            djk.setQdjg(spb.getQdjg());
            djkDAO.insertDJK(djk);
        }
    }
    public DJK getDJKByDjh(String djh) {
        // TODO Auto-generated method stub
        return djkDAO.getDJKByDjh(djh);
    }

    @Override
    public DJK getDJKByOldDjh(String olddjh) {
        return djkDAO.getDJKByOldDjh(olddjh);  //To change body of implemented methods use File | Settings | File Templates.
    }

    /*
    通过新地号更新登记卡
     */
    public void updateDJK(SPB spb) {
        // TODO Auto-generated method stub
        String djh = spb.getDjh();
        DJK djk = djkDAO.getDJKByDjh(djh);
        //if (djk == null){
        //djk = new DJK();
        String qlr = "";
        String dwxz = "";
        String sfzmtype = "";
        String sfzmnum = "";
        String txdz = "";
        /*if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")){
              qlr = spb.getRf1_dwmc();
              dwxz = spb.getRf1_dwxz();
              txdz = spb.getRf1_txdz();
              sfzmtype = spb.getRf1_sfzmtype();
              sfzmnum = spb.getRf1_sfzmnum();
          }else{
              qlr = spb.getRf2_dwmc();
              dwxz = spb.getRf2_dwxz();
              txdz = spb.getRf2_txdz();
              sfzmtype = spb.getRf2_sfzmtype();
              sfzmnum = spb.getRf2_sfzmnum();
          }*/
        if(spb.getSqlx().indexOf("抵押")>-1 || spb.getSqlx().indexOf("地役")>-1 || spb.getSqlx().indexOf("租赁")>-1){
            qlr = spb.getRf2_dwmc();
        }else {
            qlr = spb.getRf1_dwmc();
        }
        dwxz = spb.getRf1_dwxz();
        txdz = spb.getRf1_txdz();
        sfzmtype = spb.getRf1_sfzmtype();
        sfzmnum = spb.getRf1_sfzmnum();
        //System.out.println(sfzmtype+"---------"+spb.getRf1_sfzmtype());
        //	System.out.println(sfzmnum+"---------"+spb.getRf1_sfzmnum());
        //System.out.println("---------"+djk.getDjh());
        //qlr, dwxz,txdz,sfzmtype, sfzmnum,
        djk.setYb(spb.getRf1_yb());
        djk.setSyqx(spb.getSyqx());
        djk.setSyqmj(spb.getSyqmj());
        djk.setDymj(spb.getDymj());
        djk.setFtmj(spb.getFtmj());
        djk.setQlr(qlr);
        djk.setSfzmnum(sfzmnum);
        djk.setDwxz(dwxz);
        djk.setTxdz(txdz);
        djk.setSfzmtype(sfzmtype);
        //projectid, djh, th, zdmj, yt, zl, qsxz,
        djk.setProjectId(spb.getProjectId());
        djk.setDjh(spb.getDjh());
        djk.setTh(spb.getTh());
        djk.setZdmj(spb.getZdmj());
        djk.setYt(spb.getYt());
        djk.setZl(spb.getZl());
        djk.setQsxz(spb.getQsxz());
        //syqlx, zzrq, tdzh, dcbh, spbh, tddj, bddj, jzrjl,
        djk.setSyqlx(spb.getSyqlx());
        djk.setZzrq(spb.getZzrq());
        djk.setTdzh(spb.getTdzh());
        djk.setDcbh(spb.getDcbh());
        djk.setSpbh(spb.getSpbh());
        //djk.setTddj(spb.getTddj());
        //djk.setBddj(spb.getBddj());
        djk.setJzrjl(spb.getJzrjl());
        //ghkh,djkbh
        String ghkh = "";
        GHK ghk = new GHK();
        ghk.setSfzmnum(sfzmnum);
        ghk.setSfzmtype(sfzmtype);
        List ghkList = ghkDAO.getGHK(ghk);
        if (ghkList.size() > 0) {
            ghk = (GHK) ghkList.get(0);
            ghkh = ghk.getGhkh();
        }
        djk.setGhkh(ghkh);
        //djk.setDjkbh(bhService.getDJKBH());
        //jzmd, jzxg, jzwzdmj, jzwlx, sbjzwqs, qsly, islogout,
        djk.setJzmd(spb.getJzmd());
        djk.setJzxg(spb.getJzxg());
        djk.setJzwzdmj(spb.getJzwzdmj());
        djk.setJzwlx(spb.getJzwlx());
        djk.setSbjzwqs(spb.getSbjzwqs());
        djk.setQsly(spb.getQsly());
        djk.setIslogout(0);
        //dwdm, djrq, ,qdjg
        djk.setDwdm(spb.getDwdm());
        String rq;
        if (spb.getPzrq() != null) {
            rq = CommonUtil.formateDate(spb.getPzrq());
        } else if (spb.getShrq() != null) {
            rq = CommonUtil.formateDate(spb.getShrq());
        } else {
            rq = CommonUtil.getCurrStrDate();
        }
        djk.setDjrq(rq);
        djk.setQdjg(spb.getQdjg());
        djkDAO.updateDJK(djk);
        //}
    }
    /*
   通过老地号更新登记卡
     */
    public void updateDjk(SPB spb) {
        // TODO Auto-generated method stub
        String oldDjh  = spb.getDjh();
        DJK djk = djkDAO.getDJKByOldDjh(oldDjh);
        //if (djk == null){
        //djk = new DJK();
        String qlr = "";
        String dwxz = "";
        String sfzmtype = "";
        String sfzmnum = "";
        String txdz = "";
        /*if (spb.getRf2_dwmc() == null || spb.getRf2_dwmc().equals("")){
              qlr = spb.getRf1_dwmc();
              dwxz = spb.getRf1_dwxz();
              txdz = spb.getRf1_txdz();
              sfzmtype = spb.getRf1_sfzmtype();
              sfzmnum = spb.getRf1_sfzmnum();
          }else{
              qlr = spb.getRf2_dwmc();
              dwxz = spb.getRf2_dwxz();
              txdz = spb.getRf2_txdz();
              sfzmtype = spb.getRf2_sfzmtype();
              sfzmnum = spb.getRf2_sfzmnum();
          }*/
        if(spb.getSqlx().indexOf("抵押")>-1 || spb.getSqlx().indexOf("地役")>-1 || spb.getSqlx().indexOf("租赁")>-1){
            qlr = spb.getRf2_dwmc();
        }else {
            qlr = spb.getRf1_dwmc();
        }
        dwxz = spb.getRf1_dwxz();
        txdz = spb.getRf1_txdz();
        sfzmtype = spb.getRf1_sfzmtype();
        sfzmnum = spb.getRf1_sfzmnum();
        //System.out.println(sfzmtype+"---------"+spb.getRf1_sfzmtype());
        //	System.out.println(sfzmnum+"---------"+spb.getRf1_sfzmnum());
        //System.out.println("---------"+djk.getDjh());
        //qlr, dwxz,txdz,sfzmtype, sfzmnum,
        djk.setYb(spb.getRf1_yb());
        djk.setSyqx(spb.getSyqx());
        djk.setSyqmj(spb.getSyqmj());
        djk.setDymj(spb.getDymj());
        djk.setFtmj(spb.getFtmj());
        djk.setQlr(qlr);
        djk.setSfzmnum(sfzmnum);
        djk.setDwxz(dwxz);
        djk.setTxdz(txdz);
        djk.setSfzmtype(sfzmtype);
        //projectid, djh, th, zdmj, yt, zl, qsxz,
        djk.setProjectId(spb.getProjectId());
        //djk.setDjh(spb.getDjh());
        djk.setTh(spb.getTh());
        djk.setZdmj(spb.getZdmj());
        djk.setYt(spb.getYt());
        djk.setZl(spb.getZl());
        djk.setQsxz(spb.getQsxz());
        //syqlx, zzrq, tdzh, dcbh, spbh, tddj, bddj, jzrjl,
        djk.setSyqlx(spb.getSyqlx());
        djk.setZzrq(spb.getZzrq());
        djk.setTdzh(spb.getTdzh());
        djk.setDcbh(spb.getDcbh());
        djk.setSpbh(spb.getSpbh());
        //djk.setTddj(spb.getTddj());
        //djk.setBddj(spb.getBddj());
        djk.setJzrjl(spb.getJzrjl());
        //ghkh,djkbh
        String ghkh = "";
        GHK ghk = new GHK();
        ghk.setSfzmnum(sfzmnum);
        ghk.setSfzmtype(sfzmtype);
        List ghkList = ghkDAO.getGHK(ghk);
        if (ghkList.size() > 0) {
            ghk = (GHK) ghkList.get(0);
            ghkh = ghk.getGhkh();
        }
        djk.setGhkh(ghkh);
        //djk.setDjkbh(bhService.getDJKBH());
        //jzmd, jzxg, jzwzdmj, jzwlx, sbjzwqs, qsly, islogout,
        djk.setJzmd(spb.getJzmd());
        djk.setJzxg(spb.getJzxg());
        djk.setJzwzdmj(spb.getJzwzdmj());
        djk.setJzwlx(spb.getJzwlx());
        djk.setSbjzwqs(spb.getSbjzwqs());
        djk.setQsly(spb.getQsly());
        djk.setIslogout(0);
        //dwdm, djrq, ,qdjg
        djk.setDwdm(spb.getDwdm());
        String rq;
        if (spb.getPzrq() != null) {
            rq = CommonUtil.formateDate(spb.getPzrq());
        } else if (spb.getShrq() != null) {
            rq = CommonUtil.formateDate(spb.getShrq());
        } else {
            rq = CommonUtil.getCurrStrDate();
        }
        djk.setDjrq(rq);
        djk.setQdjg(spb.getQdjg());
        djkDAO.updateDJK(djk);
        //}
    }
    public DJK getDJKByTdzh(String tdzh) {
        // TODO Auto-generated method stub
        return djkDAO.getDJKByTdzh(tdzh);
    }

    public List<Object> getDjkListForBatchPrint(HashMap<String, Object> map) {
        // TODO Auto-generated method stub
        return djkDAO.getDjkListForBatchPrint(map);
    }


    /**
     * 根据新老地号关系 更新新老的登记卡的地籍号为最新的地籍号
     *
     * @param newdjh
     */
    public void updateDjk(String newdjh) {
        IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");
        List<ZDDZB> zddzbList = zddzbService.selectAllDjh(newdjh);
        for (ZDDZB zddzb : zddzbList) {
            DJK djk = getDJKByDjh(zddzb.getDh());
            if (djk != null) {
                djk.setDjh(newdjh);
                updateDJK(djk);
                //理论上不会存在多条记录 跳出是防止如果确实存在一系列新老地籍号下存在多个登记卡后 导致更新后多条地籍号一致的数据生成
                break;
            }
        }
    }
}
