package com.jsegov.tddj.services;



import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import com.jsegov.tddj.fileUpload.DataParse;
import com.jsegov.tddj.fileUpload.DataParseResult;
import com.jsegov.tddj.services.interf.IDataImportService;


public class DataImportService implements IDataImportService{
	public final static String BGSP_WORKFLOW_BUSINESS_NO="BGJG";
	private String fileCenterUrl;
	private String serveUrl;
	private String layerName;
	private String actiontype;
	private String message;

	/**
	 * 导入数据
	 */
	public String importData(String regionCode,String zipFilePath, String uploadId,boolean bOverRide) throws Exception{
		DataParse dataImport = new DataParse(zipFilePath);
		DataParseResult dataParseResult= dataImport.parseProjZipData(regionCode);
		File zipFile = new File(zipFilePath);
		String zipName = zipFile.getName();
		String zipPath=dataImport.getDestDir();
		List<String>  needInsertPiIdList = new Vector<String>();
		Iterator piIdIter = dataParseResult.getProjInfoMap().keySet().iterator();
		while(piIdIter.hasNext()){
			needInsertPiIdList.add((String)piIdIter.next());
		}
		
		return zipPath;
	}

	
	public String getFileCenterUrl() {
		return fileCenterUrl;
	}

	public void setFileCenterUrl(String fileCenterUrl) {
		this.fileCenterUrl = fileCenterUrl;
	}

	public String getServeUrl() {
		return serveUrl;
	}

	public void setServeUrl(String serveUrl) {
		this.serveUrl = serveUrl;
	}

	public String getLayerName() {
		return layerName;
	}

	public void setLayerName(String layerName) {
		this.layerName = layerName;
	}

	public String getActiontype() {
		return actiontype;
	}

	public void setActiontype(String actiontype) {
		this.actiontype = actiontype;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	
}
