package com.jsegov.tddj.services;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IDataConversionService;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJFService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.IProRelationService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDCLService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.services.interf.IYGDJService;
import com.jsegov.tddj.services.interf.IYYDJService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.GYQDJK;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JF;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.ProRelation;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SJDCL;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TDZJS;
import com.jsegov.tddj.vo.TXQLZMS;
import com.jsegov.tddj.vo.YGDJ;
import com.jsegov.tddj.vo.YYDJ;
import org.apache.commons.lang.StringUtils;

public class DataConversionService implements IDataConversionService{
	
	private String dwdm = "";

	public String dataConvert(String dataPath) {
		// TODO Auto-generated method stub
		String returnMessage = "";
		String userId = TddjUtil.getCurrentUserId();		
		dwdm = TddjUtil.getCurrentUserDwdm();
		try {
			impDjkAndXb(dataPath);
			impCf(dataPath);
			impFginfo(dataPath);
			impFgz(dataPath);
			impGhk(dataPath);
			impGyqdjk(dataPath);
			impJf(dataPath);
			impProject(dataPath);
			impProrelation(dataPath);
			impSjd(dataPath);
			impSjdcl(dataPath);
			impTdzjs(dataPath);
			impYgdj(dataPath);
			int jttdsuzNum=impJttdsuz(dataPath);
			int jttdsyzNum=impJttdsyz(dataPath);
			int TxqlzmsNum=impTxqlzms(dataPath);
			impSqb(dataPath);
			impSpb(dataPath);			
			int gytdsyzNum=impGytdsyz(dataPath);
			returnMessage = "国有土地使用证插入"+gytdsyzNum+"本"+"、集体土地使用证插入"+jttdsyzNum+"本"+"、<br/>集体土地所有证插入"+jttdsuzNum+"本"+"、他项权利证明书插入"+TxqlzmsNum+"本";
		} catch (Exception e) {
			// TODO: handle exception
			returnMessage = "数据导入失败！";
			e.printStackTrace();
		}
		
		return returnMessage;
	}
	private Connection conn = null;
	private Connection djkxbstmtconn = null;
	private Statement stmt =null;
	private Statement djkxbstmt =null;
	
	public void impWFinstance(Project project){
		try {
			PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();	
			wfVO.setWorkflowIntanceId(project.getProjectId());			
			SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
			List<PfWorkFlowDefineVo> list = sysWorkFlowDefineService.getWorkFlowDefineList();
			int size=list.size();
			PfWorkFlowDefineVo defineVo = new PfWorkFlowDefineVo();
			for (int i = 0; i < size; i++) {
				defineVo = list.get(i);
				if(defineVo.getRemark()!=null && defineVo.getRemark().equals(project.getDjlx())){
					wfVO.setWorkflowDefinitionId(defineVo.getWorkflowDefinitionId());
					break;
				}					
			}		
			wfVO.setCreateTime(project.getBeginTime());
			wfVO.setRemark(project.getTdzl() +";"+ project.getDjh());
			if(project.getEndTime()!=null && !project.getEndTime().equals("")){
				wfVO.setWorkflowState(2);
				wfVO.setFinishTime(project.getEndTime());
			}else{
				wfVO.setWorkflowState(1);
			}
			wfVO.setProId(project.getProjectId());
			wfVO.setWorkflowIntanceName(project.getProjectName());
			if (project.getDwdm()!=null && !project.getDwdm().equals("")){
				wfVO.setRegionCode(project.getDwdm());
			}else{
				wfVO.setRegionCode(dwdm);
			}				
			//单机版就是系统管理员
			wfVO.setCreateUser("0");	
			IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
			wfVO.setTimeLimit(platUtil.getTimeLimit(wfVO.getWorkflowDefinitionId())+"");
            if(wfVO.getWorkflowIntanceId()!=null && !wfVO.getWorkflowIntanceId().equals("")){				
				SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
				PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(wfVO.getWorkflowIntanceId());
				if(wfInstanceVo==null){
					PreparedStatement ps = CommonUtil.getPfStatement("insert into pf_workflow_instance(WORKFLOW_INSTANCE_ID, " +
							"WORKFLOW_DEFINITION_ID, CREATE_TIME, REMARK, WORKFLOW_STATE, PRO_ID, " +
							"WORKFLOW_INSTANCE_NAME,TIME_LIMIT,FINISH_TIME,REGION_CODE,CREATE_USER) " +
							"values(?,?,?,?,?,?,?,?,?,?,?)");
					ps.setString(1, wfVO.getWorkflowIntanceId());
					ps.setString(2, wfVO.getWorkflowDefinitionId());
					ps.setDate(3, (Date) wfVO.getCreateTime());
					ps.setString(4, wfVO.getRemark());
					ps.setInt(5, wfVO.getWorkflowState());
					ps.setString(6, wfVO.getProId());
					ps.setString(7, wfVO.getWorkflowIntanceName());
					int timeLimit=0;
					if(StringUtils.isNotBlank(wfVO.getTimeLimit()))
						timeLimit=Integer.parseInt(wfVO.getTimeLimit());
					ps.setInt(8, timeLimit);
					ps.setDate(9, (Date) wfVO.getFinishTime());
					ps.setString(10, wfVO.getRegionCode());
					ps.setString(11, wfVO.getCreateUser());
					ps.execute();
				}				
			}else{
				System.out.println("导入平台库失败！");
			}						
		} catch (Exception e) {
			// TODO: handle exception
			System.out.println("导入平台库失败！");
			e.printStackTrace();
		}
		
	}
	//flag是为了关闭djk及djkxb的连接而创建的标志,如果没有这个标志djk的stmt就关不了
	public ResultSet excuteSQL(String sql,String path,String flag) throws SQLException{		
		ResultSet resultSet = null;		
		String url = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + path; // 数据库连接字符串
		try {
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver"); // 加载驱动程序
			if(flag!=null && flag.equals("djkxb")){
				djkxbstmtconn = DriverManager.getConnection(url); // 建立连接
				djkxbstmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_UPDATABLE); // 创建语句对象	
				resultSet = djkxbstmt.executeQuery(sql);		
			}else{
				conn = DriverManager.getConnection(url); // 建立连接
				stmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_UPDATABLE); // 创建语句对象
				resultSet = stmt.executeQuery(sql);		
			}
					
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return resultSet;
	}
	public void impYgdj(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID, TDZH  ,DJH , YGSQR , SYQMJ , ZL  , QLR ,  YGYY , YGYJ , " +
				"SHR_SIGN  , SHR , SHRQ ,ISLOGOUT from tbl_ygdj",path,"");
		try {
			if(resultSet!=null){
				YGDJ ygdj = new YGDJ();
				IYGDJService ygdjService = (IYGDJService)Container.getBean("ygdjService");
				String projectId="";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					ygdj.setProjectId(projectId);
					ygdj.setTdzh(resultSet.getString("TDZH"));
					ygdj.setDjh(resultSet.getString("DJH"));
					ygdj.setYgsqr(resultSet.getString("YGSQR"));
					ygdj.setSyqmj(resultSet.getString("SYQMJ"));
					ygdj.setZl(resultSet.getString("ZL"));
					ygdj.setQlr(resultSet.getString("QLR"));
					ygdj.setYgyy(resultSet.getString("YGYY"));
					ygdj.setYgyj(resultSet.getString("YGYJ"));
					ygdj.setShr_sign(resultSet.getString("SHR_SIGN"));
					ygdj.setShr(resultSet.getString("SHR"));
					ygdj.setShrq(resultSet.getString("SHRQ"));
					ygdj.setIslogout(resultSet.getInt("ISLOGOUT"));
					System.out.println("预告登记"+projectId);
					if(ygdjService.getYGDJ(projectId)==null){
						ygdjService.insertYGDJ(ygdj);
					}else{
						ygdjService.updateYGDJ(ygdj);
					}					
				}
				resultSet.close();
				stmt.close();
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * 
	 */
	public void impTdzjs(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select TDZJSID, PROJECTID , TDZH , JS , JSDATE from tbl_tdzjs",path,"");
		try {
			if(resultSet!=null){
				TDZJS tdzjs = new TDZJS();
				ITDZJSService tdzjsService = (ITDZJSService)Container.getBean("tdzJsService");
				String tdzjsId = "";
				while (resultSet.next()) {
					tdzjsId = resultSet.getString("TDZJSID");
					tdzjs.setTdzjsId(tdzjsId);
					tdzjs.setProjectId(resultSet.getString("PROJECTID"));
					tdzjs.setTdzh(resultSet.getString("TDZH"));
					tdzjs.setJs(resultSet.getString("JS"));
					tdzjs.setJsdate(resultSet.getString("JSDATE"));
					System.out.println("土地证记事："+tdzjsId);
					if(tdzjsService.getTDZJS(tdzjsId)==null){
					   tdzjsService.insertTDZJS(tdzjs);	
					}else{
						tdzjsService.updateTDZJS(tdzjs);
					}					
				}
				resultSet.close();
				stmt.close();
			}						
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * UPLOAD、PREVIEW 字段 单机版没有

	 */
	public void impSjdcl(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select CLID, PROJECTID, XH, ZJMC, YSFS, DBFS from tbl_sjdcl",path,"");
		try {
			SJDCL sjdcl = new SJDCL();
			ISJDCLService sjdclService = (ISJDCLService)Container.getBean("sjdClService");
			String clId="";
			while (resultSet.next()) {
				clId = resultSet.getString("CLID");
				sjdcl.setClid(clId);
				sjdcl.setProjectId(resultSet.getString("PROJECTID"));
				sjdcl.setXh(resultSet.getInt("XH"));
				sjdcl.setZjmc(resultSet.getString("ZJMC"));
				sjdcl.setYsfs(resultSet.getInt("YSFS"));
				sjdcl.setDbfs(resultSet.getInt("DBFS"));
				System.out.println("收件单材料"+clId);
				if(sjdclService.getSjdclByClId(clId)==null){
					sjdclService.insertSjdcl(sjdcl);
				}else{
					sjdclService.updateSjdcl(sjdcl);
				}
			}
			resultSet.close();
			stmt.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * sjlx登记系统没有用，所以不需要导入

	 */
	public void impSjd(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID, BH,SQLX, JJR, LXDH, ZL,SJR, SJRQ, BZ, CNQX, " +
				"DWDM, BSM, SJLX, RMZF from tbl_sjd",path,"");
		try {
			if(resultSet!=null){
				SJD sjd = new SJD();
				ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					sjd.setProjectId(projectId);
					sjd.setBh(resultSet.getString("BH"));
					sjd.setSqlx(resultSet.getString("SQLX"));
					sjd.setJjr(resultSet.getString("JJR"));
					sjd.setLxdh(resultSet.getString("LXDH"));
					sjd.setZl(resultSet.getString("ZL"));
					sjd.setSjr(resultSet.getString("SJR"));
					sjd.setSjrq(resultSet.getDate("SJRQ"));
					sjd.setBz(resultSet.getString("BZ"));
					sjd.setCnqx(resultSet.getInt("CNQX"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						sjd.setDwdm(resultSet.getString("dwdm"));
					}else{								
						sjd.setDwdm(dwdm);						
					}
					sjd.setBsm(resultSet.getInt("BSM"));
					//sjd.setSjlx();
					sjd.setRmzf(resultSet.getString("RMZF"));
					System.out.println("收件单："+projectId);
					if(sjdService.getSJD(projectId)==null){
						sjdService.insertSJD(sjd);						
					}else{
						sjdService.updateSJD(sjd);
					}					
				}
				resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * 单机版没有oldDjh
	 */
	public void impProrelation(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select RELATIONID,PROJECTID, TDZH ,QLR,FZRQ,YPROJECTID,YTDZH,YQLR ," +
				"DJLX,DJH from tbl_prorelation",path,"");
		try {
			if(resultSet!=null){
				ProRelation proRelation = new ProRelation();
				IProRelationService proRelationService = (IProRelationService)Container.getBean("proRelationService");
				String projectId = "";
				while (resultSet.next()) {
					projectId= resultSet.getString("PROJECTID");
					proRelation.setProjectId(projectId);
					proRelation.setTdzh(resultSet.getString("TDZH"));
					proRelation.setQlr(resultSet.getString("QLR"));
					proRelation.setFzrq(resultSet.getString("FZRQ"));
					proRelation.setYprojectId(resultSet.getString("YPROJECTID"));
					proRelation.setYtdzh(resultSet.getString("YTDZH"));
					proRelation.setYqlr(resultSet.getString("YQLR"));
					proRelation.setDjlx(resultSet.getString("DJLX"));
					proRelation.setDjh(resultSet.getString("DJH"));
					System.out.println("项目关系表："+projectId);
					if(proRelationService.getProRelation(projectId)==null){
						proRelationService.insertProjectRelation(proRelation);
					}else{
						proRelationService.updateProjectRelation(proRelation);
					}					
				}
				resultSet.close();
				stmt.close();
			}
			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	public void impProject(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID,PROJECTNAME  ,DJH , DJLX , CREATER , " +
				"BEGINTIME,ENDTIME ,DWDM from tbl_project",path,"");
		try {
			if (resultSet!=null){
				Project project = new Project();
				IProjectService projectService = (IProjectService)Container.getBean("projectService");
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					project.setProjectId(projectId);
					project.setProjectName(resultSet.getString("PROJECTNAME"));
					project.setDjh(resultSet.getString("DJH"));
					project.setDjlx(resultSet.getString("DJLX"));
					project.setCreater(resultSet.getString("CREATER"));
					project.setBeginTime(resultSet.getDate("BEGINTIME"));
					project.setEndTime(resultSet.getDate("ENDTIME"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						project.setDwdm(resultSet.getString("dwdm"));
					}else{								
						project.setDwdm(dwdm);						
					}
					System.out.println("项目表："+projectId);
					if (projectService.getProject(projectId)==null){
						projectService.insertProject(project);
						//zdd 不提供更新

						impWFinstance(project);
					}else{
						projectService.updateProject(project);						
					}
				}
				resultSet.close();
				stmt.close();				
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * 单机版没有XBNR
	 */	
	public void impJf(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID, CFPROJECTID ,JFYY ,JFR ,JFRQ  from tbl_jf",path,"");
		try {
			if(resultSet!=null){
				JF jf = new JF();
				IJFService jfService = (IJFService)Container.getBean("jfService");
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					jf.setProjectId(projectId);
					jf.setCfProjectId(resultSet.getString("CFPROJECTID"));
					jf.setJfyy(resultSet.getString("JFYY"));
					jf.setJfr(resultSet.getString("JFR"));
					jf.setJfrq(resultSet.getString("JFRQ"));	
					System.out.println("解封："+projectId);
					if (jfService.getJF(projectId)==null){
						jfService.insertJF(jf);
					}else{
						jfService.updateJF(jf);
					}
				}	
				resultSet.close();
				stmt.close();
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * RQ,SFZMTYPE ,SFZMNUM,QDJG ,ZDMJ ,TDQLMJ , OLDDJH 单机版没有以上几个字段

	 */
	public void impGyqdjk(String path)throws SQLException{
		ResultSet resultSet =excuteSQL("select GYQDJKID ,PROJECTID,DJH,QLR ,DWXZ , YT ,JZWLX ,JZWZDMJ," +
				"SBJZWQS, SPBH ,GHKH ,TDZH, JBR ,SHR ,ISLOGOUT, DWDM ,DYMJ ,FTMJ ,ZL from tbl_gyqdjk",path,"");
		try {
			if(resultSet!=null){
				GYQDJK gyqdjk = new GYQDJK();
				IGYQDJKService gyqdjkService = (IGYQDJKService)Container.getBean("GyqDjkService");
				String projectId="";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					gyqdjk.setProjectId(projectId);
					gyqdjk.setDjh(resultSet.getString("DJH"));
					gyqdjk.setQlr(resultSet.getString("QLR"));
					gyqdjk.setDwxz(resultSet.getString("DWXZ"));
					gyqdjk.setYt(resultSet.getString("YT"));
					gyqdjk.setJzwlx(resultSet.getString("JZWLX"));
					gyqdjk.setJzwzdmj(resultSet.getDouble("JZWZDMJ"));
					gyqdjk.setSbjzwqs(resultSet.getString("SBJZWQS"));
					gyqdjk.setSpbh(resultSet.getString("SPBH"));
					gyqdjk.setGhkh(resultSet.getString("GHKH"));
					gyqdjk.setTdzh(resultSet.getString("TDZH"));
					gyqdjk.setJbr(resultSet.getString("JBR"));
					gyqdjk.setShr(resultSet.getString("SHR"));
					gyqdjk.setIslogout(resultSet.getInt("ISLOGOUT"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						gyqdjk.setDwdm(resultSet.getString("dwdm"));
					}else{								
						gyqdjk.setDwdm(dwdm);						
					}
					gyqdjk.setDymj(resultSet.getDouble("DYMJ"));
					gyqdjk.setFtmj(resultSet.getDouble("FTMJ"));
					gyqdjk.setZl(resultSet.getString("ZL"));
					System.out.println("共有权登记卡："+projectId);
					if(gyqdjkService.getGYQDJK(projectId)==null){
						gyqdjkService.insertGYQDJK(gyqdjk);												
					}else{
						gyqdjkService.updateGYQDJK(gyqdjk);
					}					
				}
				resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	public void impGhk(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID, QLR , DWXZ, TXDZ, RQ, DJH ,TH ,ZL ,QSXZ ,YT ,JBR ,GHKH,SFZMTYPE,ISLOGOUT, " +
				"DWDM, SFZMNUM ,TDZH, SYQLX, GHKID ,MJ ,OLDDJH from tbl_ghk",path,"");
		try {
			if(resultSet!=null){
				GHK ghk = new GHK();
				GHK ghk1 = new GHK();
				String projectId="";
				IGHKService ghkService = (IGHKService)Container.getBean("ghkService");
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					ghk.setProjectId(resultSet.getString("PROJECTID"));
					ghk.setQlr(resultSet.getString("QLR"));
					ghk.setDwxz(resultSet.getString("DWXZ"));
					ghk.setTxdz(resultSet.getString("TXDZ"));
					ghk.setRq(resultSet.getString("RQ"));
					ghk.setDjh(resultSet.getString("DJH"));
					ghk.setTh(resultSet.getString("TH"));
					ghk.setZl(resultSet.getString("ZL"));
					ghk.setQsxz(resultSet.getString("QSXZ"));
					ghk.setYt(resultSet.getString("YT"));
					ghk.setJbr(resultSet.getString("JBR"));
					ghk.setGhkh(resultSet.getString("GHKH"));
					ghk.setSfzmtype(resultSet.getString("SFZMTYPE"));
					ghk.setIslogout(resultSet.getInt("ISLOGOUT"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						ghk.setDwdm(resultSet.getString("dwdm"));
					}else{								
						ghk.setDwdm(dwdm);						
					}
					ghk.setSfzmnum(resultSet.getString("SFZMNUM"));
					ghk.setTdzh(resultSet.getString("TDZH"));
					ghk.setSyqlx(resultSet.getString("SYQLX"));
					//ghk.setGhkid(ghkid);
					ghk.setMj(resultSet.getDouble("MJ"));
					ghk.setOldDjh(resultSet.getString("OLDDJH"));
					System.out.println("归户卡："+projectId);
					ghk1 = ghkService.getGHK(projectId);
					if (ghk1==null){
						ghkService.insertGHK(ghk);
					}else{
						ghk.setGhkid(ghk1.getGhkid());
						ghkService.updateGHK(ghk);
					}					
				}
				resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/*
	 * 
	 */
	public void impFgz(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select FGZID ,PROJECTID ,FGZH, FGZXH, QLR, ZL, DJH, YT, ZZRQ, FZRQ, RF2_DWMC,JZMJ, " +
				"ISHZ, SH, LZH, DYH, HFZH, DWDM, ISPRINTED, DYMJ, FTMJ, SYQLX, OLDDJH from tbl_fgz",path,"");
		try {
			if(resultSet!=null){
				FGZ fgz = new FGZ();
				IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
				String fgzId = "";
			    while (resultSet.next()) {
					fgzId = resultSet.getString("FGZID");
					fgz.setFgzid(fgzId);	
					fgz.setProjectId(resultSet.getString("PROJECTID"));
					fgz.setFgzh(resultSet.getString("FGZH"));
					fgz.setFgzxh(resultSet.getInt("FGZXH"));
					fgz.setQlr(resultSet.getString("QLR"));
					fgz.setZl(resultSet.getString("ZL"));
					fgz.setDjh(resultSet.getString("DJH"));
					fgz.setYt(resultSet.getString("YT"));
					fgz.setZzrq(resultSet.getString("ZZRQ"));
					fgz.setFzrq(resultSet.getString("FZRQ"));
					fgz.setRf2_dwmc(resultSet.getString("RF2_DWMC"));
					fgz.setJzmj(resultSet.getDouble("JZMJ"));
					fgz.setIshz(resultSet.getInt("ISHZ"));
					fgz.setSh(resultSet.getString("SH"));
					fgz.setLzh(resultSet.getString("LZH"));
					fgz.setDyh(resultSet.getString("DYH"));
					fgz.setHfzh(resultSet.getString("HFZH"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						fgz.setDwdm(resultSet.getString("dwdm"));
					}else{								
						fgz.setDwdm(dwdm);						
					}
					fgz.setIsprinted(resultSet.getInt("ISPRINTED"));
					fgz.setDymj(resultSet.getDouble("DYMJ"));
					fgz.setFtmj(resultSet.getDouble("FTMJ"));
					fgz.setSyqlx(resultSet.getString("SYQLX"));
					fgz.setOldDjh(resultSet.getString("OLDDJH"));
					System.out.println("分割证："+fgzId);
					if (fgzService.getFGZById(fgzId)==null){
						fgzService.insertFGZ(fgz);
					}else{
						fgzService.updateFGZ(fgz);
					}
				}	
			    resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
		
	}
    /*
     * 单机版数据库的tbl_fginfo表不存在olddjh
     */
	public void impFginfo(String path)throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID,FGTYPE,ZTDZH,DJH,ZDMJ,ZJZMJ,ZL,TH,SYQLX,YT," +
				"ZZRQ,FDDBR,DWXZ,LXDH,TXDZ,QLR from tbl_fginfo",path,"");
		try {
			if (resultSet!=null){
			    FGINFO fginfo = new FGINFO();
			    IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
			    String projectId = "";
			    while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					fginfo.setProjectId(projectId);
					fginfo.setFgtype(resultSet.getString("FGTYPE"));
					fginfo.setZtdzh(resultSet.getString("ZTDZH"));
					fginfo.setDjh(resultSet.getString("DJH"));
					fginfo.setZdmj(resultSet.getString("ZDMJ"));
					fginfo.setZjzmj(resultSet.getDouble("ZJZMJ"));
					fginfo.setZl(resultSet.getString("ZL"));
					fginfo.setTh(resultSet.getString("TH"));
					fginfo.setSyqlx(resultSet.getString("SYQLX"));
					fginfo.setYt(resultSet.getString("YT"));
					fginfo.setZzrq(resultSet.getString("ZZRQ"));
					fginfo.setFddbr(resultSet.getString("FDDBR"));
					fginfo.setDwxz(resultSet.getString("DWXZ"));
					fginfo.setLxdh(resultSet.getString("LXDH"));
					fginfo.setTxdz(resultSet.getString("TXDZ"));
					fginfo.setQlr(resultSet.getString("QLR"));	
					System.out.println("分割信息："+projectId);
					if (fginfoService.getFGINFO(projectId)==null){
						fginfoService.insertFGINFO(fginfo);
					}else{
						fginfoService.updateFGINFO(fginfo);
					}
				}
			    resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}		
	}
	/*
	 * 单机版数据库的tbl_cf表不存在xbnr、dwdm
	 */
	public void impCf(String path)throws SQLException{
		 ResultSet resultSet = excuteSQL("select PROJECTID ,DJH ,TDZH, ZL ,ZXSQR ,BZXR ,ZXWH ,CDDW ," +
		 		"CFMJ ,SDRQ, CFKSRQ ,CFJSRQ ,CFYY ,CFLX ,ISJF from tbl_cf",path,"");
		try {
			if(resultSet!=null){
				CF cf = new CF();
				String projectId = "";
				ICFService cfService = (ICFService)Container.getBean("cfService");
				while (resultSet.next()) {
					projectId=resultSet.getString("PROJECTID");
					cf.setProjectId(projectId);
					cf.setDjh(resultSet.getString("DJH"));
					cf.setTdzh(resultSet.getString("TDZH"));
					cf.setZl(resultSet.getString("ZL"));
					cf.setZxsqr(resultSet.getString("ZXSQR"));
					cf.setBzxr(resultSet.getString("BZXR"));
					cf.setZxwh(resultSet.getString("ZXWH"));
					cf.setCddw(resultSet.getString("CDDW"));
					cf.setCfmj(resultSet.getString("CFMJ"));
					cf.setSdrq(CommonUtil.formateDateToStr(resultSet.getString("SDRQ")));
					cf.setCfksrq(CommonUtil.formateDateToStr(resultSet.getString("CFKSRQ")));
					cf.setCfjsrq(CommonUtil.formateDateToStr(resultSet.getString("CFJSRQ")));
					cf.setCfyy(resultSet.getString("CFYY"));
					cf.setCflx(resultSet.getString("CFLX"));
					cf.setIsjf(resultSet.getInt("ISJF"));
					System.out.println("查封："+cf.getProjectId());
					if (cfService.getCFByProjectId(projectId)==null){
						cfService.insertCF(cf);	
					}else{
						cfService.updateCF(cf);
					}					
				}
				resultSet.close();
				stmt.close();
			}				
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/**
	 * zdd
	 * 录入主卡及续表。如果主卡的地籍号在数据库中已经存在就更新。

	 * 根据主卡的地籍号找到对应的续表，续表因为没有办法确定主键，所以直接插入。续表的djkid使用已经插入的主卡ID
	 */
	public void impDjkAndXb(String path) throws SQLException{		
			    ResultSet resultSet = excuteSQL("select ZZRQ,ZL,YT,TXDZ,TH,SYQLX,QSXZ,QLR,PROJECTID,DWXZ,DJKID,TDZH,DJH, DCBH ,SPBH ,GHKH ,TDDJ ,BDDJ, JZRJL ,JZMD ,JZXG ,JZWZDMJ ,JZWLX ,SBJZWQS ,QSLY ,ISLOGOUT ,DWDM ,DJRQ ,DJKBH" +
	    		",SFZMTYPE ,SFZMNUM ,QDJG ,ZDMJ ,OLDDJH ,SYQX ,YB ,SYQMJ ,DYMJ ,FTMJ from tbl_djk",path,""); 
			    ResultSet xbResultSet = null;
	    try {
	    	if (resultSet!=null){
	    		DJK djk = new DJK();
	    		DJK djk1 = new DJK();
	    		String djh = "";
	    		IDJKService djkService = (IDJKService)Container.getBean("djkService");
		    	while (resultSet.next()) {
		    		djk.setBddj(resultSet.getString("bddj"));
		    		djk.setDcbh(resultSet.getString("dcbh"));
		    		djh = resultSet.getString("djh");
		    		djk.setDjh(djh);		    		
		    		djk.setDjkbh(resultSet.getString("djkbh"));
		    		//djk.setDjkId(resultSet.getInt("djkid"));		    		
		    		djk.setDjrq(resultSet.getString("djrq"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						djk.setDwdm(resultSet.getString("dwdm"));
					}else{								
						djk.setDwdm(dwdm);						
					}
		    		djk.setDwxz(resultSet.getString("dwxz"));
		    		djk.setDymj(resultSet.getDouble("dymj"));
		    		djk.setFtmj(resultSet.getDouble("ftmj"));
		    		djk.setGhkh(resultSet.getString("ghkh"));
		    		djk.setIslogout(resultSet.getInt("islogout"));
		    		djk.setJzmd(resultSet.getDouble("jzmd"));
		    		djk.setJzrjl(resultSet.getDouble("jzrjl"));
		    		djk.setJzwlx(resultSet.getString("jzwlx"));
		    		djk.setJzwzdmj(resultSet.getDouble("jzwzdmj"));		    		
		    		djk.setJzxg(resultSet.getDouble("jzxg"));
		    		djk.setProjectId(resultSet.getString("projectid"));
		    		djk.setQdjg(resultSet.getString("qdjg"));
		    		djk.setQlr(resultSet.getString("qlr"));
		    		djk.setQsly(resultSet.getString("qsly"));
		    		djk.setQsxz(resultSet.getString("qsxz"));
		    		//djk.setRq(resultSet.getString("rq"));
		    		djk.setSbjzwqs(resultSet.getString("sbjzwqs"));
		    		djk.setSfzmnum(resultSet.getString("sfzmnum"));
		    		djk.setSfzmtype(resultSet.getString("sfzmtype"));
		    		djk.setSpbh(resultSet.getString("spbh"));
		    		djk.setSyqlx(resultSet.getString("syqlx"));
		    		djk.setSyqmj(resultSet.getDouble("syqmj"));
		    		djk.setSyqx(resultSet.getString("syqx"));
		    		djk.setTddj(resultSet.getString("tddj"));
		    		djk.setTdzh(resultSet.getString("tdzh"));
		    		djk.setTh(resultSet.getString("th"));
		    		djk.setTxdz(resultSet.getString("txdz"));
		    		djk.setYb(resultSet.getString("yb"));
		    		djk.setYt(resultSet.getString("yt"));
		    		djk.setZdmj(resultSet.getString("zdmj"));
		    		djk.setZl(resultSet.getString("zl"));
		    		djk.setZzrq(resultSet.getString("zzrq"));
		    		System.out.println("主卡："+djh);
		    		djk1 = djkService.getDJKByDjh(djh);
		    		if (djk1==null){
		    			djkService.insertDJK(djk);
		    		}else{
		    			djk.setDjkId(djk1.getDjkId());
		    			djkService.updateDJK(djk);
		    		}
		    		//zdd 导入续表
		    		xbResultSet=excuteSQL("select DJKXBID ,DJKID ,PROJECTID ,DJH ,RQ, DJJS ,DJKJBR ,DJKSHR ,DJRQ ,DWDM ,TDZH ,ISLOGOUT ,ISPRINTED," +
		    				"DJKBH, BSM ,GHKH ,SQLX ,OLDDJH from zd_zcdj where djh = '"+djh+"'",path,"djkxb");
		    		if (xbResultSet!=null){
		    			DJKXB djkxb = new DJKXB();
		    			IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
		    			djk = djkService.getDJKByDjh(djh);
		    			djkxb.setDjh(djh);
		    			djkxb.setDjkId(djk.getDjkId());	
		    			String projectId = "";
		    			while (xbResultSet.next()) {
		    				//djkxb.setDjkxbid(xbResultSet.getInt("DJKXBID"));	
		    				projectId = xbResultSet.getString("PROJECTID");
		    				djkxb.setProjectId(projectId);		    				
		    				djkxb.setRq(xbResultSet.getString("RQ"));
		    				djkxb.setDjjs(xbResultSet.getString("DJJS"));
		    				djkxb.setDjkjbr(xbResultSet.getString("DJKJBR"));
		    				djkxb.setDjkshr(xbResultSet.getString("DJKSHR"));
		    				djkxb.setDjrq(xbResultSet.getString("DJRQ"));
							if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
								djkxb.setDwdm(resultSet.getString("dwdm"));
							}else{								
								djkxb.setDwdm(dwdm);						
							}
		    				djkxb.setTdzh(xbResultSet.getString("TDZH"));
		    				djkxb.setIslogout(xbResultSet.getInt("ISLOGOUT"));
		    				djkxb.setIsprinted(xbResultSet.getInt("ISPRINTED"));
		    				djkxb.setDjkbh(xbResultSet.getString("DJKBH"));
		    				djkxb.setBsm(xbResultSet.getInt("BSM"));
		    				djkxb.setGhkh(xbResultSet.getString("GHKH"));
		    				djkxb.setSqlx(xbResultSet.getString("SQLX"));
		    				djkxb.setOldDjh(xbResultSet.getString("OLDDJH"));	
		    				System.out.println("续表"+projectId);
		    				if(djkxbService.getDJKXB(projectId)==null){
		    					djkxbService.insertDJKXB(djkxb);
		    				}else{
		    					djkxbService.updateDJKXB(djkxb);
		    				}
		    				
						}
		    			xbResultSet.close();
		    			djkxbstmt.close();
		    			djkxbstmtconn.close();
		    		}		    		
				}
		    	resultSet.close();
		    	stmt.close();
		    	conn.close();
		    } 			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
	}
	/**
	 * CDJ  20100706
	 * 将mdb中表tbl_yydj数据导入到Oracle
	 * @throws SQLException
	 */
	public void impYydj(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,TDZH,DJH,SQR,SYQMJ,ZL,QLR,YYYY,YYYJ,SHR_SIGN,SHR,SHRQ,ISJC,JCRQ from tbl_yydj",path,"");
		try {
			if (resultSet!=null){
				YYDJ yydj = new YYDJ();
				IYYDJService yydjService = (IYYDJService)Container.getBean("yydjService");
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("projectId");
					yydj.setDjh(resultSet.getString("djh"));
					yydj.setIsjc(resultSet.getInt("isjc"));
					yydj.setJcrq(resultSet.getString("jcrq"));
					yydj.setProjectId(projectId);
					yydj.setQlr(resultSet.getString("qlr"));
					yydj.setShr(resultSet.getString("shr"));
					yydj.setShr_sign(resultSet.getString("shr_sign"));
					yydj.setShrq(resultSet.getString("shrq"));
					yydj.setSqr(resultSet.getString("sqr"));
					yydj.setSyqmj(resultSet.getString("syqmj"));
					yydj.setTdzh(resultSet.getString("tdzh"));
					yydj.setYyyj(resultSet.getString("yyyj"));
					yydj.setYyyy(resultSet.getString("yyyy"));
					yydj.setZl(resultSet.getString("zl"));
					System.out.println("异议登记"+projectId);
					if (yydjService.getYYDJ(projectId)==null){
						yydjService.insertYYDJ(yydj);
					}else{
						yydjService.updateYYDJ(yydj);
					}					
				}
				resultSet.close();
				stmt.close();
			}
			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	
	/**
	 * CDJ  20100706
	 * 将mdb中表TBL_ZSGS数据导入到Oracle
	 * @throws SQLException
	 */
//	public void impZsgs(String path) throws SQLException{	
//		ResultSet resultSet = excuteSQL("select PROJECTID,BH,TDZH,QLR,ZL,SYQMJ,ISLOGOUT,SQR,LXDH,SQRQ,ZXRQ,DJH from tbl_zsgs ",path);
//		try {
//			if (resultSet!=null){
//				ZSGS zsgs = new ZSGS();
//				IZSGSService zsgsService = (IZSGSService)Container.getBean("zsgsService");
//				while (resultSet.next()) {
//					zsgs.setBh(resultSet.getString("bh"));
//					zsgs.setDjh(resultSet.getString("djh"));
//					zsgs.setIslogout(resultSet.getInt("islogout"));
//					zsgs.setLxdh(resultSet.getString("lxdh"));
//					zsgs.setProjectId(resultSet.getString("projectId"));
//					zsgs.setQlr(resultSet.getString("qlr"));
//					zsgs.setSqr(resultSet.getString("sqr"));
//					zsgs.setSqrq(resultSet.getString("sqrq"));
//					zsgs.setSyqmj(resultSet.getDouble("syqmj"));
//					zsgs.setTdzh(resultSet.getString("tdzh"));
//					zsgs.setZl(resultSet.getString("zl"));
//					zsgs.setZxrq(resultSet.getString("zxrq"));
//					
//					zsgsService.insertZSGS(zsgs);
//				}
//			}
//			
//		} catch (Exception e) {
//			// TODO: handle exception
//			e.printStackTrace();
//		}
//	}
	
	/**
	 * CDJ  20100706
	 * 将mdb中表tbl_zxyy数据导入到Oracle
	 * @throws SQLException
	 */
//	public void impZxyy(String path) throws SQLException{	
//		ResultSet resultSet = excuteSQL("select PROJECTID,YYPROJECTID,ZXYY,ZXRQ,SHR,XBNR from tbl_zxyy",path);
//		try {
//			if (resultSet!=null){
//				ZXYY zxyy = new ZXYY();
//				IZXYYService zxyyService = (IZXYYService)Container.getBean("zxyyService");
//				while (resultSet.next()) {
//					zxyy.setProjectId(resultSet.getString("projectId"));
//					zxyy.setShr(resultSet.getString("shr"));
//					zxyy.setXbnr(resultSet.getString("xbnr"));
//					zxyy.setYyProjectId(resultSet.getString("yyProjectId"));
//					zxyy.setZxrq(resultSet.getString("zxrq"));
//					zxyy.setZxyy(resultSet.getString("zxyy"));
//					
//					zxyyService.insertZXYY(zxyy);
//				}
//			}
//			
//		} catch (Exception e) {
//			// TODO: handle exception
//			e.printStackTrace();
//		}
//	}
	
	/**
	 * CDJ  20100706
	 * 将mdb中表tbl_jttdsuz数据导入到Oracle
	 * 没有获取到字段值：ZSNO
	 * @throws SQLException
	 */
	public int impJttdsuz(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,TDZH,SYQR,ZL,DJH,TH,TDZMJ,NYD,GD,YD,LD,MCD,QTNYD,JSYD,WLYD,DWDM,FZRQ,ISLOGOUT,RMZF,OLDDATA,ISPRINTED,BZ,ZSNO from TBL_JTTDSUZ",path,"");
		int num=0;
		try {
			if (resultSet!=null){
				JTTDSUZ jttdsuz = new JTTDSUZ();
				IJttdsuzService jttdsuzService = (IJttdsuzService)Container.getBean("jtTdsuzService");
				resultSet.last(); //移到最后一行   
				num=resultSet.getRow();//得到当前行号，也就是记录数   
				resultSet.beforeFirst();
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("projectid");
					jttdsuz.setBz(resultSet.getString("bz"));
					jttdsuz.setDjh(resultSet.getString("djh"));
					if (resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						jttdsuz.setDwdm(resultSet.getString("dwdm"));						
					}else{
						jttdsuz.setDwdm(dwdm);
					}
					
					jttdsuz.setFzrq(resultSet.getString("fzrq"));
					jttdsuz.setGd(resultSet.getDouble("gd"));
					jttdsuz.setIslogout(resultSet.getInt("islogout"));
					jttdsuz.setIsprinted(resultSet.getInt("isprinted"));
		//			jttdsuz.setJs(resultSet.getString("js"));
					jttdsuz.setJsyd(resultSet.getDouble("jsyd"));
					jttdsuz.setLd(resultSet.getDouble("ld"));
					jttdsuz.setMcd(resultSet.getDouble("mcd"));
					jttdsuz.setNyd(resultSet.getDouble("nyd"));
					jttdsuz.setOlddata(resultSet.getInt("olddata"));
					jttdsuz.setProjectId(projectId);
					jttdsuz.setQtnyd(resultSet.getDouble("qtnyd"));
					jttdsuz.setRmzf(resultSet.getString("rmzf"));
					jttdsuz.setSyqr(resultSet.getString("syqr"));
					jttdsuz.setTdzh(resultSet.getString("tdzh"));
					jttdsuz.setTdzmj(resultSet.getDouble("tdzmj"));
					jttdsuz.setTh(resultSet.getString("th"));
					jttdsuz.setWlyd(resultSet.getDouble("wlyd"));
					jttdsuz.setYd(resultSet.getDouble("yd"));
					jttdsuz.setZl(resultSet.getString("zl"));
					jttdsuz.setZsno(resultSet.getString("zsno"));
					System.out.println("集体土地所有证书"+projectId);
				    if(jttdsuzService.getJTTDSUZ(projectId)==null){
				    	jttdsuzService.insertJTTDSUZ(jttdsuz);
				    }else{
				    	jttdsuzService.updateJTTDSUZ(jttdsuz);
				    }					
				}
				resultSet.close();
				stmt.close();
			}
			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
		return num;
	}
	/**
	 * cdj  20100706
	 * 将mdb中tbl_jttdsyz导入到Oracle
	 * 没有获取到字段值：BZ,ZSNO,OLDDJH
	 * @throws SQLException
	 */
	public int impJttdsyz(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,TDZH,QLR,SYQR,ZL,DJH,TH,YT,QDJG,SYQLX," +
				"ZZRQ,SYQMJ,DYMJ,FTMJ,DWDM,FZRQ,ISLOGOUT,RMZF,OLDDATA,ISPRINTED from TBL_JTTDSYZ",path,"");
		int num=0;
		try {
			if (resultSet!=null){
				JTTDSYZ jttdsyz = new JTTDSYZ();
				IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("JtTdsyzService");
				resultSet.last(); //移到最后一行   
				num=resultSet.getRow();//得到当前行号，也就是记录数   
				resultSet.beforeFirst();
				String projectId = "";
				while (resultSet.next()) {
					//jttdsyz.setBz(resultSet.getString("bz"));
					projectId = resultSet.getString("projectid");
					jttdsyz.setDjh(resultSet.getString("djh"));
					if (resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						jttdsyz.setDwdm(resultSet.getString("dwdm"));
					}else{						
						jttdsyz.setDwdm(dwdm);
					}
					
					jttdsyz.setDymj(resultSet.getDouble("dymj"));
					jttdsyz.setFtmj(resultSet.getDouble("ftmj"));
					jttdsyz.setFzrq(resultSet.getString("fzrq"));
					jttdsyz.setIslogout(resultSet.getInt("islogout"));
					jttdsyz.setIsprinted(resultSet.getInt("isprinted"));
					jttdsyz.setOlddata(resultSet.getInt("olddata"));
					jttdsyz.setProjectId(projectId);
					jttdsyz.setQdjg(resultSet.getString("qdjg"));
					jttdsyz.setQlr(resultSet.getString("qlr"));
					jttdsyz.setRmzf(resultSet.getString("rmzf"));
					jttdsyz.setSyqlx(resultSet.getString("syqlx"));
					jttdsyz.setSyqmj(resultSet.getDouble("syqmj"));
					jttdsyz.setSyqr(resultSet.getString("syqr"));
					jttdsyz.setTdzh(resultSet.getString("tdzh"));
					jttdsyz.setTh(resultSet.getString("th"));
					jttdsyz.setYt(resultSet.getString("yt"));
					jttdsyz.setZl(resultSet.getString("zl"));
					//jttdsyz.setZsno(resultSet.getString("zsno"));
					jttdsyz.setZzrq(resultSet.getString("zzrq"));
					System.out.println("集体土地使用证书"+projectId);
				    if(jttdsyzService.getJTTDSYZ(projectId)==null){
				    	jttdsyzService.insertJTTDSYZ(jttdsyz);				    	
				    }else{
				    	jttdsyzService.updateJTTDSYZ(jttdsyz);
				    }					
				}
				resultSet.close();
				stmt.close();
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
		return num;
	}
	
	/**cdj   20100706
	 * 将mdb中他项权利证明书导入到Oracle 
	 * mdb中缺少 TXMJ 字段
	 * 没有获取到字段值：ZSNO,OLDDJH,TXMJ
	 */
	public int impTxqlzms(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,TDZH,QLR,YWR,ZL,DJH,TH,QSXZ,YT,SYQLX," +
				"TXQL,QLSX,CXQX,DWDM,FZRQ,SDRQ,ISLOGOUT,RMZF,OLDDATA,ISPRINTED,BZ,SYQMJ,ZSNO from TBL_TXQLZMS",path,"");
		int num=0;
		try {
			if (resultSet!=null){
				TXQLZMS txqlzms = new TXQLZMS();
				ITxqlzmsService txqlzmsService = (ITxqlzmsService)Container.getBean("txqlzmsService");
				resultSet.last(); //移到最后一行   
				num=resultSet.getRow();//得到当前行号，也就是记录数   
				resultSet.beforeFirst();
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("projectid");
					txqlzms.setBz(resultSet.getString("bz"));
					txqlzms.setCxqx(resultSet.getString("cxqx"));
					txqlzms.setDjh(resultSet.getString("djh"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						txqlzms.setDwdm(resultSet.getString("dwdm"));
					}else{					
						txqlzms.setDwdm(dwdm);						
					}
					
					txqlzms.setFzrq(resultSet.getString("fzrq"));
					txqlzms.setIslogout(resultSet.getInt("islogout"));
					txqlzms.setIsprinted(resultSet.getInt("isprinted"));
					txqlzms.setOlddata(resultSet.getInt("olddata"));
					txqlzms.setProjectId(projectId);
					txqlzms.setQlr(resultSet.getString("qlr"));
					txqlzms.setQlsx(resultSet.getString("qlsx"));
					txqlzms.setQsxz(resultSet.getString("qsxz"));
					txqlzms.setRmzf(resultSet.getString("rmzf"));
					txqlzms.setSdrq(resultSet.getString("sdrq"));
					txqlzms.setSyqlx(resultSet.getString("syqlx"));
					txqlzms.setSyqmj(resultSet.getDouble("syqmj"));
					txqlzms.setTdzh(resultSet.getString("tdzh"));
					txqlzms.setTh(resultSet.getString("th"));
					txqlzms.setTxql(resultSet.getString("txql"));
					txqlzms.setYt(resultSet.getString("yt"));
					txqlzms.setYwr(resultSet.getString("ywr"));
					txqlzms.setZl(resultSet.getString("zl"));
					txqlzms.setZsno(resultSet.getString("zsno"));
					System.out.println("他项证书"+projectId);
					if(txqlzmsService.getTXQLZMS(projectId)==null){
						txqlzmsService.insertTXQLZMS(txqlzms);						
					}else{
						txqlzmsService.updateTXQLZMS(txqlzms);					
					}					
				}
				resultSet.close();
				stmt.close();
			}
			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
		return num;
	}
	
	/**
	 * cdj  20100706
	 * 将mdb中zd_sqdj数据导入到Oracle
	 * @throws SQLException
	 */
	public void impSqb(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,SQSBH,DW,SQLX,RF1,RF1_DWMC,RF1_SFZMTYPE,RF1_SFZMNUM," +
				"RF1_DWXZ,RF1_TXDZ,RF1_YB,RF1_FDDBR,RF1_LXR,RF1_LXDH,RF1_DZYJ,RF1_DLRXM,RF1_DLRZSH,RF1_DLJGMC,RF1_DLLXDH," +
				"RF2,RF2_DWMC,RF2_SFZMTYPE,RF2_SFZMNUM,RF2_DWXZ,RF2_TXDZ,RF2_YB,RF2_FDDBR,RF2_LXR,RF2_LXDH,RF2_DZYJ," +
				"RF2_DLRXM,RF2_DLRZSH,RF2_DLJGMC,RF2_DLLXDH,ZL,ZDMJ,YT,QLSLQK,QDJG,QSXZ,SYQLX,XYDZL,TXQLLX,QLSX,TXMJ," +
				"DYL,SDRQ,CXQX,DYJE,TDJG,TXQL,TXJS,SQDJDNR,BZ,RMZF,DWDM,BSM,ZTDZH,DJH,TH,ZZRQ,SYQMJ,DYMJ,FTMJ,DCBH," +
				"JZRJL,JZMD,JZXG,JZWZDMJ,JZWLX,SBJZWQS,SYQX ,ZDSZ from ZD_SQDJ",path,"");
		try {
			if (resultSet!=null){
				SQB sqb = new SQB();
				ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("PROJECTID");
					sqb.setBsm(resultSet.getInt("bsm"));
					sqb.setBz(resultSet.getString("bz"));
					sqb.setCxqx(resultSet.getString("cxqx"));
					sqb.setDcbh(resultSet.getString("dcbh"));
					sqb.setDjh(resultSet.getString("djh"));
					sqb.setDw(resultSet.getString("dw"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						sqb.setDwdm(resultSet.getString("dwdm"));
					}else{						
						sqb.setDwdm(dwdm);						
					}
					sqb.setDyje(resultSet.getString("dyje"));
					sqb.setDyl(resultSet.getString("dyl"));
					sqb.setDymj(resultSet.getDouble("dymj"));
					sqb.setFtmj(resultSet.getDouble("ftmj"));
					sqb.setJzmd(resultSet.getDouble("jzmd"));
					sqb.setJzrjl(resultSet.getDouble("jzrjl"));
					sqb.setJzwlx(resultSet.getString("jzwlx"));
					sqb.setJzwzdmj(resultSet.getDouble("jzwzdmj"));
					sqb.setJzxg(resultSet.getDouble("jzxg"));
					sqb.setProjectId(projectId);
					sqb.setQdjg(resultSet.getString("qdjg"));
					sqb.setQlslqk(resultSet.getString("qlslqk"));
					sqb.setQlsx(resultSet.getString("qlsx"));
					sqb.setQsxz(resultSet.getString("qsxz"));
					sqb.setRf1(resultSet.getString("rf1"));
					sqb.setRf1_dljgmc(resultSet.getString("rf1_dljgmc"));
					sqb.setRf1_dllxdh(resultSet.getString("rf1_dllxdh"));
					sqb.setRf1_dlrxm(resultSet.getString("rf1_dlrxm"));
					sqb.setRf1_dlrzsh(resultSet.getString("rf1_dlrzsh"));
					sqb.setRf1_dwmc(resultSet.getString("rf1_dwmc"));
					sqb.setRf1_dwxz(resultSet.getString("rf1_dwxz"));
					sqb.setRf1_dzyj(resultSet.getString("rf1_dzyj"));
					sqb.setRf1_fddbr(resultSet.getString("rf1_fddbr"));
					sqb.setRf1_lxdh(resultSet.getString("rf1_lxdh"));
					sqb.setRf1_lxr(resultSet.getString("rf1_lxr"));
					sqb.setRf1_sfzmnum(resultSet.getString("rf1_sfzmnum"));
					sqb.setRf1_sfzmtype(resultSet.getString("rf1_sfzmtype"));
					sqb.setRf1_txdz(resultSet.getString("rf1_txdz"));
					sqb.setRf1_yb(resultSet.getString("rf1_yb"));
					sqb.setRf2(resultSet.getString("rf2"));
					sqb.setRf2_dljgmc(resultSet.getString("rf2_dljgmc"));
					sqb.setRf2_dllxdh(resultSet.getString("rf2_dllxdh"));
					sqb.setRf2_dlrxm(resultSet.getString("rf2_dlrxm"));
					sqb.setRf2_dlrzsh(resultSet.getString("rf2_dlrzsh"));
					sqb.setRf2_dwmc(resultSet.getString("rf2_dwmc"));
					sqb.setRf2_dwxz(resultSet.getString("rf2_dwxz"));
					sqb.setRf2_dzyj(resultSet.getString("rf2_dzyj"));
					sqb.setRf2_fddbr(resultSet.getString("rf2_fddbr"));
					sqb.setRf2_lxdh(resultSet.getString("rf2_lxdh"));
					sqb.setRf2_lxr(resultSet.getString("rf2_lxr"));
					sqb.setRf2_sfzmnum(resultSet.getString("rf2_sfzmnum"));
					sqb.setRf2_sfzmtype(resultSet.getString("rf2_sfzmtype"));
					sqb.setRf2_txdz(resultSet.getString("rf2_txdz"));
					sqb.setRf2_yb(resultSet.getString("rf2_yb"));
					sqb.setRmzf(resultSet.getString("rmzf"));
					sqb.setSbjzwqs(resultSet.getString("sbjzwqs"));
					sqb.setSdrq(resultSet.getString("sdrq"));
					sqb.setSqdjdnr(resultSet.getString("sqdjdnr"));
					sqb.setSqlx(resultSet.getString("sqlx"));
					sqb.setSqsbh(resultSet.getString("sqsbh"));
					sqb.setSyqlx(resultSet.getString("syqlx"));
					sqb.setSyqmj(resultSet.getDouble("syqmj"));
					sqb.setSyqx(resultSet.getString("syqx"));
					sqb.setTdjg(resultSet.getString("tdjg"));
					sqb.setTh(resultSet.getString("th"));
					sqb.setTxjs(resultSet.getString("txjs"));
					sqb.setTxmj(resultSet.getDouble("txmj"));
					sqb.setTxql(resultSet.getString("txql"));
					sqb.setTxqllx(resultSet.getString("txqllx"));
					sqb.setXydzl(resultSet.getString("xydzl"));
					sqb.setYt(resultSet.getString("yt"));
					sqb.setZdmj(resultSet.getString("zdmj"));
					sqb.setZdsz(resultSet.getString("zdsz"));
					sqb.setZl(resultSet.getString("zl"));
					sqb.setZtdzh(resultSet.getString("ztdzh"));
					sqb.setZzrq(resultSet.getString("zzrq"));
					System.out.println("申请表："+projectId);
				    if(sqbService.getSQB(projectId)==null){
				    	sqbService.insertSQB(sqb);
				    }else{
				    	sqbService.updateSQB(sqb);
				    }					
				}
				resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/**
	 * cdj  20100706
	 * 将mdb中表zd_qssp数据导入到Oracle
	 * mdb中缺少 JBRQ 字段
	 * @throws SQLException
	 */
	public void impSpb(String path) throws SQLException{	
		ResultSet resultSet = excuteSQL("select PROJECTID,SPBH,DW,SQLX,RF1,RF1_DWMC,RF1_SFZMTYPE," +
				"RF1_SFZMNUM,RF1_DWXZ,RF1_TXDZ,RF1_YB,RF1_FDDBR,RF1_LXR,RF1_LXDH,RF1_DZYJ,RF2," +
				"RF2_DWMC ,RF2_SFZMTYPE,RF2_SFZMNUM,RF2_DWXZ,RF2_TXDZ,RF2_YB,RF2_FDDBR,RF2_LXR," +
				"RF2_LXDH,RF2_DZYJ,DJH,TH,ZL,ZDMJ,YT,QSXZ,SYQLX,SYQX,ZZRQ,QLSLQK,QDJG,SYQMJ,DYMJ," +
				"FTMJ,DCBH,ZTDZH,GD,YD,LD,CD,SFYD,GKYD,ZZYD,GGYD,TSYD,JTYD,SYYD,QTYD,JBNTMJ,JZRJL," +
				"JZMD,JZXG,JZWZDMJ,JZWLX,SBJZWQS,XYDZL,XYDZH,TXQLLX,QLSX,TXMJ,DYL,SDRQ,CXQX,DYJE,TDJG," +
				"TXQL,TXJS,QSLY,JS,XBNR,CSYJ,SCR_SIGN,SCR,SCRQ,CSZGZH,SHYJ,SHR_SIGN,SHR,SHRQ,SHZGZH," +
				"PZYJ,PZR_SIGN,PZR,PZRQ,RMZF,BZ,TDZH,DWDM,BSM,ZDSZ,JBR,JBR_SIGN,JBZGZH from ZD_QSSP",path,"");
		try {
			if (resultSet!=null){
				SPB spb = new SPB();
				ISPBService spbService = (ISPBService)Container.getBean("spbService");
				String projectId= "";
				while (resultSet.next()) {
					projectId = resultSet.getString("projectId");
					spb.setBsm(resultSet.getInt("bsm"));
					spb.setBz(resultSet.getString("bz"));
					spb.setCd(resultSet.getDouble("cd"));
					spb.setCsyj(resultSet.getString("csyj"));
					spb.setCszgzh(resultSet.getString("cszgzh"));
					spb.setCxqx(resultSet.getString("cxqx"));
					spb.setDcbh(resultSet.getString("dcbh"));
					spb.setDjh(resultSet.getString("djh"));
					spb.setDw(resultSet.getString("dw"));
					if(resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						spb.setDwdm(resultSet.getString("dwdm"));
					}else{						
						spb.setDwdm(dwdm);						
					}
					spb.setDyje(resultSet.getString("dyje"));
					spb.setDyl(resultSet.getString("dyl"));
					spb.setDymj(resultSet.getDouble("dymj"));
					spb.setFtmj(resultSet.getDouble("ftmj"));
					spb.setGd(resultSet.getDouble("gd"));
					spb.setGgyd(resultSet.getDouble("ggyd"));
					spb.setGkyd(resultSet.getDouble("gkyd"));
					spb.setJbntmj(resultSet.getDouble("jbntmj"));
					spb.setJbr(resultSet.getString("jbr"));
					spb.setJbr_sign(resultSet.getString("jbr_sign"));
					//spb.setJbrq(resultSet.getDate("jbrq"));
					spb.setJbzgzh(resultSet.getString("jbzgzh"));
					spb.setJs(resultSet.getString("js"));
					spb.setJtyd(resultSet.getDouble("jtyd"));
					spb.setJzmd(resultSet.getDouble("jzmd"));
					spb.setJzrjl(resultSet.getDouble("jzrjl"));
					spb.setJzwlx(resultSet.getString("jzwlx"));
					spb.setJzwzdmj(resultSet.getDouble("jzwzdmj"));
					spb.setJzxg(resultSet.getDouble("jzxg"));
					spb.setLd(resultSet.getDouble("ld"));
					spb.setProjectId(projectId);
					spb.setPzr(resultSet.getString("pzr"));
					spb.setPzr_sign(resultSet.getString("pzr_sign"));
					spb.setPzrq(resultSet.getDate("pzrq"));
					spb.setPzyj(resultSet.getString("pzyj"));
					spb.setQdjg(resultSet.getString("qdjg"));
					spb.setQlslqk(resultSet.getString("qlslqk"));
					spb.setQlsx(resultSet.getString("qlsx"));
					spb.setQsly(resultSet.getString("qsly"));
					spb.setQsxz(resultSet.getString("qsxz"));
					spb.setQtyd(resultSet.getDouble("qtyd"));
					spb.setRf1(resultSet.getString("rf1"));
					spb.setRf1_dwmc(resultSet.getString("rf1_dwmc"));
					spb.setRf1_dwxz(resultSet.getString("rf1_dwxz"));
					spb.setRf1_dzyj(resultSet.getString("rf1_dzyj"));
					spb.setRf1_fddbr(resultSet.getString("rf1_fddbr"));
					spb.setRf1_lxdh(resultSet.getString("rf1_lxdh"));
					spb.setRf1_lxr(resultSet.getString("rf1_lxr"));
					spb.setRf1_sfzmnum(resultSet.getString("rf1_sfzmnum"));
					spb.setRf1_sfzmtype(resultSet.getString("rf1_sfzmtype"));
					spb.setRf1_txdz(resultSet.getString("rf1_txdz"));
					spb.setRf1_yb(resultSet.getString("rf1_yb"));
					spb.setRf2(resultSet.getString("rf2"));
					spb.setRf2_dwmc(resultSet.getString("rf2_dwmc"));
					spb.setRf2_dwxz(resultSet.getString("rf2_dwxz"));
					spb.setRf2_dzyj(resultSet.getString("rf2_dzyj"));
					spb.setRf2_fddbr(resultSet.getString("rf2_fddbr"));
					spb.setRf2_lxdh(resultSet.getString("rf2_lxdh"));
					spb.setRf2_lxr(resultSet.getString("rf2_lxr"));
					spb.setRf2_sfzmnum(resultSet.getString("rf2_sfzmnum"));
					spb.setRf2_sfzmtype(resultSet.getString("rf2_sfzmtype"));
					spb.setRf2_txdz(resultSet.getString("rf2_txdz"));
					spb.setRf2_yb(resultSet.getString("rf2_yb"));
					spb.setRmzf(resultSet.getString("rmzf"));
					spb.setSbjzwqs(resultSet.getString("sbjzwqs"));
					spb.setScr(resultSet.getString("scr"));
					spb.setScr_sign(resultSet.getString("scr_sign"));
					spb.setScrq(resultSet.getDate("scrq"));
					spb.setSdrq(resultSet.getString("sdrq"));
					spb.setSfyd(resultSet.getDouble("sfyd"));
					spb.setShr(resultSet.getString("shr"));
					spb.setShr_sign(resultSet.getString("shr_sign"));
					spb.setShrq(resultSet.getDate("shrq"));
					spb.setShyj(resultSet.getString("shyj"));
					spb.setShzgzh(resultSet.getString("shzgzh"));
					spb.setSpbh(resultSet.getString("spbh"));
					spb.setSqlx(resultSet.getString("sqlx"));
					spb.setSyqlx(resultSet.getString("syqlx"));
					spb.setSyqmj(resultSet.getDouble("syqmj"));
					spb.setSyqx(resultSet.getString("syqx"));
					spb.setSyyd(resultSet.getDouble("syyd"));
					spb.setTdjg(resultSet.getString("tdjg"));
					spb.setTdzh(resultSet.getString("tdzh"));
					spb.setTh(resultSet.getString("th"));
					spb.setTsyd(resultSet.getDouble("tsyd"));
					spb.setTxjs(resultSet.getString("txjs"));
					spb.setTxmj(resultSet.getDouble("txmj"));
					spb.setTxql(resultSet.getString("txql"));
					spb.setTxqllx(resultSet.getString("txqllx"));
					spb.setXbnr(resultSet.getString("xbnr"));
					spb.setXydzh(resultSet.getString("xydzh"));
					spb.setXydzl(resultSet.getString("xydzl"));
					spb.setYd(resultSet.getDouble("yd"));
					spb.setYt(resultSet.getString("yt"));
					spb.setZdmj(resultSet.getString("zdmj"));
					spb.setZdsz(resultSet.getString("zdsz"));
					spb.setZl(resultSet.getString("zl"));
					spb.setZtdzh(resultSet.getString("ztdzh"));
					spb.setZzrq(resultSet.getString("zzrq"));
					spb.setZzyd(resultSet.getDouble("zzyd"));
					System.out.println("审批表"+projectId);
					if(spbService.getSPB(projectId)==null){
						spbService.insertSPB(spb);
					}else{
						spbService.updateSPB(spb);
					}					
				}
				resultSet.close();
				stmt.close();
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
	}
	/**
	 * cdj  20100706
	 * 将mdb中表tbl_gytdsyz数据导入到Oracle
	 * 没有获取到字段值： ZSNO,OLDDJH
	 * @throws SQLException
	 */
	public int impGytdsyz(String path) throws SQLException{
		ResultSet resultSet = excuteSQL("select PROJECTID,TDZH,QLR,ZL,DJH,TH,YT,QDJG,SYQLX,ZZRQ,FZRQ,DWDM,ISLOGOUT," +
				"RMZF,OLDDATA,ISPRINTED,BZ,SYQMJ,DYMJ,FTMJ from tbl_gytdsyz",path,""); 
		int num=0;
		try {
			if (resultSet!=null){
				GYTDSYZ gytdsyz = new GYTDSYZ();
				IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
				resultSet.last(); //移到最后一行   
				num=resultSet.getRow();//得到当前行号，也就是记录数   
				resultSet.beforeFirst();
				String projectId = "";
				while (resultSet.next()) {
					projectId = resultSet.getString("projectid");
					gytdsyz.setBz(resultSet.getString("bz"));
					gytdsyz.setDjh(resultSet.getString("djh"));
					if (resultSet.getString("dwdm")!=null && !resultSet.getString("dwdm").equals("")){
						gytdsyz.setDwdm(resultSet.getString("dwdm"));
					}else{						
						gytdsyz.setDwdm(dwdm);
					}				
					gytdsyz.setDymj(resultSet.getDouble("dymj"));
					gytdsyz.setFtmj(resultSet.getDouble("ftmj"));
					gytdsyz.setFzrq(resultSet.getString("fzrq"));
					gytdsyz.setIslogout(resultSet.getInt("islogout"));
					gytdsyz.setIsprinted(resultSet.getInt("isprinted"));
					gytdsyz.setOlddata(resultSet.getInt("olddata"));
					gytdsyz.setProjectId(projectId);
					gytdsyz.setQdjg(resultSet.getString("qdjg"));
					gytdsyz.setQlr(resultSet.getString("qlr"));
					gytdsyz.setRmzf(resultSet.getString("rmzf"));
					gytdsyz.setSyqlx(resultSet.getString("syqlx"));
					gytdsyz.setSyqmj(resultSet.getDouble("syqmj"));
					gytdsyz.setTdzh(resultSet.getString("tdzh"));
					gytdsyz.setTh(resultSet.getString("th"));
					gytdsyz.setYt(resultSet.getString("yt"));
					gytdsyz.setZl(resultSet.getString("zl"));
					//gytdsyz.setZsno(resultSet.getString("zsno"));
					gytdsyz.setZzrq(resultSet.getString("zzrq"));
					System.out.println("国有证书"+projectId);
					if(gytdsyzService.getGYTDSYZ(projectId)==null){
						gytdsyzService.insertGYTDSYZ(gytdsyz);
					}else{
						gytdsyzService.updateGYTDSYZ(gytdsyz);
					}					
				}
				resultSet.close();
				stmt.close();
			}
			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}finally{
			conn.close();
		}
		return num;
	}

}
