package com.jsegov.tddj.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.dao.CFDAO;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.vo.CF;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CfService implements ICFService{
	@Autowired
    CFDAO cfDAO;

	public String isCF(CF cf) {
		// TODO Auto-generated method stub
		return cfDAO.isCF(cf);
	}

	public void deleteCF(String projectId) {
		// TODO Auto-generated method stub
		cfDAO.deleteCF(projectId);
	}

	public void insertCF(CF cf) {
		// TODO Auto-generated method stub
		cfDAO.insertCF(cf);
	}

	public void updateCF(CF cf) {
		// TODO Auto-generated method stub
		cfDAO.updateCF(cf);
	}

	public List getCFByDjh(String djh) {
		// TODO Auto-generated method stub
		CF cf = new CF();
		cf.setDjh(djh);
		return cfDAO.getCF(cf);
	}

	public CF getCFByProjectId(String projectId) {
		// TODO Auto-generated method stub
		return cfDAO.getCF(projectId);
	}

	public List getCFByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		CF cf = new CF();
		cf.setTdzh(tdzh);
		return cfDAO.getCF(cf);
	}

	public List getCFByIsjf(Integer isjf) {
		// TODO Auto-generated method stub
		CF cf = new CF();
		cf.setIsjf(isjf);
		return cfDAO.getCF(cf);
	}

	public List<Object> expCf(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return cfDAO.expCf(map);
	}

    public void updateLhcf(CF cf, String projectId) {
   		if(cf==null){
   			cf = getCFByProjectId(projectId);
   		}
   		if(cf.getIsjf()==2){
   			if(cf.getLhxh()==null||cf.getLhxh()==0){
   				CF ycf = getCFByProjectId(cf.getYcfprojectId());
   				try {
   					List<CF> lhcfList = queryLhcfByLhxh(ycf.getLhxh(), 1, ycf.getTdzh(), ycf.getDjh());
   					for(CF lhcf:lhcfList){
   						lhcf.setLhxh(lhcf.getLhxh()+1);
   						updateCF(lhcf);
   					}
   				} catch (Exception e) {
   					e.printStackTrace();
   				}
   				cf.setLhxh(ycf.getLhxh()+1);
   				updateCF(cf);
   			}
   		}
   	}

   	/**
   	 * 根据轮候序号查询该序号之前还是之后的所有数据
   	 * @param lhxh （如果要查询>=(<=)某值 lhxh值设置为 该值-(+)1）
   	 * @param compare 用于判断大于小于还是等于 值大于0表示大于 等于0表示等于 小于0表示小于
   	 * @return
   	 */
   	public List<CF> queryLhcfByLhxh(int lhxh,Integer compare,String tdzh,String djh){
   		HashMap<String,Object> map = new HashMap<String, Object>();
   		map.put("tdzh", tdzh);
   		map.put("djh", djh);
   		map.put("isjf",2);
   		map.put("compare", Integer.valueOf(compare));
   		map.put("lhxh", lhxh);
   		return cfDAO.queryCfList(map);
   	}

   	public void updateNextLhxf(CF cf, String projectId) {
   		if(cf==null){
   			cf = getCFByProjectId(projectId);
   		}
   		//防止退回转发多次执行该操作 以判断当前是否还存在该证号或者djh的有效查封记录为标准
   		HashMap<String, Object> map = new HashMap<String, Object>();
   		List<Object> cfList = null;
   		map.put("isjf", 0);
   		if(cf.getCflx().equals("按证查封")){
   			map.put("tdzh", cf.getTdzh());
   			cfList = expCf(map);
   		}else{
   			map.put("djh", cf.getDjh());
   			cfList = expCf(map);
   		}
   		if(cfList==null||cfList.size()==0){
   			List<CF> lhcfList = queryLhcfByLhxh(cf.getLhxh(), 1, cf.getTdzh(), cf.getDjh());
   			if(lhcfList!=null&&lhcfList.size()>0){
   				Collections.sort(lhcfList, new Comparator<CF>() {
                       public int compare(CF o1, CF o2) {
                           return o1.getLhxh().compareTo(o2.getLhxh());
                       }
                   });
   			}
   			CF firstLhcf = lhcfList.get(0);
   			firstLhcf.setIsjf(0);
   			updateCF(firstLhcf);
   		}
   	}
    public List<CF> getCF(CF cf) {
        // TODO Auto-generated method stub
        return cfDAO.getCF(cf);
    }
}
